/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;
import org.jdesktop.application.ApplicationAction;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.application.utils.SwingHelper;

final class DefaultInputBlocker
extends Task.InputBlocker {
    private static final Logger logger = Logger.getLogger(DefaultInputBlocker.class.getName());
    private static final String PB_STRING_FORMAT_KEY = "progressBarStringFormat";
    public static final String ON_ESCAPE_ACTION_KEY = "onEscape";
    private JDialog modalDialog = null;

    DefaultInputBlocker(Task task, Task.BlockingScope scope, Object target, ApplicationAction action) {
        super(task, scope, target, action);
    }

    private void setActionTargetBlocked(boolean f2) {
        Action action = (Action)this.getTarget();
        action.setEnabled(!f2);
    }

    private void setComponentTargetBlocked(boolean f2) {
        Component c2 = (Component)this.getTarget();
        c2.setEnabled(!f2);
    }

    private void blockingDialogComponents(Component root, List<Component> rv) {
        String rootName = root.getName();
        if (rootName != null && rootName.startsWith("BlockingDialog")) {
            rv.add(root);
        }
        if (root instanceof Container) {
            for (Component child : ((Container)root).getComponents()) {
                this.blockingDialogComponents(child, rv);
            }
        }
    }

    private List<Component> blockingDialogComponents(Component root) {
        ArrayList<Component> rv = new ArrayList<Component>();
        this.blockingDialogComponents(root, rv);
        return rv;
    }

    private void injectBlockingDialogComponents(Component root) {
        ApplicationAction action;
        ResourceMap taskResourceMap = this.getTask().getResourceMap();
        if (taskResourceMap != null) {
            taskResourceMap.injectComponents(root);
        }
        if ((action = this.getAction()) != null) {
            ResourceMap actionResourceMap = action.getResourceMap();
            String actionName = action.getName();
            for (Component c2 : this.blockingDialogComponents(root)) {
                c2.setName(actionName + "." + c2.getName());
            }
            actionResourceMap.injectComponents(root);
        }
    }

    private JDialog createBlockingDialog() {
        JOptionPane optionPane = new JOptionPane();
        if (this.getTask().getUserCanCancel()) {
            JButton cancelButton = new JButton();
            cancelButton.setName("BlockingDialog.cancelButton");
            ActionListener doCancelTask = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ignore) {
                    DefaultInputBlocker.this.getTask().cancel(true);
                }
            };
            cancelButton.addActionListener(doCancelTask);
            optionPane.setOptions(new Object[]{cancelButton});
        } else {
            optionPane.setOptions(new Object[0]);
        }
        optionPane.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), ON_ESCAPE_ACTION_KEY);
        Component dialogOwner = (Component)this.getTarget();
        String taskTitle = this.getTask().getTitle();
        String dialogTitle = taskTitle == null ? "BlockingDialog" : taskTitle;
        final JDialog dialog = optionPane.createDialog((Component)((Object)SwingHelper.findRootPaneContainer(dialogOwner)), dialogTitle);
        dialog.setModal(true);
        dialog.setName("BlockingDialog");
        dialog.setDefaultCloseOperation(0);
        WindowAdapter dialogCloseListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                if (DefaultInputBlocker.this.getTask().getUserCanCancel()) {
                    DefaultInputBlocker.this.getTask().cancel(true);
                    dialog.setVisible(false);
                }
            }
        };
        dialog.addWindowListener(dialogCloseListener);
        optionPane.setName("BlockingDialog.optionPane");
        this.injectBlockingDialogComponents(dialog);
        this.recreateOptionPaneMessage(optionPane);
        dialog.pack();
        return dialog;
    }

    private void recreateOptionPaneMessage(JOptionPane optionPane) {
        Object message = optionPane.getMessage();
        if (message instanceof String) {
            Font font = optionPane.getFont();
            final JTextArea textArea = new JTextArea((String)message);
            textArea.setFont(font);
            int lh = textArea.getFontMetrics(font).getHeight();
            Insets margin = new Insets(0, 0, lh, 24);
            textArea.setMargin(margin);
            textArea.setEditable(false);
            textArea.setWrapStyleWord(true);
            textArea.setBackground(optionPane.getBackground());
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)textArea, "Center");
            final JProgressBar progressBar = new JProgressBar();
            progressBar.setName("BlockingDialog.progressBar");
            progressBar.setIndeterminate(true);
            PropertyChangeListener taskPCL = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e2) {
                    if ("progress".equals(e2.getPropertyName())) {
                        progressBar.setIndeterminate(false);
                        progressBar.setValue((Integer)e2.getNewValue());
                        DefaultInputBlocker.this.updateStatusBarString(progressBar);
                    } else if ("message".equals(e2.getPropertyName())) {
                        textArea.setText((String)e2.getNewValue());
                    }
                }
            };
            this.getTask().addPropertyChangeListener(taskPCL);
            panel.add((Component)progressBar, "South");
            this.injectBlockingDialogComponents(panel);
            if (progressBar.getClientProperty(PB_STRING_FORMAT_KEY) == null) {
                progressBar.putClientProperty(PB_STRING_FORMAT_KEY, progressBar.getString());
            }
            progressBar.setString("");
            optionPane.setMessage(panel);
        }
    }

    private void updateStatusBarString(JProgressBar progressBar) {
        if (!progressBar.isStringPainted()) {
            return;
        }
        String fmt = (String)progressBar.getClientProperty(PB_STRING_FORMAT_KEY);
        if (progressBar.getValue() <= 0) {
            progressBar.setString("");
        } else if (fmt == null) {
            progressBar.setString(null);
        } else {
            double pctComplete = (double)progressBar.getValue() / 100.0;
            long durSeconds = this.getTask().getExecutionDuration(TimeUnit.SECONDS);
            long durMinutes = durSeconds / 60L;
            long remSeconds = (long)(0.5 + (double)durSeconds / pctComplete) - durSeconds;
            long remMinutes = remSeconds / 60L;
            String s2 = String.format(fmt, durMinutes, durSeconds - durMinutes * 60L, remMinutes, remSeconds - remMinutes * 60L);
            progressBar.setString(s2);
        }
    }

    private void showBusyGlassPane(boolean f2) {
        RootPaneContainer rpc = SwingHelper.findRootPaneContainer((Component)this.getTarget());
        if (rpc != null) {
            if (f2) {
                JMenuBar menuBar = rpc.getRootPane().getJMenuBar();
                if (menuBar != null) {
                    menuBar.putClientProperty(this, menuBar.isEnabled());
                    menuBar.setEnabled(false);
                }
                BusyGlassPane glassPane = new BusyGlassPane();
                InputVerifier retainFocusWhileVisible = new InputVerifier(){

                    @Override
                    public boolean verify(JComponent c2) {
                        return !c2.isVisible();
                    }
                };
                glassPane.setInputVerifier(retainFocusWhileVisible);
                Component oldGlassPane = rpc.getGlassPane();
                rpc.getRootPane().putClientProperty(this, oldGlassPane);
                rpc.setGlassPane(glassPane);
                glassPane.setVisible(true);
                glassPane.revalidate();
            } else {
                JMenuBar menuBar = rpc.getRootPane().getJMenuBar();
                if (menuBar != null) {
                    boolean enabled = (Boolean)menuBar.getClientProperty(this);
                    menuBar.putClientProperty(this, null);
                    menuBar.setEnabled(enabled);
                }
                Component oldGlassPane = (Component)rpc.getRootPane().getClientProperty(this);
                rpc.getRootPane().putClientProperty(this, null);
                if (!oldGlassPane.isVisible()) {
                    rpc.getGlassPane().setVisible(false);
                }
                rpc.setGlassPane(oldGlassPane);
            }
        }
    }

    private int blockingDialogDelay() {
        Integer delay = null;
        String key = "BlockingDialogTimer.delay";
        ApplicationAction action = this.getAction();
        if (action != null) {
            ResourceMap actionResourceMap = action.getResourceMap();
            String actionName = action.getName();
            delay = actionResourceMap.getInteger(actionName + "." + key);
        }
        ResourceMap taskResourceMap = this.getTask().getResourceMap();
        if (delay == null && taskResourceMap != null) {
            delay = taskResourceMap.getInteger(key);
        }
        return delay == null ? 0 : delay;
    }

    private void showBlockingDialog(boolean f2) {
        if (f2) {
            if (this.modalDialog != null) {
                String msg = String.format("unexpected InputBlocker state [%s] %s", f2, this);
                logger.warning(msg);
                this.modalDialog.dispose();
            }
            this.modalDialog = this.createBlockingDialog();
            ActionListener showModalDialog = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    if (DefaultInputBlocker.this.modalDialog != null) {
                        DefaultInputBlocker.this.modalDialog.setVisible(true);
                    }
                }
            };
            Timer showModalDialogTimer = new Timer(this.blockingDialogDelay(), showModalDialog);
            showModalDialogTimer.setRepeats(false);
            showModalDialogTimer.start();
        } else if (this.modalDialog != null) {
            this.modalDialog.dispose();
            this.modalDialog = null;
        } else {
            String msg = String.format("unexpected InputBlocker state [%s] %s", f2, this);
            logger.warning(msg);
        }
    }

    @Override
    protected void block() {
        switch (this.getScope()) {
            case ACTION: {
                this.setActionTargetBlocked(true);
                break;
            }
            case COMPONENT: {
                this.setComponentTargetBlocked(true);
                break;
            }
            case WINDOW: 
            case APPLICATION: {
                this.showBusyGlassPane(true);
                this.showBlockingDialog(true);
            }
        }
    }

    @Override
    protected void unblock() {
        switch (this.getScope()) {
            case ACTION: {
                this.setActionTargetBlocked(false);
                break;
            }
            case COMPONENT: {
                this.setComponentTargetBlocked(false);
                break;
            }
            case WINDOW: 
            case APPLICATION: {
                this.showBusyGlassPane(false);
                this.showBlockingDialog(false);
            }
        }
    }

    private static class BusyGlassPane
    extends JPanel {
        BusyGlassPane() {
            super(null, false);
            this.setVisible(false);
            this.setOpaque(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
            MouseInputAdapter blockMouseEvents = new MouseInputAdapter(){};
            this.addMouseMotionListener(blockMouseEvents);
            this.addMouseListener(blockMouseEvents);
        }
    }
}

