/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.CSVReader;
import com.opencsv.bean.BeanFieldSingleValue;
import com.opencsv.bean.CsvConverter;
import com.opencsv.bean.HeaderColumnNameMappingStrategy;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.ListValuedMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.similarity.LevenshteinDistance;

public class FuzzyMappingStrategy<T>
extends HeaderColumnNameMappingStrategy<T> {
    @Override
    protected void loadUnadornedFieldMap(ListValuedMap<Class<?>, Field> fields) {
    }

    @Override
    public void captureHeader(CSVReader reader) throws IOException, CsvRequiredFieldEmptyException {
        super.captureHeader(reader);
        Set<String> unusedHeaders = Stream.of(this.headerIndex.getHeaderIndex()).filter(Objects::nonNull).filter(k2 -> this.fieldMap.get(k2.toUpperCase()) == null).collect(Collectors.toSet());
        ListValuedMap<Class<?>, Field> unusedFields = this.partitionFields().get(Boolean.FALSE);
        LevenshteinDistance levenshtein = LevenshteinDistance.getDefaultInstance();
        LinkedList<Object> comparisons = new LinkedList<Object>();
        unusedHeaders.forEach(h2 -> unusedFields.entries().forEach(f2 -> comparisons.add(new FuzzyComparison(levenshtein.apply(h2.toUpperCase(), ((Field)f2.getValue()).getName().toUpperCase()), (String)h2, (Class)f2.getKey(), (Field)f2.getValue()))));
        comparisons.sort(null);
        while (!comparisons.isEmpty()) {
            FuzzyComparison fc2 = (FuzzyComparison)comparisons.get(0);
            CsvConverter converter = this.determineConverter(fc2.field, fc2.field.getType(), null, null, null);
            this.fieldMap.put(fc2.header.toUpperCase(), new BeanFieldSingleValue(fc2.type, fc2.field, false, this.errorLocale, converter, null, null));
            comparisons.removeIf(e2 -> StringUtils.equals(e2.header, fc2.header) || Objects.equals(e2.field, fc2.field));
        }
    }

    private static class FuzzyComparison
    implements Comparable<FuzzyComparison> {
        final Integer distance;
        final String header;
        final Class<?> type;
        final Field field;

        FuzzyComparison(Integer distance, String header, Class<?> type, Field field) {
            this.distance = distance;
            this.header = header;
            this.type = type;
            this.field = field;
        }

        @Override
        public int compareTo(FuzzyComparison o2) {
            return Integer.compare(this.distance, o2.distance);
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof FuzzyComparison)) {
                return false;
            }
            FuzzyComparison that = (FuzzyComparison)o2;
            return Objects.equals(this.distance, that.distance);
        }

        public int hashCode() {
            return Objects.hash(this.distance);
        }
    }
}

