/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.CSVReader;
import com.opencsv.bean.BeanVerifier;
import com.opencsv.bean.CsvToBeanFilter;
import com.opencsv.bean.MappingStrategy;
import com.opencsv.bean.concurrent.LineExecutor;
import com.opencsv.bean.concurrent.OrderedObject;
import com.opencsv.bean.concurrent.ProcessCsvLine;
import com.opencsv.exceptions.CsvException;
import com.opencsv.exceptions.CsvMalformedLineException;
import com.opencsv.exceptions.CsvValidationException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;

public class CsvToBean<T>
implements Iterable<T> {
    private final List<CsvException> capturedExceptions = new LinkedList<CsvException>();
    private MappingStrategy<? extends T> mappingStrategy;
    private CSVReader csvReader;
    private CsvToBeanFilter filter = null;
    private boolean throwExceptions = true;
    private boolean orderedResults = true;
    private long lineProcessed;
    private String[] line;
    private LineExecutor<T> executor;
    private Locale errorLocale = Locale.getDefault();
    private List<BeanVerifier<T>> verifiers = Collections.emptyList();
    private boolean ignoreEmptyLines = false;

    private void submitAllBeans() throws IOException, InterruptedException, CsvValidationException {
        while (null != (this.line = this.csvReader.readNext())) {
            if (this.isRecordEmpty(this.line) && this.ignoreEmptyLines) continue;
            this.lineProcessed = this.csvReader.getLinesRead();
            this.executor.submitLine(this.lineProcessed, this.mappingStrategy, this.filter, this.verifiers, this.line, this.throwExceptions);
        }
        this.executor.complete();
    }

    private boolean isRecordEmpty(String[] line) {
        return line == null || line.length == 0 || line.length == 1 && line[0].isEmpty();
    }

    public List<T> parse() throws IllegalStateException {
        return this.stream().collect(Collectors.toList());
    }

    public Stream<T> stream() throws IllegalStateException {
        this.prepareToReadInput();
        this.executor = new LineExecutor(this.orderedResults);
        this.executor.prepare();
        try {
            this.submitAllBeans();
        }
        catch (RejectedExecutionException e2) {
            if (this.executor.getTerminalException() instanceof CsvException) {
                CsvException csve = (CsvException)this.executor.getTerminalException();
                throw new RuntimeException(String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("parsing.error.linenumber"), csve.getLineNumber(), String.join((CharSequence)",", csve.getLine())), csve);
            }
            throw new RuntimeException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("parsing.error"), this.executor.getTerminalException());
        }
        catch (CsvMalformedLineException cmle) {
            this.executor.shutdownNow();
            throw new RuntimeException(String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("parsing.error.full"), cmle.getLineNumber(), cmle.getContext()), cmle);
        }
        catch (Exception e3) {
            this.executor.shutdownNow();
            throw new RuntimeException(String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("parsing.error.full"), this.lineProcessed, Arrays.toString(this.line)), e3);
        }
        return this.executor.resultStream();
    }

    public List<CsvException> getCapturedExceptions() {
        return this.executor != null ? this.executor.getCapturedExceptions() : this.capturedExceptions;
    }

    public void setMappingStrategy(MappingStrategy<? extends T> mappingStrategy) {
        this.mappingStrategy = mappingStrategy;
    }

    public void setCsvReader(CSVReader csvReader) {
        this.csvReader = csvReader;
    }

    public void setFilter(CsvToBeanFilter filter) {
        this.filter = filter;
    }

    public void setThrowExceptions(boolean throwExceptions) {
        this.throwExceptions = throwExceptions;
    }

    public void setOrderedResults(boolean orderedResults) {
        this.orderedResults = orderedResults;
    }

    public void setErrorLocale(Locale errorLocale) {
        this.errorLocale = ObjectUtils.defaultIfNull(errorLocale, Locale.getDefault());
        if (this.csvReader != null) {
            this.csvReader.setErrorLocale(this.errorLocale);
        }
        if (this.mappingStrategy != null) {
            this.mappingStrategy.setErrorLocale(this.errorLocale);
        }
    }

    public void setVerifiers(List<BeanVerifier<T>> verifiers) {
        this.verifiers = ObjectUtils.defaultIfNull(verifiers, Collections.emptyList());
    }

    private void prepareToReadInput() throws IllegalStateException {
        if (this.mappingStrategy == null || this.csvReader == null) {
            throw new IllegalStateException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("specify.strategy.reader"));
        }
        try {
            this.mappingStrategy.captureHeader(this.csvReader);
        }
        catch (Exception e2) {
            throw new RuntimeException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("header.error"), e2);
        }
        this.lineProcessed = 0L;
        this.line = null;
    }

    @Override
    public Iterator<T> iterator() {
        this.prepareToReadInput();
        return new CsvToBeanIterator();
    }

    public void setIgnoreEmptyLines(boolean ignoreEmptyLines) {
        this.ignoreEmptyLines = ignoreEmptyLines;
    }

    static /* synthetic */ String[] access$102(CsvToBean x0, String[] x1) {
        x0.line = x1;
        return x1;
    }

    private class CsvToBeanIterator
    implements Iterator<T> {
        private BlockingQueue<OrderedObject<T>> resultantBeansQueue = new ArrayBlockingQueue(1);
        private BlockingQueue<OrderedObject<CsvException>> thrownExceptionsQueue = new ArrayBlockingQueue<OrderedObject<CsvException>>(1);
        private T bean;

        CsvToBeanIterator() {
            this.readSingleLine();
        }

        private void processException() {
            OrderedObject o2 = (OrderedObject)this.thrownExceptionsQueue.poll();
            if (o2 != null && o2.getElement() != null) {
                CsvToBean.this.capturedExceptions.add(o2.getElement());
            }
        }

        private void readLineWithPossibleError() throws IOException, CsvValidationException {
            this.bean = null;
            while (this.bean == null && null != CsvToBean.access$102(CsvToBean.this, CsvToBean.this.csvReader.readNext())) {
                if (CsvToBean.this.isRecordEmpty(CsvToBean.this.line) && CsvToBean.this.ignoreEmptyLines) continue;
                CsvToBean.this.lineProcessed = CsvToBean.this.csvReader.getLinesRead();
                ProcessCsvLine proc = new ProcessCsvLine(CsvToBean.this.lineProcessed, CsvToBean.this.mappingStrategy, CsvToBean.this.filter, CsvToBean.this.verifiers, CsvToBean.this.line, this.resultantBeansQueue, this.thrownExceptionsQueue, CsvToBean.this.throwExceptions);
                proc.run();
                if (!this.thrownExceptionsQueue.isEmpty()) {
                    this.processException();
                    continue;
                }
                OrderedObject o2 = (OrderedObject)this.resultantBeansQueue.poll();
                this.bean = o2 == null ? null : o2.getElement();
            }
            if (CsvToBean.this.line == null) {
                this.bean = null;
            }
        }

        private void readSingleLine() {
            try {
                this.readLineWithPossibleError();
            }
            catch (CsvValidationException | IOException e2) {
                CsvToBean.access$102(CsvToBean.this, null);
                throw new RuntimeException(String.format(ResourceBundle.getBundle("opencsv", CsvToBean.this.errorLocale).getString("parsing.error"), CsvToBean.this.lineProcessed, Arrays.toString(CsvToBean.this.line)), e2);
            }
        }

        @Override
        public boolean hasNext() {
            return this.bean != null;
        }

        @Override
        public T next() {
            if (this.bean == null) {
                throw new NoSuchElementException();
            }
            Object intermediateBean = this.bean;
            this.readSingleLine();
            return intermediateBean;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(ResourceBundle.getBundle("opencsv", CsvToBean.this.errorLocale).getString("read.only.iterator"));
        }
    }
}

