/*
 * Decompiled with CFR 0.152.
 */
package com.jtechdev.macwidgets.plaf;

import com.jtechdev.macwidgets.plaf.UnifiedToolbarButtonUI;
import com.jtechdev.widgets.WindowUtils;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JComponent;

public class PreferencesTabBarButtonUI
extends UnifiedToolbarButtonUI {
    private static final Color TRANSPARENT_COLOR = new Color(0, 0, 0, 0);
    private static final Color UNFOCUSED_BACKGROUND_CENTER_COLOR = new Color(0, 0, 0, 29);
    private static final Color UNFOCUSED_INNER_BORDER_COLOR = new Color(0, 0, 0, 38);
    private static final Color UNFOCUSED_OUTER_BORDER_COLOR = new Color(0, 0, 0, 63);
    private static final Color FOCUSED_BACKGROUND_CENTER_COLOR = new Color(0, 0, 0, 56);
    private static final Color FOCUSED_INNER_BORDER_COLOR = new Color(0, 0, 0, 80);
    private static final Color FOCUSED_OUTER_BORDER_COLOR = new Color(0, 0, 0, 130);

    @Override
    protected void installDefaults(AbstractButton b2) {
        super.installDefaults(b2);
        b2.setBorder(BorderFactory.createEmptyBorder(5, 5, 4, 5));
        b2.setOpaque(false);
    }

    @Override
    protected void uninstallDefaults(AbstractButton b2) {
        super.uninstallDefaults(b2);
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        AbstractButton b2 = (AbstractButton)c2;
        ButtonModel model = b2.getModel();
        if (model.isSelected()) {
            Graphics2D graphics = (Graphics2D)g2.create();
            PreferencesTabBarButtonUI.paintSelectedButtonBackground(b2, graphics);
            graphics.dispose();
        }
        super.paint(g2, c2);
    }

    private static void paintSelectedButtonBackground(AbstractButton button, Graphics2D graphics) {
        boolean isButtonsWindowFocused = WindowUtils.isParentWindowFocused(button);
        Color centerColor = isButtonsWindowFocused ? FOCUSED_BACKGROUND_CENTER_COLOR : UNFOCUSED_BACKGROUND_CENTER_COLOR;
        Color innerBorderColor = isButtonsWindowFocused ? FOCUSED_INNER_BORDER_COLOR : UNFOCUSED_INNER_BORDER_COLOR;
        Color outterBorderColor = isButtonsWindowFocused ? FOCUSED_OUTER_BORDER_COLOR : UNFOCUSED_OUTER_BORDER_COLOR;
        int topMiddleY = button.getHeight() / 2;
        int bottomMiddleY = button.getHeight() / 2 + 1;
        GradientPaint topCenterPaint = new GradientPaint(0.0f, 0.0f, TRANSPARENT_COLOR, 1.0f, topMiddleY, centerColor);
        GradientPaint bottomCenterPaint = new GradientPaint(0.0f, bottomMiddleY, centerColor, 1.0f, button.getHeight(), TRANSPARENT_COLOR);
        graphics.setPaint(topCenterPaint);
        int borderWidth = 2;
        int fillWidth = button.getWidth() - borderWidth * 2;
        graphics.fillRect(borderWidth, 0, fillWidth, topMiddleY);
        graphics.setPaint(bottomCenterPaint);
        graphics.fillRect(borderWidth, topMiddleY, fillWidth, button.getHeight());
        GradientPaint topOuterBorderPaint = new GradientPaint(0.0f, 0.0f, TRANSPARENT_COLOR, 1.0f, topMiddleY, outterBorderColor);
        GradientPaint bottomOuterBorderPaint = new GradientPaint(0.0f, bottomMiddleY, outterBorderColor, 1.0f, button.getHeight(), TRANSPARENT_COLOR);
        graphics.setPaint(topOuterBorderPaint);
        int outterLeftBorderX = 0;
        int outterRightBorderX = button.getWidth() - 1;
        graphics.drawLine(outterLeftBorderX, 0, outterLeftBorderX, topMiddleY);
        graphics.drawLine(outterRightBorderX, 0, outterRightBorderX, topMiddleY);
        graphics.setPaint(bottomOuterBorderPaint);
        graphics.drawLine(outterLeftBorderX, bottomMiddleY, outterLeftBorderX, button.getHeight());
        graphics.drawLine(outterRightBorderX, bottomMiddleY, outterRightBorderX, button.getHeight());
        GradientPaint topInnerBorderPaint = new GradientPaint(0.0f, 0.0f, TRANSPARENT_COLOR, 1.0f, topMiddleY, innerBorderColor);
        GradientPaint bottomInnerBorderPaint = new GradientPaint(0.0f, bottomMiddleY, innerBorderColor, 1.0f, button.getHeight(), TRANSPARENT_COLOR);
        graphics.setPaint(topInnerBorderPaint);
        int innerLeftBorderX = 1;
        int innerRightBorderX = button.getWidth() - 2;
        graphics.drawLine(innerLeftBorderX, 0, innerLeftBorderX, topMiddleY);
        graphics.drawLine(innerRightBorderX, 0, innerRightBorderX, topMiddleY);
        graphics.setPaint(bottomInnerBorderPaint);
        graphics.drawLine(innerLeftBorderX, bottomMiddleY, innerLeftBorderX, button.getHeight());
        graphics.drawLine(innerRightBorderX, bottomMiddleY, innerRightBorderX, button.getHeight());
    }
}

