/*
 * Decompiled with CFR 0.152.
 */
package com.jtechdev.macwidgets;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jtechdev.data.Rating;
import com.jtechdev.data.RatingChangeListener;
import com.jtechdev.macwidgets.ITunesRatingTableCellRenderer;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RatingComponent {
    private JPanel fComponent = new JPanel();
    private Rating fRating;
    private boolean fSelected;
    private boolean fFocused = true;
    private List<JLabel> fRatingIndicators = new ArrayList<JLabel>();
    private List<RatingChangeListener> fListeners = new ArrayList<RatingChangeListener>();
    private static ImageIcon FOCUSED_SELECTED_STAR = new ImageIcon(ITunesRatingTableCellRenderer.class.getResource("/com/jtechdev/macwidgets/images/itunes_star_focused_selected.png"));
    private static ImageIcon UNFOCUSED_SELECTED_STAR = new ImageIcon(ITunesRatingTableCellRenderer.class.getResource("/com/jtechdev/macwidgets/images/itunes_star_unfocused_selected.png"));
    private static ImageIcon UNSELECTED_STAR = new ImageIcon(ITunesRatingTableCellRenderer.class.getResource("/com/jtechdev/macwidgets/images/itunes_star_unselected.png"));
    private static ImageIcon UNFOCUSED_DOT = new ImageIcon(ITunesRatingTableCellRenderer.class.getResource("/com/jtechdev/macwidgets/images/itunes_dot_unfocused.png"));
    private static ImageIcon FOCUSED_DOT = new ImageIcon(ITunesRatingTableCellRenderer.class.getResource("/com/jtechdev/macwidgets/images/itunes_dot_focused.png"));

    public RatingComponent(Rating rating) {
        this.setRating(rating);
        this.fComponent.setOpaque(false);
    }

    private void buildRatingPanel() {
        this.fRatingIndicators.clear();
        this.fComponent.removeAll();
        FormLayout layout = new FormLayout("", "fill:p:grow");
        PanelBuilder builder = new PanelBuilder(layout, this.fComponent);
        for (int i2 = 0; i2 < Rating.values().length - 1; ++i2) {
            RatingLabel label = new RatingLabel(i2);
            this.fRatingIndicators.add(label);
            builder.appendColumn("p");
            builder.add((Component)label, new CellConstraints().xy(builder.getColumn(), 1));
            builder.nextColumn();
        }
    }

    private MouseListener createMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
            }
        };
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public void setSelected(boolean selected) {
        this.fSelected = selected;
    }

    public void setFocused(boolean focused) {
        this.fFocused = focused;
    }

    public void setRating(Rating rating) {
        this.fRating = rating;
        this.buildRatingPanel();
    }

    public void addRatingChangeListener(RatingChangeListener listener) {
        this.fListeners.add(listener);
    }

    public void removeRatingChangeListener(RatingChangeListener listener) {
        this.fListeners.remove(listener);
    }

    private class RatingLabel
    extends JLabel {
        private int fPosition;

        private RatingLabel(int position) {
            this.fPosition = position;
        }

        @Override
        public Icon getIcon() {
            Icon retVal = null;
            if (RatingComponent.this.fRating == null || RatingComponent.this.fRating == Rating.NO_RATING) {
                retVal = null;
            } else if (this.fPosition < RatingComponent.this.fRating.ordinal()) {
                retVal = this.getStarIcon();
            } else if (RatingComponent.this.fSelected) {
                retVal = this.getDotIcon();
            }
            return retVal;
        }

        private Icon getStarIcon() {
            ImageIcon retVal = !RatingComponent.this.fSelected ? UNSELECTED_STAR : (RatingComponent.this.fFocused ? FOCUSED_SELECTED_STAR : UNFOCUSED_SELECTED_STAR);
            return retVal;
        }

        private Icon getDotIcon() {
            ImageIcon retVal = null;
            retVal = RatingComponent.this.fFocused ? FOCUSED_DOT : UNFOCUSED_DOT;
            return retVal;
        }
    }
}

