/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ImageMath;
import java.io.Serializable;

public class WarpGrid
implements Serializable {
    static final long serialVersionUID = 4312410199770201968L;
    public float[] xGrid = null;
    public float[] yGrid = null;
    public int rows;
    public int cols;
    private static final float m00 = -0.5f;
    private static final float m01 = 1.5f;
    private static final float m02 = -1.5f;
    private static final float m03 = 0.5f;
    private static final float m10 = 1.0f;
    private static final float m11 = -2.5f;
    private static final float m12 = 2.0f;
    private static final float m13 = -0.5f;
    private static final float m20 = -0.5f;
    private static final float m22 = 0.5f;
    private static final float m31 = 1.0f;

    public WarpGrid(int rows, int cols, int w2, int h2) {
        this.rows = rows;
        this.cols = cols;
        this.xGrid = new float[rows * cols];
        this.yGrid = new float[rows * cols];
        int index = 0;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                this.xGrid[index] = (float)col * (float)(w2 - 1) / (float)(cols - 1);
                this.yGrid[index] = (float)row * (float)(h2 - 1) / (float)(rows - 1);
                ++index;
            }
        }
    }

    public void addRow(int before) {
        int size = (this.rows + 1) * this.cols;
        float[] x2 = new float[size];
        float[] y2 = new float[size];
        ++this.rows;
        int i2 = 0;
        int j2 = 0;
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.cols; ++col) {
                int k2 = j2 + col;
                int l2 = i2 + col;
                if (row == before) {
                    x2[k2] = (this.xGrid[l2] + this.xGrid[k2]) / 2.0f;
                    y2[k2] = (this.yGrid[l2] + this.yGrid[k2]) / 2.0f;
                    continue;
                }
                x2[k2] = this.xGrid[l2];
                y2[k2] = this.yGrid[l2];
            }
            if (row != before - 1) {
                i2 += this.cols;
            }
            j2 += this.cols;
        }
        this.xGrid = x2;
        this.yGrid = y2;
    }

    public void addCol(int before) {
        int size = this.rows * (this.cols + 1);
        float[] x2 = new float[size];
        float[] y2 = new float[size];
        ++this.cols;
        int i2 = 0;
        int j2 = 0;
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.cols; ++col) {
                if (col == before) {
                    x2[j2] = (this.xGrid[i2] + this.xGrid[i2 - 1]) / 2.0f;
                    y2[j2] = (this.yGrid[i2] + this.yGrid[i2 - 1]) / 2.0f;
                } else {
                    x2[j2] = this.xGrid[i2];
                    y2[j2] = this.yGrid[i2];
                    ++i2;
                }
                ++j2;
            }
        }
        this.xGrid = x2;
        this.yGrid = y2;
    }

    public void removeRow(int r2) {
        int size = (this.rows - 1) * this.cols;
        float[] x2 = new float[size];
        float[] y2 = new float[size];
        --this.rows;
        int i2 = 0;
        int j2 = 0;
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.cols; ++col) {
                int k2 = j2 + col;
                int l2 = i2 + col;
                x2[k2] = this.xGrid[l2];
                y2[k2] = this.yGrid[l2];
            }
            if (row == r2 - 1) {
                i2 += this.cols;
            }
            i2 += this.cols;
            j2 += this.cols;
        }
        this.xGrid = x2;
        this.yGrid = y2;
    }

    public void removeCol(int r2) {
        int size = this.rows * (this.cols + 1);
        float[] x2 = new float[size];
        float[] y2 = new float[size];
        --this.cols;
        for (int row = 0; row < this.rows; ++row) {
            int i2 = row * (this.cols + 1);
            int j2 = row * this.cols;
            for (int col = 0; col < this.cols; ++col) {
                x2[j2] = this.xGrid[i2];
                y2[j2] = this.yGrid[i2];
                if (col == r2 - 1) {
                    ++i2;
                }
                ++i2;
                ++j2;
            }
        }
        this.xGrid = x2;
        this.yGrid = y2;
    }

    public void lerp(float t2, WarpGrid destination, WarpGrid intermediate) {
        if (this.rows != destination.rows || this.cols != destination.cols) {
            throw new IllegalArgumentException("source and destination are different sizes");
        }
        if (this.rows != intermediate.rows || this.cols != intermediate.cols) {
            throw new IllegalArgumentException("source and intermediate are different sizes");
        }
        int index = 0;
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.cols; ++col) {
                intermediate.xGrid[index] = ImageMath.lerp(t2, this.xGrid[index], destination.xGrid[index]);
                intermediate.yGrid[index] = ImageMath.lerp(t2, this.yGrid[index], destination.yGrid[index]);
                ++index;
            }
        }
    }

    public void warp(int[] inPixels, int cols, int rows, WarpGrid sourceGrid, WarpGrid destGrid, int[] outPixels) {
        try {
            int y2;
            int v2;
            int i2;
            int u2;
            if (sourceGrid.rows != destGrid.rows || sourceGrid.cols != destGrid.cols) {
                throw new IllegalArgumentException("source and destination grids are different sizes");
            }
            int size = Math.max(cols, rows);
            float[] xrow = new float[size];
            float[] yrow = new float[size];
            float[] scale = new float[size + 1];
            float[] interpolated = new float[size + 1];
            int gridCols = sourceGrid.cols;
            int gridRows = sourceGrid.rows;
            WarpGrid splines = new WarpGrid(rows, gridCols, 1, 1);
            for (u2 = 0; u2 < gridCols; ++u2) {
                i2 = u2;
                for (v2 = 0; v2 < gridRows; ++v2) {
                    xrow[v2] = sourceGrid.xGrid[i2];
                    yrow[v2] = sourceGrid.yGrid[i2];
                    i2 += gridCols;
                }
                this.interpolateSpline(yrow, xrow, 0, gridRows, interpolated, 0, rows);
                i2 = u2;
                for (y2 = 0; y2 < rows; ++y2) {
                    splines.xGrid[i2] = interpolated[y2];
                    i2 += gridCols;
                }
            }
            for (u2 = 0; u2 < gridCols; ++u2) {
                i2 = u2;
                for (v2 = 0; v2 < gridRows; ++v2) {
                    xrow[v2] = destGrid.xGrid[i2];
                    yrow[v2] = destGrid.yGrid[i2];
                    i2 += gridCols;
                }
                this.interpolateSpline(yrow, xrow, 0, gridRows, interpolated, 0, rows);
                i2 = u2;
                for (y2 = 0; y2 < rows; ++y2) {
                    splines.yGrid[i2] = interpolated[y2];
                    i2 += gridCols;
                }
            }
            int[] intermediate = new int[rows * cols];
            int offset = 0;
            for (y2 = 0; y2 < rows; ++y2) {
                this.interpolateSpline(splines.xGrid, splines.yGrid, offset, gridCols, scale, 0, cols);
                scale[cols] = cols;
                ImageMath.resample(inPixels, intermediate, cols, y2 * cols, 1, scale);
                offset += gridCols;
            }
            splines = new WarpGrid(gridRows, cols, 1, 1);
            offset = 0;
            int offset2 = 0;
            for (v2 = 0; v2 < gridRows; ++v2) {
                this.interpolateSpline(sourceGrid.xGrid, sourceGrid.yGrid, offset, gridCols, splines.xGrid, offset2, cols);
                offset += gridCols;
                offset2 += cols;
            }
            offset = 0;
            offset2 = 0;
            for (v2 = 0; v2 < gridRows; ++v2) {
                this.interpolateSpline(destGrid.xGrid, destGrid.yGrid, offset, gridCols, splines.yGrid, offset2, cols);
                offset += gridCols;
                offset2 += cols;
            }
            for (int x2 = 0; x2 < cols; ++x2) {
                int i3 = x2;
                for (v2 = 0; v2 < gridRows; ++v2) {
                    xrow[v2] = splines.xGrid[i3];
                    yrow[v2] = splines.yGrid[i3];
                    i3 += cols;
                }
                this.interpolateSpline(xrow, yrow, 0, gridRows, scale, 0, rows);
                scale[rows] = rows;
                ImageMath.resample(intermediate, outPixels, rows, x2, cols, scale);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    protected void interpolateSpline(float[] xKnots, float[] yKnots, int offset, int length, float[] splineY, int splineOffset, int splineLength) {
        float k2;
        int index = offset;
        int end = offset + length - 1;
        float x0 = xKnots[index];
        float k1 = k2 = yKnots[index];
        float k0 = k2;
        float x1 = xKnots[index + 1];
        float k3 = yKnots[index + 1];
        for (int i2 = 0; i2 < splineLength; ++i2) {
            if (index <= end && (float)i2 > xKnots[index]) {
                k0 = k1;
                k1 = k2;
                k2 = k3;
                x0 = xKnots[index];
                if (++index <= end) {
                    x1 = xKnots[index];
                }
                k3 = index < end ? yKnots[index + 1] : k2;
            }
            float t2 = ((float)i2 - x0) / (x1 - x0);
            float c3 = -0.5f * k0 + 1.5f * k1 + -1.5f * k2 + 0.5f * k3;
            float c2 = 1.0f * k0 + -2.5f * k1 + 2.0f * k2 + -0.5f * k3;
            float c1 = -0.5f * k0 + 0.5f * k2;
            float c0 = 1.0f * k1;
            splineY[splineOffset + i2] = ((c3 * t2 + c2) * t2 + c1) * t2 + c0;
        }
    }

    protected void interpolateSpline2(float[] xKnots, float[] yKnots, int offset, float[] splineY, int splineOffset, int splineLength) {
        int index = offset;
        float leftX = xKnots[index];
        float leftY = yKnots[index];
        float rightX = xKnots[index + 1];
        float rightY = yKnots[index + 1];
        for (int i2 = 0; i2 < splineLength; ++i2) {
            if ((float)i2 > xKnots[index]) {
                leftX = xKnots[index];
                leftY = yKnots[index];
                rightX = xKnots[++index];
                rightY = yKnots[index];
            }
            float f2 = ((float)i2 - leftX) / (rightX - leftX);
            splineY[splineOffset + i2] = leftY + f2 * (rightY - leftY);
        }
    }
}

