/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.AbstractBufferedImageOp;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;

public class ScaleFilter
extends AbstractBufferedImageOp {
    private int width;
    private int height;

    public ScaleFilter() {
        this(32, 32);
    }

    public ScaleFilter(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int w2 = src.getWidth();
        int h2 = src.getHeight();
        if (dst == null) {
            ColorModel dstCM = src.getColorModel();
            dst = new BufferedImage(dstCM, dstCM.createCompatibleWritableRaster(w2, h2), dstCM.isAlphaPremultiplied(), null);
        }
        Image scaleImage = src.getScaledInstance(w2, h2, 16);
        Graphics2D g2 = dst.createGraphics();
        g2.drawImage(src, 0, 0, this.width, this.height, null);
        g2.dispose();
        return dst;
    }

    public String toString() {
        return "Distort/Scale";
    }
}

