/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.BinaryFilter;
import java.awt.Rectangle;

public class OutlineFilter
extends BinaryFilter {
    public OutlineFilter() {
        this.newColor = -1;
    }

    protected int[] filterPixels(int width, int height, int[] inPixels, Rectangle transformedSpace) {
        int index = 0;
        int[] outPixels = new int[width * height];
        for (int y2 = 0; y2 < height; ++y2) {
            for (int x2 = 0; x2 < width; ++x2) {
                int pixel = inPixels[y2 * width + x2];
                if (this.blackFunction.isBlack(pixel)) {
                    int neighbours = 0;
                    for (int dy = -1; dy <= 1; ++dy) {
                        int iy = y2 + dy;
                        if (0 > iy || iy >= height) continue;
                        int ioffset = iy * width;
                        for (int dx = -1; dx <= 1; ++dx) {
                            int ix = x2 + dx;
                            if ((dy != 0 || dx != 0) && 0 <= ix && ix < width) {
                                int rgb = inPixels[ioffset + ix];
                                if (!this.blackFunction.isBlack(rgb)) continue;
                                ++neighbours;
                                continue;
                            }
                            ++neighbours;
                        }
                    }
                    if (neighbours == 9) {
                        pixel = this.newColor;
                    }
                }
                outPixels[index++] = pixel;
            }
        }
        return outPixels;
    }

    public String toString() {
        return "Binary/Outline...";
    }
}

