/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.AbstractBufferedImageOp;
import com.jhlabs.image.ImageMath;
import com.jhlabs.image.PixelUtils;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class MotionBlurFilter
extends AbstractBufferedImageOp {
    public static final int LINEAR = 0;
    public static final int RADIAL = 1;
    public static final int ZOOM = 2;
    private float angle = 0.0f;
    private float falloff = 1.0f;
    private float distance = 1.0f;
    private float zoom = 0.0f;
    private float rotation = 0.0f;
    private boolean wrapEdges = false;

    public void setAngle(float angle) {
        this.angle = angle;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setDistance(float distance) {
        this.distance = distance;
    }

    public float getDistance() {
        return this.distance;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setWrapEdges(boolean wrapEdges) {
        this.wrapEdges = wrapEdges;
    }

    public boolean getWrapEdges() {
        return this.wrapEdges;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        int[] inPixels = new int[width * height];
        int[] outPixels = new int[width * height];
        this.getRGB(src, 0, 0, width, height, inPixels);
        float sinAngle = (float)Math.sin(this.angle);
        float cosAngle = (float)Math.cos(this.angle);
        int cx = width / 2;
        int cy = height / 2;
        int index = 0;
        float imageRadius = (float)Math.sqrt(cx * cx + cy * cy);
        float translateX = (float)((double)this.distance * Math.cos(this.angle));
        float translateY = (float)((double)this.distance * -Math.sin(this.angle));
        float maxDistance = this.distance + Math.abs(this.rotation * imageRadius) + this.zoom * imageRadius;
        int repetitions = (int)maxDistance;
        AffineTransform t2 = new AffineTransform();
        Point2D.Float p2 = new Point2D.Float();
        for (int y2 = 0; y2 < height; ++y2) {
            for (int x2 = 0; x2 < width; ++x2) {
                int a2 = 0;
                int r2 = 0;
                int g2 = 0;
                int b2 = 0;
                int count = 0;
                for (int i2 = 0; i2 < repetitions; ++i2) {
                    int newX = x2;
                    int newY = y2;
                    float f2 = (float)i2 / (float)repetitions;
                    p2.x = x2;
                    p2.y = y2;
                    t2.setToIdentity();
                    t2.translate((float)cx + f2 * translateX, (float)cy + f2 * translateY);
                    float s2 = 1.0f - this.zoom * f2;
                    t2.scale(s2, s2);
                    if (this.rotation != 0.0f) {
                        t2.rotate(-this.rotation * f2);
                    }
                    t2.translate(-cx, -cy);
                    t2.transform(p2, p2);
                    newX = (int)p2.x;
                    newY = (int)p2.y;
                    if (newX < 0 || newX >= width) {
                        if (!this.wrapEdges) break;
                        newX = ImageMath.mod(newX, width);
                    }
                    if (newY < 0 || newY >= height) {
                        if (!this.wrapEdges) break;
                        newY = ImageMath.mod(newY, height);
                    }
                    ++count;
                    int rgb = inPixels[newY * width + newX];
                    a2 += rgb >> 24 & 0xFF;
                    r2 += rgb >> 16 & 0xFF;
                    g2 += rgb >> 8 & 0xFF;
                    b2 += rgb & 0xFF;
                }
                if (count == 0) {
                    outPixels[index] = inPixels[index];
                } else {
                    a2 = PixelUtils.clamp(a2 / count);
                    r2 = PixelUtils.clamp(r2 / count);
                    g2 = PixelUtils.clamp(g2 / count);
                    b2 = PixelUtils.clamp(b2 / count);
                    outPixels[index] = a2 << 24 | r2 << 16 | g2 << 8 | b2;
                }
                ++index;
            }
        }
        this.setRGB(dst, 0, 0, width, height, outPixels);
        return dst;
    }

    public String toString() {
        return "Blur/Motion Blur...";
    }
}

