/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ConvolveFilter;
import com.jhlabs.image.PixelUtils;
import java.awt.image.BufferedImage;
import java.awt.image.Kernel;

public class GaussianFilter
extends ConvolveFilter {
    protected float radius;
    protected Kernel kernel;

    public GaussianFilter() {
        this(2.0f);
    }

    public GaussianFilter(float radius) {
        this.setRadius(radius);
    }

    public void setRadius(float radius) {
        this.radius = radius;
        this.kernel = GaussianFilter.makeKernel(radius);
    }

    public float getRadius() {
        return this.radius;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        int[] inPixels = new int[width * height];
        int[] outPixels = new int[width * height];
        src.getRGB(0, 0, width, height, inPixels, 0, width);
        if (this.radius > 0.0f) {
            GaussianFilter.convolveAndTranspose(this.kernel, inPixels, outPixels, width, height, this.alpha, ConvolveFilter.CLAMP_EDGES);
            GaussianFilter.convolveAndTranspose(this.kernel, outPixels, inPixels, height, width, this.alpha, ConvolveFilter.CLAMP_EDGES);
        }
        dst.setRGB(0, 0, width, height, inPixels, 0, width);
        return dst;
    }

    public static void convolveAndTranspose(Kernel kernel, int[] inPixels, int[] outPixels, int width, int height, boolean alpha, int edgeAction) {
        float[] matrix = kernel.getKernelData(null);
        int cols = kernel.getWidth();
        int cols2 = cols / 2;
        for (int y2 = 0; y2 < height; ++y2) {
            int index = y2;
            int ioffset = y2 * width;
            for (int x2 = 0; x2 < width; ++x2) {
                float r2 = 0.0f;
                float g2 = 0.0f;
                float b2 = 0.0f;
                float a2 = 0.0f;
                int moffset = cols2;
                for (int col = -cols2; col <= cols2; ++col) {
                    float f2 = matrix[moffset + col];
                    if (f2 == 0.0f) continue;
                    int ix = x2 + col;
                    if (ix < 0) {
                        if (edgeAction == ConvolveFilter.CLAMP_EDGES) {
                            ix = 0;
                        } else if (edgeAction == ConvolveFilter.WRAP_EDGES) {
                            ix = (x2 + width) % width;
                        }
                    } else if (ix >= width) {
                        if (edgeAction == ConvolveFilter.CLAMP_EDGES) {
                            ix = width - 1;
                        } else if (edgeAction == ConvolveFilter.WRAP_EDGES) {
                            ix = (x2 + width) % width;
                        }
                    }
                    int rgb = inPixels[ioffset + ix];
                    a2 += f2 * (float)(rgb >> 24 & 0xFF);
                    r2 += f2 * (float)(rgb >> 16 & 0xFF);
                    g2 += f2 * (float)(rgb >> 8 & 0xFF);
                    b2 += f2 * (float)(rgb & 0xFF);
                }
                int ia = alpha ? PixelUtils.clamp((int)((double)a2 + 0.5)) : 255;
                int ir = PixelUtils.clamp((int)((double)r2 + 0.5));
                int ig = PixelUtils.clamp((int)((double)g2 + 0.5));
                int ib2 = PixelUtils.clamp((int)((double)b2 + 0.5));
                outPixels[index] = ia << 24 | ir << 16 | ig << 8 | ib2;
                index += height;
            }
        }
    }

    public static Kernel makeKernel(float radius) {
        int r2 = (int)Math.ceil(radius);
        int rows = r2 * 2 + 1;
        float[] matrix = new float[rows];
        float sigma = radius / 3.0f;
        float sigma22 = 2.0f * sigma * sigma;
        float sigmaPi2 = (float)Math.PI * 2 * sigma;
        float sqrtSigmaPi2 = (float)Math.sqrt(sigmaPi2);
        float radius2 = radius * radius;
        float total = 0.0f;
        int index = 0;
        for (int row = -r2; row <= r2; ++row) {
            float distance = row * row;
            matrix[index] = distance > radius2 ? 0.0f : (float)Math.exp(-distance / sigma22) / sqrtSigmaPi2;
            total += matrix[index];
            ++index;
        }
        int i2 = 0;
        while (i2 < rows) {
            int n2 = i2++;
            matrix[n2] = matrix[n2] / total;
        }
        return new Kernel(rows, 1, matrix);
    }

    public String toString() {
        return "Blur/Gaussian Blur...";
    }
}

