/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.PixelUtils;
import com.jhlabs.image.WholeImageFilter;
import java.awt.Rectangle;

public class EdgeFilter
extends WholeImageFilter {
    static final long serialVersionUID = -1084121755410916989L;
    public static final float R2 = (float)Math.sqrt(2.0);
    public static final float[] ROBERTS_V = new float[]{0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    public static final float[] ROBERTS_H = new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    public static final float[] PREWITT_V = new float[]{-1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f};
    public static final float[] PREWITT_H = new float[]{-1.0f, -1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    public static final float[] SOBEL_V = new float[]{-1.0f, 0.0f, 1.0f, -2.0f, 0.0f, 2.0f, -1.0f, 0.0f, 1.0f};
    public static float[] SOBEL_H = new float[]{-1.0f, -2.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f};
    public static final float[] FREI_CHEN_V = new float[]{-1.0f, 0.0f, 1.0f, -R2, 0.0f, R2, -1.0f, 0.0f, 1.0f};
    public static float[] FREI_CHEN_H = new float[]{-1.0f, -R2, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, R2, 1.0f};
    protected float[] vEdgeMatrix = SOBEL_V;
    protected float[] hEdgeMatrix = SOBEL_H;

    public void setVEdgeMatrix(float[] vEdgeMatrix) {
        this.vEdgeMatrix = vEdgeMatrix;
    }

    public float[] getVEdgeMatrix() {
        return this.vEdgeMatrix;
    }

    public void setHEdgeMatrix(float[] hEdgeMatrix) {
        this.hEdgeMatrix = hEdgeMatrix;
    }

    public float[] getHEdgeMatrix() {
        return this.hEdgeMatrix;
    }

    protected int[] filterPixels(int width, int height, int[] inPixels, Rectangle transformedSpace) {
        int index = 0;
        int[] outPixels = new int[width * height];
        for (int y2 = 0; y2 < height; ++y2) {
            for (int x2 = 0; x2 < width; ++x2) {
                int r2 = 0;
                int g2 = 0;
                int b2 = 0;
                int rh = 0;
                int gh = 0;
                int bh = 0;
                int rv = 0;
                int gv = 0;
                int bv = 0;
                int a2 = inPixels[y2 * width + x2] & 0xFF000000;
                for (int row = -1; row <= 1; ++row) {
                    int iy = y2 + row;
                    int ioffset = 0 <= iy && iy < height ? iy * width : y2 * width;
                    int moffset = 3 * (row + 1) + 1;
                    for (int col = -1; col <= 1; ++col) {
                        int ix = x2 + col;
                        if (0 > ix || ix >= width) {
                            ix = x2;
                        }
                        int rgb = inPixels[ioffset + ix];
                        float h2 = this.hEdgeMatrix[moffset + col];
                        float v2 = this.vEdgeMatrix[moffset + col];
                        r2 = (rgb & 0xFF0000) >> 16;
                        g2 = (rgb & 0xFF00) >> 8;
                        b2 = rgb & 0xFF;
                        rh += (int)(h2 * (float)r2);
                        gh += (int)(h2 * (float)g2);
                        bh += (int)(h2 * (float)b2);
                        rv += (int)(v2 * (float)r2);
                        gv += (int)(v2 * (float)g2);
                        bv += (int)(v2 * (float)b2);
                    }
                }
                r2 = (int)(Math.sqrt(rh * rh + rv * rv) / 1.8);
                g2 = (int)(Math.sqrt(gh * gh + gv * gv) / 1.8);
                b2 = (int)(Math.sqrt(bh * bh + bv * bv) / 1.8);
                r2 = PixelUtils.clamp(r2);
                g2 = PixelUtils.clamp(g2);
                b2 = PixelUtils.clamp(b2);
                outPixels[index++] = a2 | r2 << 16 | g2 << 8 | b2;
            }
        }
        return outPixels;
    }

    public String toString() {
        return "Blur/Detect Edges";
    }
}

