/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.PixelUtils;
import com.jhlabs.image.PointFilter;

public class ChannelMixFilter
extends PointFilter {
    public int blueGreen;
    public int redBlue;
    public int greenRed;
    public int intoR;
    public int intoG;
    public int intoB;

    public ChannelMixFilter() {
        this.canFilterIndexColorModel = true;
    }

    public void setBlueGreen(int blueGreen) {
        this.blueGreen = blueGreen;
    }

    public int getBlueGreen() {
        return this.blueGreen;
    }

    public void setRedBlue(int redBlue) {
        this.redBlue = redBlue;
    }

    public int getRedBlue() {
        return this.redBlue;
    }

    public void setGreenRed(int greenRed) {
        this.greenRed = greenRed;
    }

    public int getGreenRed() {
        return this.greenRed;
    }

    public void setIntoR(int intoR) {
        this.intoR = intoR;
    }

    public int getIntoR() {
        return this.intoR;
    }

    public void setIntoG(int intoG) {
        this.intoG = intoG;
    }

    public int getIntoG() {
        return this.intoG;
    }

    public void setIntoB(int intoB) {
        this.intoB = intoB;
    }

    public int getIntoB() {
        return this.intoB;
    }

    public int filterRGB(int x2, int y2, int rgb) {
        int a2 = rgb & 0xFF000000;
        int r2 = rgb >> 16 & 0xFF;
        int g2 = rgb >> 8 & 0xFF;
        int b2 = rgb & 0xFF;
        int nr = PixelUtils.clamp((this.intoR * (this.blueGreen * g2 + (255 - this.blueGreen) * b2) / 255 + (255 - this.intoR) * r2) / 255);
        int ng = PixelUtils.clamp((this.intoG * (this.redBlue * b2 + (255 - this.redBlue) * r2) / 255 + (255 - this.intoG) * g2) / 255);
        int nb2 = PixelUtils.clamp((this.intoB * (this.greenRed * r2 + (255 - this.greenRed) * g2) / 255 + (255 - this.intoB) * b2) / 255);
        return a2 | nr << 16 | ng << 8 | nb2;
    }

    public String toString() {
        return "Colors/Mix Channels...";
    }
}

