/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import java.awt.Graphics;
import javax.swing.UIManager;

final class WindowsUtils {
    private WindowsUtils() {
    }

    public static void drawRoundedDashedRect(Graphics g2, int x2, int y2, int width, int height) {
        for (int vx = x2 + 1; vx < x2 + width; vx += 2) {
            g2.fillRect(vx, y2, 1, 1);
            g2.fillRect(vx, y2 + height - 1, 1, 1);
        }
        int offset = (width + 1) % 2;
        for (int vy = y2 + 1; vy < y2 + height - offset; vy += 2) {
            g2.fillRect(x2, vy, 1, 1);
            g2.fillRect(x2 + width - 1, vy + offset, 1, 1);
        }
    }

    static void drawFlush3DBorder(Graphics g2, int x2, int y2, int w2, int h2) {
        g2.translate(x2, y2);
        g2.setColor(UIManager.getColor("controlLtHighlight"));
        g2.drawLine(0, 0, w2 - 2, 0);
        g2.drawLine(0, 0, 0, h2 - 2);
        g2.setColor(UIManager.getColor("controlShadow"));
        g2.drawLine(w2 - 1, 0, w2 - 1, h2 - 1);
        g2.drawLine(0, h2 - 1, w2 - 1, h2 - 1);
        g2.translate(-x2, -y2);
    }

    static void drawPressed3DBorder(Graphics g2, int x2, int y2, int w2, int h2) {
        g2.translate(x2, y2);
        g2.setColor(UIManager.getColor("controlShadow"));
        g2.drawLine(0, 0, w2 - 2, 0);
        g2.drawLine(0, 0, 0, h2 - 2);
        g2.setColor(UIManager.getColor("controlLtHighlight"));
        g2.drawLine(w2 - 1, 0, w2 - 1, h2 - 1);
        g2.drawLine(0, h2 - 1, w2 - 1, h2 - 1);
        g2.translate(-x2, -y2);
    }
}

