/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

final class WindowsIconFactory {
    private static Icon checkBoxIcon;
    private static Icon radioButtonIcon;

    private WindowsIconFactory() {
    }

    static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int SIZE = 13;

        private RadioButtonIcon() {
        }

        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            AbstractButton b2 = (AbstractButton)c2;
            ButtonModel model = b2.getModel();
            g2.setColor(UIManager.getColor(model.isPressed() && model.isArmed() || !model.isEnabled() ? "RadioButton.background" : "RadioButton.interiorBackground"));
            g2.fillRect(x2 + 2, y2 + 2, 8, 8);
            g2.setColor(UIManager.getColor("RadioButton.shadow"));
            g2.drawLine(x2 + 4, y2 + 0, x2 + 7, y2 + 0);
            g2.drawLine(x2 + 2, y2 + 1, x2 + 3, y2 + 1);
            g2.drawLine(x2 + 8, y2 + 1, x2 + 9, y2 + 1);
            g2.drawLine(x2 + 1, y2 + 2, x2 + 1, y2 + 3);
            g2.drawLine(x2 + 0, y2 + 4, x2 + 0, y2 + 7);
            g2.drawLine(x2 + 1, y2 + 8, x2 + 1, y2 + 9);
            g2.setColor(UIManager.getColor("RadioButton.highlight"));
            g2.drawLine(x2 + 2, y2 + 10, x2 + 3, y2 + 10);
            g2.drawLine(x2 + 4, y2 + 11, x2 + 7, y2 + 11);
            g2.drawLine(x2 + 8, y2 + 10, x2 + 9, y2 + 10);
            g2.drawLine(x2 + 10, y2 + 9, x2 + 10, y2 + 8);
            g2.drawLine(x2 + 11, y2 + 7, x2 + 11, y2 + 4);
            g2.drawLine(x2 + 10, y2 + 3, x2 + 10, y2 + 2);
            g2.setColor(UIManager.getColor("RadioButton.darkShadow"));
            g2.drawLine(x2 + 4, y2 + 1, x2 + 7, y2 + 1);
            g2.drawLine(x2 + 2, y2 + 2, x2 + 3, y2 + 2);
            g2.drawLine(x2 + 8, y2 + 2, x2 + 9, y2 + 2);
            g2.drawLine(x2 + 2, y2 + 3, x2 + 2, y2 + 3);
            g2.drawLine(x2 + 1, y2 + 4, x2 + 1, y2 + 7);
            g2.drawLine(x2 + 2, y2 + 8, x2 + 2, y2 + 8);
            g2.setColor(UIManager.getColor("RadioButton.light"));
            g2.drawLine(x2 + 2, y2 + 9, x2 + 3, y2 + 9);
            g2.drawLine(x2 + 4, y2 + 10, x2 + 7, y2 + 10);
            g2.drawLine(x2 + 8, y2 + 9, x2 + 9, y2 + 9);
            g2.drawLine(x2 + 9, y2 + 8, x2 + 9, y2 + 8);
            g2.drawLine(x2 + 10, y2 + 7, x2 + 10, y2 + 4);
            g2.drawLine(x2 + 9, y2 + 3, x2 + 9, y2 + 3);
            if (model.isSelected()) {
                g2.setColor(UIManager.getColor("RadioButton.checkColor"));
                g2.fillRect(x2 + 4, y2 + 5, 4, 2);
                g2.fillRect(x2 + 5, y2 + 4, 2, 4);
            }
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }
    }

    private static class CheckBoxIcon
    implements Icon,
    Serializable {
        private static final int SIZE = 13;

        private CheckBoxIcon() {
        }

        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            JCheckBox cb2 = (JCheckBox)c2;
            ButtonModel model = cb2.getModel();
            if (!cb2.isBorderPaintedFlat()) {
                g2.setColor(UIManager.getColor("CheckBox.shadow"));
                g2.drawLine(x2, y2, x2 + 11, y2);
                g2.drawLine(x2, y2 + 1, x2, y2 + 11);
                g2.setColor(UIManager.getColor("CheckBox.highlight"));
                g2.drawLine(x2 + 12, y2, x2 + 12, y2 + 12);
                g2.drawLine(x2, y2 + 12, x2 + 11, y2 + 12);
                g2.setColor(UIManager.getColor("CheckBox.darkShadow"));
                g2.drawLine(x2 + 1, y2 + 1, x2 + 10, y2 + 1);
                g2.drawLine(x2 + 1, y2 + 2, x2 + 1, y2 + 10);
                g2.setColor(UIManager.getColor("CheckBox.light"));
                g2.drawLine(x2 + 1, y2 + 11, x2 + 11, y2 + 11);
                g2.drawLine(x2 + 11, y2 + 1, x2 + 11, y2 + 10);
            } else {
                g2.setColor(UIManager.getColor("CheckBox.shadow"));
                g2.drawRect(x2 + 1, y2 + 1, 10, 10);
            }
            g2.setColor(UIManager.getColor(model.isPressed() && model.isArmed() || !model.isEnabled() ? "CheckBox.background" : "CheckBox.interiorBackground"));
            g2.fillRect(x2 + 2, y2 + 2, 9, 9);
            g2.setColor(UIManager.getColor(model.isEnabled() ? "CheckBox.checkColor" : "CheckBox.shadow"));
            if (model.isSelected()) {
                g2.drawLine(x2 + 9, y2 + 3, x2 + 9, y2 + 3);
                g2.drawLine(x2 + 8, y2 + 4, x2 + 9, y2 + 4);
                g2.drawLine(x2 + 7, y2 + 5, x2 + 9, y2 + 5);
                g2.drawLine(x2 + 6, y2 + 6, x2 + 8, y2 + 6);
                g2.drawLine(x2 + 3, y2 + 7, x2 + 7, y2 + 7);
                g2.drawLine(x2 + 4, y2 + 8, x2 + 6, y2 + 8);
                g2.drawLine(x2 + 5, y2 + 9, x2 + 5, y2 + 9);
                g2.drawLine(x2 + 3, y2 + 5, x2 + 3, y2 + 5);
                g2.drawLine(x2 + 3, y2 + 6, x2 + 4, y2 + 6);
            }
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }
    }
}

