/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.common;

import com.jgoodies.looks.common.MinimumSizedIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.UIManager;

public final class MinimumSizedCheckIcon
extends MinimumSizedIcon {
    private final JMenuItem menuItem;

    public MinimumSizedCheckIcon(Icon icon, JMenuItem menuItem) {
        super(icon);
        this.menuItem = menuItem;
    }

    public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
        this.paintState(g2, x2, y2);
        super.paintIcon(c2, g2, x2, y2);
    }

    private void paintState(Graphics g2, int x2, int y2) {
        ButtonModel model = this.menuItem.getModel();
        int w2 = this.getIconWidth();
        int h2 = this.getIconHeight();
        g2.translate(x2, y2);
        if (model.isSelected() || model.isArmed()) {
            Color background = model.isArmed() ? UIManager.getColor("MenuItem.background") : UIManager.getColor("ScrollBar.track");
            Color upColor = UIManager.getColor("controlLtHighlight");
            Color downColor = UIManager.getColor("controlDkShadow");
            g2.setColor(background);
            g2.fillRect(0, 0, w2, h2);
            g2.setColor(model.isSelected() ? downColor : upColor);
            g2.drawLine(0, 0, w2 - 2, 0);
            g2.drawLine(0, 0, 0, h2 - 2);
            g2.setColor(model.isSelected() ? upColor : downColor);
            g2.drawLine(0, h2 - 1, w2 - 1, h2 - 1);
            g2.drawLine(w2 - 1, 0, w2 - 1, h2 - 1);
        }
        g2.translate(-x2, -y2);
        g2.setColor(UIManager.getColor("textText"));
    }
}

