/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;
import javax.swing.border.Border;

public class CustomizableLineBorder
implements Border {
    private final Insets insets = new Insets(0, 0, 0, 0);
    private boolean top;
    private boolean bottom;
    private boolean left;
    private boolean right;
    private Color color;
    private Stroke stroke = new BasicStroke();

    public CustomizableLineBorder(boolean top, boolean left, boolean bottom, boolean right, Color color, Stroke stroke) {
        this.stroke = stroke;
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
        if (top) {
            this.insets.top = 1;
        }
        if (left) {
            this.insets.left = 1;
        }
        if (bottom) {
            this.insets.bottom = 1;
        }
        if (right) {
            this.insets.right = 1;
        }
        this.color = color;
    }

    public CustomizableLineBorder(boolean top, boolean left, boolean bottom, boolean right, Color color) {
        this(top, left, bottom, right, color, new BasicStroke());
    }

    public CustomizableLineBorder(boolean top, boolean left, boolean bottom, boolean right) {
        this(top, left, bottom, right, null);
    }

    public CustomizableLineBorder() {
        this(true, true, true, true);
    }

    @Override
    public Insets getBorderInsets(Component c2) {
        return this.insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        Graphics2D g2d = (Graphics2D)g2;
        g2d.setStroke(this.stroke);
        if (this.top) {
            if (this.color != null) {
                g2d.setColor(this.color);
            } else {
                g2d.setColor(c2.getBackground().brighter());
            }
            g2d.drawLine(x2, y2, x2 + width - 1, y2);
        }
        if (this.left) {
            if (this.color != null) {
                g2d.setColor(this.color);
            } else {
                g2d.setColor(c2.getBackground().brighter());
            }
            g2d.drawLine(x2, y2, x2, y2 + height - 1);
        }
        if (this.bottom) {
            if (this.color != null) {
                g2d.setColor(this.color);
            } else {
                g2d.setColor(c2.getBackground().darker());
            }
            g2d.drawLine(x2, y2 + height - 1, x2 + width - 1, y2 + height - 1);
        }
        if (this.right) {
            if (this.color != null) {
                g2d.setColor(this.color);
            } else {
                g2d.setColor(c2.getBackground().darker());
            }
            g2d.drawLine(x2 + width - 1, y2, x2 + width - 1, y2 + height - 1);
        }
    }
}

