/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.util;

import javax.swing.SwingUtilities;

public abstract class AbstractSwingWorker {
    private Object value;
    private ThreadVar threadVar;

    public AbstractSwingWorker() {
        final Runnable doFinished = new Runnable(){

            @Override
            public void run() {
                AbstractSwingWorker.this.finished();
            }
        };
        Runnable doConstruct = new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractSwingWorker.this.setValue(AbstractSwingWorker.this.construct());
                }
                finally {
                    AbstractSwingWorker.this.threadVar.clear();
                }
                SwingUtilities.invokeLater(doFinished);
            }
        };
        Thread t2 = new Thread(doConstruct);
        t2.setName("SwingWorkerThread");
        this.threadVar = new ThreadVar(t2);
    }

    protected synchronized Object getValue() {
        return this.value;
    }

    private synchronized void setValue(Object x2) {
        this.value = x2;
    }

    public abstract Object construct();

    public void finished() {
    }

    public void interrupt() {
        Thread t2 = this.threadVar.get();
        if (t2 != null) {
            t2.interrupt();
        }
        this.threadVar.clear();
    }

    public Object get() {
        Thread t2;
        while ((t2 = this.threadVar.get()) != null) {
            try {
                t2.join();
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.getValue();
    }

    public void start() {
        Thread t2 = this.threadVar.get();
        if (t2 != null) {
            t2.start();
        }
    }

    private static class ThreadVar {
        private Thread thread;

        ThreadVar(Thread t2) {
            this.thread = t2;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

