/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.timeline;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.dateline.AbstractDatelineModel;
import com.dlsc.flexgantt.model.dateline.DatelineModelEvent;
import com.dlsc.flexgantt.model.dateline.DatelineModelException;
import com.dlsc.flexgantt.model.dateline.DatelineModelVetoException;
import com.dlsc.flexgantt.model.dateline.GridLine;
import com.dlsc.flexgantt.model.dateline.TimeGranularity;
import com.dlsc.flexgantt.policy.dateline.IZoomPolicy;
import com.dlsc.flexgantt.swing.timeline.Dateline;
import com.dlsc.flexgantt.swing.timeline.MinorDateFormat;
import com.dlsc.flexgantt.util.Messages;
import java.awt.Font;
import java.awt.FontMetrics;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TimeGranularityDatelineModel
extends AbstractDatelineModel<TimeGranularity> {
    private static final Logger LOGGER = Logger.getLogger(TimeGranularityDatelineModel.class.getName());
    private List<GridLine> minorGrid = new ArrayList<GridLine>();
    private List<GridLine> majorGrid = new ArrayList<GridLine>();
    private MessageFormat halfYearFormat = new MessageFormat(Messages.getString("TimeGranularityDatelineModel.MINOR_HALF_YEAR"));
    private Map<TimeGranularity, Integer> widths;
    private Map<TimeGranularity, DateFormat> minorFormats;
    private Map<TimeGranularity, DateFormat> majorFormats;
    private MessageFormat quarterYearFormat = new MessageFormat(Messages.getString("TimeGranularityDatelineModel.MINOR_QUARTER_YEAR"));
    private Dateline dateline;
    private int gap = 5;
    private double mpp;

    public TimeGranularityDatelineModel(Dateline dateline, ITimeSpan timeSpan, TimeGranularity tg, TimeZone zone) throws DatelineModelException {
        super(timeSpan, zone);
        this.dateline = dateline;
        this.initFormatters();
        this.initWidths();
        this.setGranularity(tg);
    }

    public TimeGranularityDatelineModel(Dateline dateline, ITimeSpan timeSpan, TimeGranularity tg) throws DatelineModelException {
        this(dateline, timeSpan, tg, TimeZone.getDefault());
    }

    public TimeGranularityDatelineModel(Dateline dateline, ITimeSpan timeSpan, TimeZone zone) throws DatelineModelException {
        this(dateline, timeSpan, TimeGranularity.DAY_SHORT, zone);
    }

    public TimeGranularityDatelineModel(Dateline dateline, ITimeSpan timeSpan) throws DatelineModelException {
        this(dateline, timeSpan, TimeGranularity.DAY_SHORT, TimeZone.getDefault());
    }

    public TimeGranularityDatelineModel(Dateline dateline) throws DatelineModelException {
        this(dateline, TimeSpan.DEFAULT_TIME_SPAN, TimeGranularity.DAY_TINY, TimeZone.getDefault());
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int gap) {
        this.gap = gap;
        this.initWidths();
    }

    @Override
    public List<GridLine> getGrid(int x1, int x2, boolean major) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.finest("getting grid x1 = " + x1 + " x2 = " + x2);
        }
        if (major) {
            this.calculateMajorGrid(x1, x2);
            return this.majorGrid;
        }
        this.calculateMinorGrid(x1, x2);
        return this.minorGrid;
    }

    public TimeGranularity getMajorTimeGranularity() {
        TimeGranularity granularity = (TimeGranularity)this.getGranularity();
        switch (granularity) {
            case MILLISECOND: 
            case TEN_MILLISECONDS: 
            case HUNDRED_MILLISECONDS: {
                return TimeGranularity.SECOND;
            }
            case SECOND: 
            case FIVE_SECONDS: 
            case TEN_SECONDS: 
            case FIFTEEN_SECONDS: 
            case THIRTY_SECONDS: {
                return TimeGranularity.MINUTE;
            }
            case MINUTE: 
            case FIVE_MINUTES: 
            case TEN_MINUTES: 
            case FIFTEEN_MINUTES: 
            case THIRTY_MINUTES: {
                return TimeGranularity.HOUR;
            }
            case HOUR: 
            case THREE_HOURS: 
            case SIX_HOURS: {
                return TimeGranularity.DAY_SHORT;
            }
            case DAY_SHORT: 
            case DAY_TINY: {
                return TimeGranularity.WEEK;
            }
            case WEEK: {
                return TimeGranularity.MONTH_SHORT;
            }
            case MONTH_SHORT: 
            case MONTH_TINY: {
                return TimeGranularity.YEAR;
            }
            case QUARTER_YEAR: 
            case HALF_YEAR: {
                return TimeGranularity.YEAR;
            }
            case YEAR: {
                return TimeGranularity.DECADE;
            }
            case DECADE: {
                return TimeGranularity.CENTURY;
            }
        }
        return TimeGranularity.MILLENIUM;
    }

    public TimeGranularity getTimeGranularity(ITimeSpan span, int width) {
        LOGGER.fine("calculating time granularity");
        long st = span.getStartTime();
        long et = span.getEndTime();
        long millis = et - st;
        if ((long)width >= millis * (long)this.widths.get(TimeGranularity.MILLISECOND).intValue()) {
            return TimeGranularity.SECOND;
        }
        long tenMillis = millis / 10L;
        if ((long)width >= tenMillis * (long)this.widths.get(TimeGranularity.TEN_MILLISECONDS).intValue()) {
            return TimeGranularity.TEN_MILLISECONDS;
        }
        long hundredMillis = tenMillis / 10L;
        if ((long)width >= hundredMillis * (long)this.widths.get(TimeGranularity.HUNDRED_MILLISECONDS).intValue()) {
            return TimeGranularity.HUNDRED_MILLISECONDS;
        }
        long seconds = millis / 1000L;
        if ((long)width >= seconds * (long)this.widths.get(TimeGranularity.SECOND).intValue()) {
            return TimeGranularity.SECOND;
        }
        long fiveSeconds = seconds / 5L;
        if ((long)width >= fiveSeconds * (long)this.widths.get(TimeGranularity.FIVE_SECONDS).intValue()) {
            return TimeGranularity.FIVE_SECONDS;
        }
        long tenSeconds = seconds / 10L;
        if ((long)width >= tenSeconds * (long)this.widths.get(TimeGranularity.TEN_SECONDS).intValue()) {
            return TimeGranularity.TEN_SECONDS;
        }
        long fifteenSeconds = seconds / 15L;
        if ((long)width >= fifteenSeconds * (long)this.widths.get(TimeGranularity.FIFTEEN_SECONDS).intValue()) {
            return TimeGranularity.FIFTEEN_SECONDS;
        }
        long thirtySeconds = seconds / 30L;
        if ((long)width >= thirtySeconds * (long)this.widths.get(TimeGranularity.THIRTY_SECONDS).intValue()) {
            return TimeGranularity.THIRTY_SECONDS;
        }
        long minutes = seconds / 60L;
        if ((long)width >= minutes * (long)this.widths.get(TimeGranularity.MINUTE).intValue()) {
            return TimeGranularity.MINUTE;
        }
        long fiveMinutes = minutes / 5L;
        if ((long)width >= fiveMinutes * (long)this.widths.get(TimeGranularity.FIVE_MINUTES).intValue()) {
            return TimeGranularity.FIVE_MINUTES;
        }
        long tenMinutes = minutes / 10L;
        if ((long)width >= tenMinutes * (long)this.widths.get(TimeGranularity.TEN_MINUTES).intValue()) {
            return TimeGranularity.TEN_MINUTES;
        }
        long fifteenMinutes = minutes / 15L;
        if ((long)width >= fifteenMinutes * (long)this.widths.get(TimeGranularity.FIFTEEN_MINUTES).intValue()) {
            return TimeGranularity.FIFTEEN_MINUTES;
        }
        long thirtyMinutes = minutes / 30L;
        if ((long)width >= thirtyMinutes * (long)this.widths.get(TimeGranularity.THIRTY_MINUTES).intValue()) {
            return TimeGranularity.THIRTY_MINUTES;
        }
        long hours = minutes / 60L;
        if ((long)width >= hours * (long)this.widths.get(TimeGranularity.HOUR).intValue()) {
            return TimeGranularity.HOUR;
        }
        long threeHours = hours / 3L;
        if ((long)width >= threeHours * (long)this.widths.get(TimeGranularity.THREE_HOURS).intValue()) {
            return TimeGranularity.THREE_HOURS;
        }
        long sixHours = threeHours / 2L;
        if ((long)width >= sixHours * (long)this.widths.get(TimeGranularity.SIX_HOURS).intValue()) {
            return TimeGranularity.SIX_HOURS;
        }
        long days = sixHours / 4L;
        if ((long)width >= days * (long)this.widths.get(TimeGranularity.DAY_SHORT).intValue()) {
            return TimeGranularity.DAY_SHORT;
        }
        if ((long)width >= days * (long)this.widths.get(TimeGranularity.DAY_TINY).intValue()) {
            return TimeGranularity.DAY_TINY;
        }
        long weeks = days / 7L;
        if ((long)width >= weeks * (long)this.widths.get(TimeGranularity.WEEK).intValue()) {
            return TimeGranularity.WEEK;
        }
        long months = days / 31L;
        if ((long)width >= months * (long)this.widths.get(TimeGranularity.MONTH_SHORT).intValue()) {
            return TimeGranularity.MONTH_SHORT;
        }
        if ((long)width >= months * (long)this.widths.get(TimeGranularity.MONTH_TINY).intValue()) {
            return TimeGranularity.MONTH_TINY;
        }
        long quarters = months / 3L;
        if ((long)width >= quarters * (long)this.widths.get(TimeGranularity.QUARTER_YEAR).intValue()) {
            return TimeGranularity.QUARTER_YEAR;
        }
        long halfs = quarters / 2L;
        if ((long)width >= halfs * (long)this.widths.get(TimeGranularity.HALF_YEAR).intValue()) {
            return TimeGranularity.HALF_YEAR;
        }
        long years = quarters / 4L;
        if ((long)width >= years * (long)this.widths.get(TimeGranularity.YEAR).intValue()) {
            return TimeGranularity.YEAR;
        }
        long decades = years / 10L;
        if ((long)width >= decades * (long)this.widths.get(TimeGranularity.DECADE).intValue()) {
            return TimeGranularity.DECADE;
        }
        long centuries = decades / 10L;
        if ((long)width >= centuries * (long)this.widths.get(TimeGranularity.CENTURY).intValue()) {
            return TimeGranularity.CENTURY;
        }
        return TimeGranularity.MILLENIUM;
    }

    private void calculateMajorGrid(int x1, int x2) {
        this.majorGrid.clear();
        TimeGranularity level = this.getMajorTimeGranularity();
        Calendar c2 = Calendar.getInstance(this.timeZone);
        c2.setFirstDayOfWeek(TimeGranularity.getFirstDayOfWeek());
        c2.setTimeInMillis(this.getTimeAt(x1));
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("level = " + level);
            LOGGER.finer("calendar c = " + c2.getTime());
        }
        level.adjustCalendar(c2);
        int currentX = this.getTimeLocation(c2.getTimeInMillis());
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("calendar c (adjusted) = " + c2.getTime());
            LOGGER.finer("currentX = " + currentX);
        }
        while (currentX < x2) {
            this.majorGrid.add(new GridLine(currentX - 1, c2.getTimeInMillis()));
            level.increment(c2);
            currentX = this.getTimeLocation(c2.getTimeInMillis());
            if (!LOGGER.isLoggable(Level.FINER)) continue;
            LOGGER.finer("calendar c (incremented) = " + c2.getTime());
            LOGGER.finer("currentX = " + currentX);
        }
        this.majorGrid.add(new GridLine(currentX - 1, c2.getTimeInMillis()));
    }

    private void calculateMinorGrid(int x1, int x2) {
        this.minorGrid.clear();
        TimeGranularity level = (TimeGranularity)this.getGranularity();
        Calendar c2 = Calendar.getInstance(this.timeZone);
        c2.setFirstDayOfWeek(TimeGranularity.getFirstDayOfWeek());
        c2.setTimeInMillis(this.getTimeAt(x1));
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("level = " + level);
            LOGGER.finer("calendar c = " + c2.getTime());
        }
        level.adjustCalendar(c2);
        int lw = this.widths.get(level);
        int currentX = this.getTimeLocation(c2.getTimeInMillis());
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("calendar c (adjusted) = " + c2.getTime());
            LOGGER.finer("level width = " + lw);
            LOGGER.finer("currentX = " + currentX);
        }
        GridLine.DstChangeType changeType = GridLine.DstChangeType.NO_CHANGE;
        while (currentX < x2 + lw) {
            GridLine gridLine = new GridLine(currentX - 1, c2.getTimeInMillis());
            gridLine.setDstChangeType(changeType);
            this.minorGrid.add(gridLine);
            long dstBefore = c2.get(16);
            level.increment(c2);
            long dstAfter = c2.get(16);
            long dstDelta = dstAfter - dstBefore;
            if (level.isInside(TimeGranularity.THREE_HOURS, TimeGranularity.SIX_HOURS)) {
                c2.setTimeInMillis(c2.getTimeInMillis() - dstDelta);
            }
            changeType = dstDelta > 0L ? GridLine.DstChangeType.SUMMER_TIME_TO_WINTER_TIME : (dstDelta < 0L ? GridLine.DstChangeType.WINTER_TIME_TO_SUMMER_TIME : GridLine.DstChangeType.NO_CHANGE);
            currentX = this.getTimeLocation(c2.getTimeInMillis());
            if (!LOGGER.isLoggable(Level.FINER)) continue;
            LOGGER.finer("calendar c (incremented) = " + c2.getTime());
            LOGGER.finer("currentX = " + currentX);
            LOGGER.finer("gridLine = " + gridLine);
        }
        this.minorGrid.add(new GridLine(currentX - 1, c2.getTimeInMillis()));
    }

    @Override
    public int getTimeLocation(long time) {
        ITimeSpan span = this.getTimeSpan();
        long startTime = span.getStartTime();
        double x2 = (double)(time - startTime) / this.mpp;
        if (x2 > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        if (x2 < -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        return (int)x2;
    }

    @Override
    public long getTimeAt(int x2) {
        ITimeSpan span = this.getTimeSpan();
        long millis = (long)((double)(x2 + 1) * this.mpp);
        long result = span.getStartTime() + millis;
        return result;
    }

    @Override
    public ITimeSpan getTimeSpanAt(int x2, boolean major) {
        TimeGranularity tg = (TimeGranularity)this.getGranularity();
        if (major) {
            tg = this.getMajorTimeGranularity();
        }
        long time1 = this.getTimeAt(x2);
        Calendar c2 = Calendar.getInstance(this.timeZone);
        c2.setTimeInMillis(time1);
        c2.setFirstDayOfWeek(TimeGranularity.getFirstDayOfWeek());
        int offset = c2.get(16);
        tg.adjustCalendar(c2);
        c2.set(16, offset);
        time1 = c2.getTimeInMillis();
        tg.increment(c2);
        long time2 = c2.getTimeInMillis();
        return new TimeSpan(time1, time2);
    }

    public long getTimeDuration(int width) {
        return (long)((double)width * this.mpp);
    }

    private void calculateMPP() {
        ITimeSpan span = this.getTimeSpan();
        this.mpp = (double)span.getDuration() / this.datelineWidth;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("mpp = " + this.mpp);
        }
    }

    @Override
    protected void calculateDatelineWidth() throws DatelineModelException {
        LOGGER.entering(TimeGranularityDatelineModel.class.getName(), "calculateDatelineWidth");
        ITimeSpan span = this.getTimeSpan();
        TimeGranularity timeGranularity = (TimeGranularity)this.getGranularity();
        LOGGER.fine("granularity = " + timeGranularity);
        double lw = (double)this.widths.get(timeGranularity).intValue() * this.zoom;
        if (this.spreadsheetCellWidth > 0) {
            lw = this.spreadsheetCellWidth;
        }
        LOGGER.fine("width (pixel) of one unit of " + timeGranularity + " = " + lw);
        LOGGER.fine("current time span = " + span);
        Calendar s2 = Calendar.getInstance(this.timeZone);
        s2.setFirstDayOfWeek(TimeGranularity.getFirstDayOfWeek());
        s2.setTimeInMillis(span.getStartTime());
        Calendar e2 = Calendar.getInstance(this.timeZone);
        e2.setFirstDayOfWeek(TimeGranularity.getFirstDayOfWeek());
        e2.setTimeInMillis(span.getEndTime());
        double count = timeGranularity.getDelta(s2, e2);
        LOGGER.fine("time granularity count = " + count + "(" + timeGranularity + ")");
        if (count * lw <= 2.147483647E9) {
            double newWidth = Math.max(Double.MIN_VALUE, count * lw);
            if (newWidth != this.datelineWidth) {
                this.datelineWidth = newWidth;
                this.calculateMPP();
                this.fireDatelineModelChangeEvent(new DatelineModelEvent(this, DatelineModelEvent.ID.DATELINE_WIDTH_CHANGED));
            }
        } else {
            LOGGER.fine("throwing dateline model veto exception");
            throw new DatelineModelException("width of dateline is larger than Integer.MAX_VALUE", DatelineModelException.ID.MAXIMUM_WIDTH_EXCEEDED);
        }
        LOGGER.fine("datelineWidth = " + this.datelineWidth);
        LOGGER.exiting(TimeGranularityDatelineModel.class.getName(), "calculateDatelineWidth", this.datelineWidth);
    }

    private void initFormatters() {
        this.majorFormats = new HashMap<TimeGranularity, DateFormat>(TimeGranularity.values().length);
        this.minorFormats = new HashMap<TimeGranularity, DateFormat>(TimeGranularity.values().length);
        this.majorFormats.put(TimeGranularity.MILLENIUM, new SimpleDateFormat(Messages.getString("TimeGranularityDatelineModel.MAJOR_MILLENIUM")));
        this.majorFormats.put(TimeGranularity.CENTURY, new SimpleDateFormat(Messages.getString("TimeGranularityDatelineModel.MAJOR_CENTURY")));
        this.majorFormats.put(TimeGranularity.DECADE, new SimpleDateFormat(Messages.getString("TimeGranularityDatelineModel.MAJOR_DECADE")));
        this.majorFormats.put(TimeGranularity.YEAR, new SimpleDateFormat(Messages.getString("TimeGranularityDatelineModel.MAJOR_YEAR")));
        this.majorFormats.put(TimeGranularity.MONTH_SHORT, new SimpleDateFormat(Messages.getString("TimeGranularityDatelineModel.MAJOR_MONTH_SHORT")));
        this.majorFormats.put(TimeGranularity.MONTH_TINY, new SimpleDateFormat(Messages.getString("TimeGranularityDatelineModel.MAJOR_MONTH_TINY")));
        this.majorFormats.put(TimeGranularity.WEEK, new SimpleDateFormat(Messages.getString("TimeGranularityDatelineModel.MAJOR_WEEK")));
        this.majorFormats.put(TimeGranularity.DAY_SHORT, new SimpleDateFormat(Messages.getString("TimeGranularityDatelineModel.MAJOR_DAY_SHORT")));
        this.majorFormats.put(TimeGranularity.DAY_TINY, new SimpleDateFormat(Messages.getString("TimeGranularityDatelineModel.MAJOR_DAY_TINY")));
        this.majorFormats.put(TimeGranularity.HOUR, new SimpleDateFormat(Messages.getString("TimeGranularityDatelineModel.MAJOR_HOUR")));
        this.majorFormats.put(TimeGranularity.MINUTE, new SimpleDateFormat(Messages.getString("TimeGranularityDatelineModel.MAJOR_MINUTE")));
        this.majorFormats.put(TimeGranularity.SECOND, new SimpleDateFormat(Messages.getString("TimeGranularityDatelineModel.MAJOR_SECOND")));
        this.minorFormats.put(TimeGranularity.MILLENIUM, new MinorDateFormat(Messages.getString("TimeGranularityDatelineModel.MINOR_MILLENIUM"), TimeGranularity.MILLENIUM));
        this.minorFormats.put(TimeGranularity.CENTURY, new MinorDateFormat(Messages.getString("TimeGranularityDatelineModel.MINOR_CENTURY"), TimeGranularity.CENTURY));
        this.minorFormats.put(TimeGranularity.DECADE, new MinorDateFormat(Messages.getString("TimeGranularityDatelineModel.MINOR_DECADE"), TimeGranularity.DECADE));
        this.minorFormats.put(TimeGranularity.YEAR, new MinorDateFormat(Messages.getString("TimeGranularityDatelineModel.MINOR_YEAR"), TimeGranularity.YEAR));
        this.minorFormats.put(TimeGranularity.MONTH_TINY, new MinorDateFormat(Messages.getString("TimeGranularityDatelineModel.MINOR_MONTH_TINY"), TimeGranularity.MONTH_TINY));
        this.minorFormats.put(TimeGranularity.MONTH_SHORT, new MinorDateFormat(Messages.getString("TimeGranularityDatelineModel.MINOR_MONTH_SHORT"), TimeGranularity.MONTH_SHORT));
        this.minorFormats.put(TimeGranularity.WEEK, new MinorDateFormat(Messages.getString("TimeGranularityDatelineModel.MINOR_WEEK"), TimeGranularity.WEEK));
        this.minorFormats.put(TimeGranularity.DAY_SHORT, new MinorDateFormat(Messages.getString("TimeGranularityDatelineModel.MINOR_DAY_SHORT"), TimeGranularity.DAY_SHORT));
        this.minorFormats.put(TimeGranularity.DAY_TINY, new MinorDateFormat(Messages.getString("TimeGranularityDatelineModel.MINOR_DAY_TINY"), TimeGranularity.DAY_TINY));
        this.minorFormats.put(TimeGranularity.SIX_HOURS, new MinorDateFormat(Messages.getString("TimeGranularityDatelineModel.MINOR_SIX_HOURS"), TimeGranularity.SIX_HOURS));
        this.minorFormats.put(TimeGranularity.THREE_HOURS, new MinorDateFormat(Messages.getString("TimeGranularityDatelineModel.MINOR_THREE_HOURS"), TimeGranularity.THREE_HOURS));
        this.minorFormats.put(TimeGranularity.HOUR, new MinorDateFormat(Messages.getString("TimeGranularityDatelineModel.MINOR_HOUR"), TimeGranularity.HOUR));
        this.minorFormats.put(TimeGranularity.THIRTY_MINUTES, new MinorDateFormat(Messages.getString("TimeGranularityDatelineModel.MINOR_THIRTY_MINUTES"), TimeGranularity.THIRTY_MINUTES));
        this.minorFormats.put(TimeGranularity.FIFTEEN_MINUTES, new MinorDateFormat(Messages.getString("TimeGranularityDatelineModel.MINOR_FIFTEEN_MINUTES"), TimeGranularity.FIFTEEN_MINUTES));
        this.minorFormats.put(TimeGranularity.TEN_MINUTES, new MinorDateFormat(Messages.getString("TimeGranularityDatelineModel.MINOR_TEN_MINUTES"), TimeGranularity.TEN_MINUTES));
        this.minorFormats.put(TimeGranularity.FIVE_MINUTES, new MinorDateFormat(Messages.getString("TimeGranularityDatelineModel.MINOR_FIVE_MINUTES"), TimeGranularity.FIVE_MINUTES));
        this.minorFormats.put(TimeGranularity.MINUTE, new MinorDateFormat(Messages.getString("TimeGranularityDatelineModel.MINOR_MINUTE"), TimeGranularity.MINUTE));
        this.minorFormats.put(TimeGranularity.SECOND, new MinorDateFormat(Messages.getString("TimeGranularityDatelineModel.MINOR_SECOND"), TimeGranularity.SECOND));
        this.minorFormats.put(TimeGranularity.THIRTY_SECONDS, new MinorDateFormat(Messages.getString("TimeGranularityDatelineModel.MINOR_THIRTY_SECONDS"), TimeGranularity.THIRTY_SECONDS));
        this.minorFormats.put(TimeGranularity.FIFTEEN_SECONDS, new MinorDateFormat(Messages.getString("TimeGranularityDatelineModel.MINOR_FIFTEEN_SECONDS"), TimeGranularity.FIFTEEN_SECONDS));
        this.minorFormats.put(TimeGranularity.TEN_SECONDS, new MinorDateFormat(Messages.getString("TimeGranularityDatelineModel.MINOR_TEN_SECONDS"), TimeGranularity.TEN_SECONDS));
        this.minorFormats.put(TimeGranularity.FIVE_SECONDS, new MinorDateFormat(Messages.getString("TimeGranularityDatelineModel.MINOR_FIVE_SECONDS"), TimeGranularity.FIVE_SECONDS));
        this.minorFormats.put(TimeGranularity.SECOND, new MinorDateFormat(Messages.getString("TimeGranularityDatelineModel.MINOR_SECOND"), TimeGranularity.SECOND));
        this.minorFormats.put(TimeGranularity.TEN_MILLISECONDS, new MinorDateFormat(Messages.getString("TimeGranularityDatelineModel.MINOR_TEN_MILLISECONDS"), TimeGranularity.TEN_MILLISECONDS));
        this.minorFormats.put(TimeGranularity.HUNDRED_MILLISECONDS, new MinorDateFormat(Messages.getString("TimeGranularityDatelineModel.MINOR_HUNDRED_MILLISECONDS"), TimeGranularity.HUNDRED_MILLISECONDS));
        this.minorFormats.put(TimeGranularity.MILLISECOND, new MinorDateFormat(Messages.getString("TimeGranularityDatelineModel.MINOR_MILLISECOND"), TimeGranularity.MILLISECOND));
    }

    private void initWidths() {
        this.widths = new HashMap<TimeGranularity, Integer>();
        Font font = this.dateline.getFont();
        FontMetrics fm = this.dateline.getFontMetrics(font);
        Calendar c2 = Calendar.getInstance(this.timeZone);
        c2.setFirstDayOfWeek(TimeGranularity.getFirstDayOfWeek());
        c2.set(14, 999);
        c2.set(13, 59);
        c2.set(12, 59);
        c2.set(11, 23);
        c2.set(5, 29);
        c2.set(2, 11);
        c2.set(1, 9999);
        c2.set(7, 2);
        Date prototype = c2.getTime();
        String milleniumString = this.getMinorDateFormat(TimeGranularity.MILLENIUM).format(prototype);
        String centuryString = this.getMinorDateFormat(TimeGranularity.CENTURY).format(prototype);
        String decadeString = this.getMinorDateFormat(TimeGranularity.DECADE).format(prototype);
        String yearString = this.getMinorDateFormat(TimeGranularity.YEAR).format(prototype);
        String halfYearString = this.halfYearFormat.format(new String[]{"2"});
        String quarterYearString = this.quarterYearFormat.format(new String[]{"4"});
        String monthShortString = this.getMinorDateFormat(TimeGranularity.MONTH_SHORT).format(prototype);
        String monthTinyString = this.getMinorDateFormat(TimeGranularity.MONTH_TINY).format(prototype);
        String weekString = this.getMinorDateFormat(TimeGranularity.WEEK).format(prototype);
        String shortDayString = this.getMinorDateFormat(TimeGranularity.DAY_SHORT).format(prototype);
        String tinyDayString = this.getMinorDateFormat(TimeGranularity.DAY_TINY).format(prototype);
        String sixHoursString = this.getMinorDateFormat(TimeGranularity.SIX_HOURS).format(prototype);
        String threeHoursString = this.getMinorDateFormat(TimeGranularity.THREE_HOURS).format(prototype);
        String hourString = this.getMinorDateFormat(TimeGranularity.HOUR).format(prototype);
        String thirtyMinuteString = this.getMinorDateFormat(TimeGranularity.THIRTY_MINUTES).format(prototype);
        String fifteenMinuteString = this.getMinorDateFormat(TimeGranularity.FIFTEEN_MINUTES).format(prototype);
        String tenMinuteString = this.getMinorDateFormat(TimeGranularity.TEN_MINUTES).format(prototype);
        String fiveMinuteString = this.getMinorDateFormat(TimeGranularity.FIVE_MINUTES).format(prototype);
        String minuteString = this.getMinorDateFormat(TimeGranularity.MINUTE).format(prototype);
        String thirtySecondString = this.getMinorDateFormat(TimeGranularity.THIRTY_SECONDS).format(prototype);
        String fifteenSecondString = this.getMinorDateFormat(TimeGranularity.FIFTEEN_SECONDS).format(prototype);
        String tenSecondString = this.getMinorDateFormat(TimeGranularity.TEN_SECONDS).format(prototype);
        String fiveSecondString = this.getMinorDateFormat(TimeGranularity.FIVE_SECONDS).format(prototype);
        String secondString = this.getMinorDateFormat(TimeGranularity.SECOND).format(prototype);
        String hundredMilliString = this.getMinorDateFormat(TimeGranularity.HUNDRED_MILLISECONDS).format(prototype);
        String tenMilliString = this.getMinorDateFormat(TimeGranularity.TEN_MILLISECONDS).format(prototype);
        String milliString = this.getMinorDateFormat(TimeGranularity.MILLISECOND).format(prototype);
        LOGGER.finer("milleniumString = " + milleniumString);
        LOGGER.finer("centuryString = " + centuryString);
        LOGGER.finer("decadeString = " + decadeString);
        LOGGER.finer("yearString = " + yearString);
        LOGGER.finer("halfYearString = " + halfYearString);
        LOGGER.finer("quarterYearString = " + quarterYearString);
        LOGGER.finer("monthShortString = " + monthShortString);
        LOGGER.finer("monthTinyString = " + monthTinyString);
        LOGGER.finer("weekString = " + weekString);
        LOGGER.finer("shortDayString = " + shortDayString);
        LOGGER.finer("tinyDayString = " + tinyDayString);
        LOGGER.finer("sixHoursString = " + sixHoursString);
        LOGGER.finer("threeHoursString = " + threeHoursString);
        LOGGER.finer("hourString = " + hourString);
        LOGGER.finer("thirtyMinuteString = " + thirtyMinuteString);
        LOGGER.finer("fifteenMinuteString = " + fifteenMinuteString);
        LOGGER.finer("tenMinuteString = " + tenMinuteString);
        LOGGER.finer("fiveMinuteString = " + fiveMinuteString);
        LOGGER.finer("minuteString = " + minuteString);
        LOGGER.finer("thirtySecondString = " + thirtySecondString);
        LOGGER.finer("fifteenSecondString = " + fifteenSecondString);
        LOGGER.finer("tenSecondString = " + tenSecondString);
        LOGGER.finer("fiveSecondString = " + fiveSecondString);
        LOGGER.finer("secondString = " + secondString);
        LOGGER.finer("hundredMilliString = " + hundredMilliString);
        LOGGER.finer("tenMilliString = " + tenMilliString);
        LOGGER.finer("milliString = " + milliString);
        String majorDayString = this.getMajorDateFormat(TimeGranularity.DAY_SHORT).format(prototype);
        String majorHourString = this.getMajorDateFormat(TimeGranularity.HOUR).format(prototype);
        String majorMinuteString = this.getMajorDateFormat(TimeGranularity.MINUTE).format(prototype);
        String majorSecondString = this.getMajorDateFormat(TimeGranularity.SECOND).format(prototype);
        int space = 2 * this.gap;
        int milleniumWidth = fm.stringWidth(milleniumString) + space;
        int centuryWidth = fm.stringWidth(centuryString) + space;
        int decadeWidth = fm.stringWidth(decadeString) + space;
        int yearWidth = fm.stringWidth(yearString) + space;
        int halfYearWidth = fm.stringWidth(halfYearString) + space;
        int quarterYearWidth = fm.stringWidth(quarterYearString) + space;
        int monthShortWidth = fm.stringWidth(monthShortString) + space;
        int monthTinyWidth = fm.stringWidth(monthTinyString) + space;
        int weekWidth = fm.stringWidth(weekString) + space;
        int shortDayWidth = fm.stringWidth(shortDayString) + space;
        int tinyDayWidth = fm.stringWidth(tinyDayString) + space;
        int sixHoursWidth = Math.max(fm.stringWidth(sixHoursString), fm.stringWidth(majorDayString) / 4) + space;
        int threeHoursWidth = Math.max(fm.stringWidth(threeHoursString), fm.stringWidth(majorDayString) / 8) + space;
        int hourWidth = Math.max(fm.stringWidth(hourString), fm.stringWidth(majorDayString) / 24) + space;
        int thirtyMinuteWidth = Math.max(fm.stringWidth(thirtyMinuteString), fm.stringWidth(majorHourString) / 2) + space;
        int fifteenMinuteWidth = Math.max(fm.stringWidth(fifteenMinuteString), fm.stringWidth(majorHourString) / 4) + space;
        int tenMinuteWidth = Math.max(fm.stringWidth(tenMinuteString), fm.stringWidth(majorHourString) / 6) + space;
        int fiveMinuteWidth = fm.stringWidth(fiveMinuteString) + space;
        int minuteWidth = fm.stringWidth(minuteString) + space;
        int thirtySecondWidth = Math.max(fm.stringWidth(thirtySecondString), fm.stringWidth(majorMinuteString) / 2) + space;
        int fifteenSecondWidth = Math.max(fm.stringWidth(fifteenSecondString), fm.stringWidth(majorMinuteString) / 4) + space;
        int tenSecondWidth = Math.max(fm.stringWidth(tenSecondString), fm.stringWidth(majorMinuteString) / 6) + space;
        int fiveSecondWidth = Math.max(fm.stringWidth(fiveSecondString), fm.stringWidth(majorMinuteString) / 12) + space;
        int secondWidth = fm.stringWidth(secondString) + space;
        int hundredMilliWidth = Math.max(fm.stringWidth(hundredMilliString), fm.stringWidth(majorSecondString) / 10) + space;
        int tenMilliWidth = Math.max(fm.stringWidth(tenMilliString), fm.stringWidth(majorSecondString) / 100) + space;
        int milliWidth = fm.stringWidth(milliString) + space;
        this.widths.put(TimeGranularity.MILLENIUM, milleniumWidth);
        this.widths.put(TimeGranularity.CENTURY, centuryWidth);
        this.widths.put(TimeGranularity.DECADE, decadeWidth);
        this.widths.put(TimeGranularity.YEAR, yearWidth);
        this.widths.put(TimeGranularity.HALF_YEAR, halfYearWidth);
        this.widths.put(TimeGranularity.QUARTER_YEAR, quarterYearWidth);
        this.widths.put(TimeGranularity.MONTH_SHORT, monthShortWidth);
        this.widths.put(TimeGranularity.MONTH_TINY, monthTinyWidth);
        this.widths.put(TimeGranularity.WEEK, weekWidth);
        this.widths.put(TimeGranularity.DAY_SHORT, shortDayWidth);
        this.widths.put(TimeGranularity.DAY_TINY, tinyDayWidth);
        this.widths.put(TimeGranularity.SIX_HOURS, sixHoursWidth);
        this.widths.put(TimeGranularity.THREE_HOURS, threeHoursWidth);
        this.widths.put(TimeGranularity.HOUR, hourWidth);
        this.widths.put(TimeGranularity.THIRTY_MINUTES, thirtyMinuteWidth);
        this.widths.put(TimeGranularity.FIFTEEN_MINUTES, fifteenMinuteWidth);
        this.widths.put(TimeGranularity.TEN_MINUTES, tenMinuteWidth);
        this.widths.put(TimeGranularity.FIVE_MINUTES, fiveMinuteWidth);
        this.widths.put(TimeGranularity.MINUTE, minuteWidth);
        this.widths.put(TimeGranularity.THIRTY_SECONDS, thirtySecondWidth);
        this.widths.put(TimeGranularity.FIFTEEN_SECONDS, fifteenSecondWidth);
        this.widths.put(TimeGranularity.TEN_SECONDS, tenSecondWidth);
        this.widths.put(TimeGranularity.FIVE_SECONDS, fiveSecondWidth);
        this.widths.put(TimeGranularity.SECOND, secondWidth);
        this.widths.put(TimeGranularity.HUNDRED_MILLISECONDS, hundredMilliWidth);
        this.widths.put(TimeGranularity.TEN_MILLISECONDS, tenMilliWidth);
        this.widths.put(TimeGranularity.MILLISECOND, milliWidth);
        if (LOGGER.isLoggable(Level.FINER)) {
            for (TimeGranularity tg : TimeGranularity.values()) {
                LOGGER.finer(tg + " width = " + this.widths.get(tg));
            }
        }
    }

    public String getMajorDateString(TimeGranularity level, long date) {
        DateFormat dateFormat = this.majorFormats.get(level);
        if (dateFormat != null) {
            dateFormat.setTimeZone(this.timeZone);
            return dateFormat.format(new Date(date));
        }
        return "???";
    }

    public String getMinorDateString(TimeGranularity level, long date) {
        Calendar c2 = Calendar.getInstance(this.timeZone);
        c2.setFirstDayOfWeek(TimeGranularity.getFirstDayOfWeek());
        c2.setTimeInMillis(date);
        switch (level) {
            case QUARTER_YEAR: {
                switch (c2.get(2)) {
                    case 0: 
                    case 1: 
                    case 2: {
                        return this.quarterYearFormat.format(new String[]{"1"});
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        return this.quarterYearFormat.format(new String[]{"2"});
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return this.quarterYearFormat.format(new String[]{"3"});
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        return this.quarterYearFormat.format(new String[]{"4"});
                    }
                }
                break;
            }
            case HALF_YEAR: {
                switch (c2.get(2)) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        return this.halfYearFormat.format(new String[]{"1"});
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        return this.halfYearFormat.format(new String[]{"2"});
                    }
                }
                break;
            }
            default: {
                DateFormat dateFormat = this.minorFormats.get(level);
                if (dateFormat == null) break;
                dateFormat.setTimeZone(this.timeZone);
                return dateFormat.format(new Date(date));
            }
        }
        return "";
    }

    public MessageFormat getQuarterYearFormat() {
        return this.quarterYearFormat;
    }

    public void setQuarterYearFormat(MessageFormat format) {
        this.quarterYearFormat = format;
    }

    public MessageFormat getHalfYearFormat() {
        return this.halfYearFormat;
    }

    public void setHalfYearFormat(MessageFormat format) {
        this.halfYearFormat = format;
    }

    public DateFormat getMajorDateFormat(TimeGranularity granularity) {
        return this.majorFormats.get(granularity);
    }

    public void setMajorDateFormat(TimeGranularity granularity, DateFormat format) throws DatelineModelException {
        this.majorFormats.put(granularity, format);
        this.initWidths();
        this.calculateDatelineWidth();
    }

    public DateFormat getMinorDateFormat(TimeGranularity granularity) {
        return this.minorFormats.get(granularity);
    }

    public void setMinorDateFormat(TimeGranularity granularity, DateFormat format) throws DatelineModelException {
        this.minorFormats.put(granularity, format);
        this.initWidths();
        this.calculateDatelineWidth();
    }

    @Override
    public void requestVisibleTimeSpan(ITimeSpan span) throws DatelineModelException {
        block10: {
            TimeGranularity oldGranularity = (TimeGranularity)this.granularity;
            IZoomPolicy dp = this.dateline.getPolicyProvider().getPolicy(IZoomPolicy.class);
            int visibleWidth = this.dateline.getVisibleRect().width;
            if (visibleWidth < 1) {
                visibleWidth = 1;
            }
            TimeGranularity tg = this.getTimeGranularity(span, visibleWidth);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("current time span = " + this.timeSpan);
                LOGGER.fine("requested visible time span = " + span);
                LOGGER.fine("total dateline width = " + this.dateline.getWidth());
                LOGGER.fine("currently visible width = " + visibleWidth);
                LOGGER.fine("new granularity = " + tg);
            }
            Integer width = this.widths.get(tg);
            if (dp.getGranularityIndex(tg) != -1 && width != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("new time granularity fits within smallest and largest time granularity");
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("union = " + this.timeSpan);
                }
                double delta = tg.getDelta(span, this.timeZone);
                long usedWidth = (long)(delta * (double)width.intValue());
                this.zoom = (double)visibleWidth / (double)usedWidth;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("time granularity delta = " + delta);
                    LOGGER.fine("used width without zooming = " + usedWidth);
                }
                this.granularity = tg;
                try {
                    DatelineModelEvent event = new DatelineModelEvent(this, DatelineModelEvent.ID.REQUESTED_VISIBLE_TIME_SPAN_CHANGED, span);
                    try {
                        this.fireDatelineModelWillChangeEvent(event);
                        this.calculateDatelineWidth();
                        this.fireDatelineModelChangeEvent(event);
                        break block10;
                    }
                    catch (DatelineModelException ex) {
                        this.granularity = oldGranularity;
                        throw ex;
                    }
                }
                catch (DatelineModelVetoException ex) {
                    this.granularity = oldGranularity;
                    throw new DatelineModelException("the change was rejected by a listener", DatelineModelException.ID.VETO_EXCEPTION);
                }
            }
            this.granularity = oldGranularity;
            throw new DatelineModelException("granularity not supported: " + tg, DatelineModelException.ID.REQUESTED_TIME_SPAN_UNSATISFIED);
        }
    }

    @Override
    public String getTimeString(long time) {
        DateFormat format = DateFormat.getDateTimeInstance(3, 3);
        format.setTimeZone(this.timeZone);
        return format.format(time);
    }
}

