/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.mac;

import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.treetable.IColumnModel;
import com.dlsc.flexgantt.swing.GanttChart;
import com.dlsc.flexgantt.swing.NavigationControl;
import com.dlsc.flexgantt.swing.NavigationControlPanel;
import com.dlsc.flexgantt.swing.NavigationControlType;
import com.dlsc.flexgantt.swing.PagingControl;
import com.dlsc.flexgantt.swing.PagingControlPanel;
import com.dlsc.flexgantt.swing.PagingControlType;
import com.dlsc.flexgantt.swing.UtilityControlPanel;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.LayerContainerScrollPane;
import com.dlsc.flexgantt.swing.layer.system.DatelineLayer;
import com.dlsc.flexgantt.swing.mac.MacComponentFactory;
import com.dlsc.flexgantt.swing.mac.MacTimeGranularitySelectorFactory;
import com.dlsc.flexgantt.swing.selector.ISelectorFactory;
import com.dlsc.flexgantt.swing.util.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.TimeZone;
import javax.swing.JComponent;

public class MacGanttChart
extends GanttChart {
    private ISelectorFactory selectorFactory = new MacTimeGranularitySelectorFactory();

    public MacGanttChart(IGanttChartModel model, IColumnModel columnModel, TimeZone zone) {
        super(model, columnModel, zone, MacComponentFactory.getInstance());
        this.init();
    }

    public MacGanttChart(IGanttChartModel model, IColumnModel columnModel) {
        super(model, columnModel, MacComponentFactory.getInstance());
        this.init();
    }

    public MacGanttChart(IGanttChartModel model) {
        super(model, MacComponentFactory.getInstance());
        this.init();
    }

    public MacGanttChart(MacComponentFactory compFactory) {
        super(compFactory);
        this.init();
    }

    public MacGanttChart() {
        super(MacComponentFactory.getInstance());
        this.init();
    }

    @Override
    public ISelectorFactory getSelectorFactory() {
        return this.selectorFactory;
    }

    private void init() {
        ColorUtil.setGridColor(Color.LIGHT_GRAY);
        LayerContainer lc2 = this.getLayerContainer();
        lc2.getSystemLayer(DatelineLayer.class).setFocusedTimeVisible(false);
        lc2.getSystemLayer(DatelineLayer.class).setHorizonLimitsVisible(false);
        LayerContainerScrollPane lcsp = this.getLayerContainerScrollPane();
        NavigationControlPanel ncp = (NavigationControlPanel)lcsp.getCorner("UPPER_RIGHT_CORNER");
        for (NavigationControlType type : NavigationControlType.values()) {
            NavigationControl nc2 = ncp.getNavigationControl(type);
            if (nc2 == null) continue;
            nc2.setOpaque(true);
            nc2.setBackground(new Color(230, 230, 230));
        }
        UtilityControlPanel ucp = (UtilityControlPanel)lcsp.getCorner("LOWER_LEFT_CORNER");
        for (Component comp : ucp.getComponents()) {
            JComponent jc2 = (JComponent)comp;
            jc2.setOpaque(true);
            jc2.setBackground(new Color(230, 230, 230));
        }
        PagingControlPanel pcp = ucp.getPagingControlPanel();
        for (PagingControlType pct : PagingControlType.values()) {
            PagingControl pc2 = pcp.getPagingControl(pct);
            pc2.setOpaque(true);
            pc2.setBackground(new Color(230, 230, 230));
        }
    }
}

