/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.timeline;

import com.dlsc.flexgantt.model.gantt.IActivityObject;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.swing.layer.timeline.DefaultTimelineObjectRenderer;
import com.dlsc.flexgantt.swing.layer.timeline.TimelineObjectLayer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;

public class DefaultActivityObjectRenderer
extends DefaultTimelineObjectRenderer {
    private Color percentageFillColor1 = new Color(203, 218, 245).darker();
    private Color percentageFillColor2 = new Color(153, 183, 236).darker();
    private IActivityObject activityObject;

    public DefaultActivityObjectRenderer() {
        this.setForeground(Color.BLACK);
        this.setFont(new Font("helvetica", 1, 9));
    }

    @Override
    public Component getTimelineObjectRendererComponent(TimelineObjectLayer layer, TimelineObjectPath path, boolean selected, boolean hasFocus, boolean highlighted, int row) {
        super.getTimelineObjectRendererComponent(layer, path, selected, hasFocus, highlighted, row);
        this.activityObject = (IActivityObject)path.getTimelineObject();
        return this;
    }

    @Override
    protected void paintActivityContent(Graphics g2) {
        super.paintActivityContent(g2);
        Color fillColor1Old = this.getActivityFillColor1();
        Color fillColor2Old = this.getActivityFillColor2();
        double p2 = this.activityObject.getPercentageComplete();
        int x2 = (int)((double)this.getWidth() / 100.0 * p2);
        this.setActivityFillColor1(this.percentageFillColor1);
        this.setActivityFillColor2(this.percentageFillColor2);
        Shape clip = g2.getClip();
        g2.clipRect(0, 0, x2, this.getHeight());
        super.paintActivityContent(g2);
        this.setActivityFillColor1(fillColor1Old);
        this.setActivityFillColor2(fillColor2Old);
        g2.setClip(clip);
        if (x2 < this.getWidth() - 6 || !this.isRoundedCorners()) {
            g2.setColor(this.getActivityLineColor());
            g2.drawLine(x2 - 1, 2, x2 - 1, this.getHeight() - 2);
        }
    }

    @Override
    protected void paintActivityFocus(Graphics g2) {
        super.paintActivityFocus(g2);
        Graphics2D g2d = (Graphics2D)g2;
        double p2 = this.activityObject.getPercentageComplete();
        int x2 = Math.max(4, (int)((double)this.getWidth() / 100.0 * p2));
        int h2 = this.getHeight() - 1;
        int[] xx = new int[]{x2 - 4, x2 - 4, x2, x2 + 4, x2 + 4, x2 - 4};
        int[] yy = new int[]{h2, h2 - 4, h2 - 8, h2 - 4, h2, h2};
        g2d.setColor(new Color(240, 240, 240));
        g2d.fillPolygon(xx, yy, 6);
        g2d.setColor(Color.BLACK);
        g2d.drawPolygon(xx, yy, 6);
    }

    public Color getPercentageFillColor1() {
        return this.percentageFillColor1;
    }

    public void setPercentageFillColor1(Color color) {
        this.percentageFillColor1 = color;
    }

    public Color getPercentageFillColor2() {
        return this.percentageFillColor2;
    }

    public void setPercentageFillColor2(Color color) {
        this.percentageFillColor2 = color;
    }

    protected IActivityObject getActivityObject() {
        return this.activityObject;
    }
}

