/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.command.ICommand;
import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.dateline.DatelineModelEvent;
import com.dlsc.flexgantt.model.dateline.DatelineModelException;
import com.dlsc.flexgantt.model.dateline.DatelineModelVetoException;
import com.dlsc.flexgantt.model.dateline.GridLine;
import com.dlsc.flexgantt.model.dateline.IDatelineModel;
import com.dlsc.flexgantt.model.dateline.IDatelineModelListener;
import com.dlsc.flexgantt.model.dateline.IGranularity;
import com.dlsc.flexgantt.model.gantt.GanttChartModelEvent;
import com.dlsc.flexgantt.model.gantt.IGanttChartModelListener;
import com.dlsc.flexgantt.model.gantt.ISpreadsheet;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.layer.IGridPolicy;
import com.dlsc.flexgantt.policy.layer.ISpreadsheetEditPolicy;
import com.dlsc.flexgantt.swing.IEditable;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.AbstractSystemLayer;
import com.dlsc.flexgantt.swing.layer.system.DefaultSpreadsheetCellEditor;
import com.dlsc.flexgantt.swing.layer.system.DefaultSpreadsheetCellRenderer;
import com.dlsc.flexgantt.swing.layer.system.ISpreadsheetCellEditor;
import com.dlsc.flexgantt.swing.layer.system.ISpreadsheetCellRenderer;
import com.dlsc.flexgantt.swing.timeline.Dateline;
import com.dlsc.flexgantt.swing.treetable.DefaultTreeTableCellRenderer;
import com.dlsc.flexgantt.swing.treetable.ITreeTableCellEditor;
import com.dlsc.flexgantt.swing.treetable.ITreeTableCellRenderer;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.swing.treetable.TreeTableNode;
import com.dlsc.flexgantt.swing.util.ColorField;
import com.dlsc.flexgantt.swing.util.ColorUtil;
import com.dlsc.flexgantt.util.INamedObject;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;

public class SpreadsheetLayer
extends AbstractSystemLayer
implements IGanttChartModelListener,
FocusListener,
MouseInputListener,
CellEditorListener,
IDatelineModelListener,
PropertyChangeListener,
TreeWillExpandListener,
IEditable {
    private static final Logger LOGGER = Logger.getLogger(SpreadsheetLayer.class.getName());
    private ISpreadsheetCellEditor cellEditor;
    private CellEditorRemover editorRemover;
    private Component editorComp;
    private int editingRow;
    private Color cellFocusColor = ColorUtil.getFocusBorderColor();
    private ITimeSpan editingSpan;
    private Map<Class, ISpreadsheetCellRenderer> rendererMap;
    private Map<Class, ISpreadsheetCellRenderer> rendererCache;
    private Map<Class, ISpreadsheetCellEditor> editorMap;
    private KeyAdapter escapeListener;
    private boolean hasFocus = false;

    public SpreadsheetLayer(LayerContainer lc2) {
        super("Spreadsheet", lc2);
        lc2.addFocusListener(this);
        lc2.getGanttChart().addPropertyChangeListener(this);
        lc2.getTreeTable().addTreeWillExpandListener(this);
        this.rendererMap = new HashMap<Class, ISpreadsheetCellRenderer>(10);
        this.rendererCache = new HashMap<Class, ISpreadsheetCellRenderer>(10);
        this.editorMap = new HashMap<Class, ISpreadsheetCellEditor>(10);
        this.setCellRenderer(Object.class, new DefaultSpreadsheetCellRenderer());
        this.setCellRenderer(Boolean.class, new BooleanRenderer());
        this.setCellRenderer(Date.class, new DateRenderer());
        this.setCellRenderer(Calendar.class, new CalendarRenderer());
        this.setCellRenderer(Number.class, new NumberRenderer());
        this.setCellRenderer(Double.class, new DoubleRenderer());
        this.setCellRenderer(ImageIcon.class, new IconRenderer());
        this.setCellRenderer(Color.class, new ColorRenderer());
        this.setCellRenderer(Enum.class, new EnumRenderer());
        this.setCellEditor(Object.class, new GenericEditor());
        this.setCellEditor(Boolean.class, new BooleanEditor());
        this.setCellEditor(Number.class, new NumberEditor());
        this.setCellEditor(Date.class, new DateEditor());
        this.setCellEditor(Calendar.class, new CalendarEditor());
        this.setCellEditor(Color.class, new ColorEditor());
        this.setCellEditor(Enum.class, new EnumEditor());
        this.setVisible(false);
        this.escapeListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e2) {
                ISpreadsheetCellEditor editor;
                if (e2.getKeyCode() == 27) {
                    ISpreadsheetCellEditor editor2 = SpreadsheetLayer.this.getCellEditor();
                    if (editor2 != null) {
                        editor2.cancelCellEditing();
                    }
                } else if (e2.getKeyCode() == 9) {
                    ISpreadsheetCellEditor editor3 = SpreadsheetLayer.this.getCellEditor();
                    if (editor3 != null) {
                        editor3.stopCellEditing();
                        SpreadsheetLayer.this.focusOnCellNext();
                    }
                } else if (e2.getKeyCode() == 10 && (editor = SpreadsheetLayer.this.getCellEditor()) != null) {
                    editor.stopCellEditing();
                    SpreadsheetLayer.this.focusOnCellBelow();
                }
            }
        };
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }

    public void setHasFocus(boolean hasFocus) {
        this.hasFocus = hasFocus;
        this.repaint();
    }

    public void setCellFocusColor(Color cellFocusColor) {
        this.cellFocusColor = cellFocusColor;
    }

    public Color getCellFocusColor() {
        return this.cellFocusColor;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.layerContainer.addMouseListener(this);
            this.layerContainer.addMouseMotionListener(this);
        } else {
            this.layerContainer.removeMouseListener(this);
            this.layerContainer.removeMouseMotionListener(this);
        }
        super.setVisible(visible);
    }

    @Override
    protected void paintLayer(Graphics g2) {
        super.paintLayer(g2);
        Rectangle clip = g2.getClipBounds();
        int y2 = clip.y;
        List<TreeTableNode> treeTableNodes = this.getLayerContainer().getTreeTable().getTreeTableNodes();
        int startNode = this.getStartRow();
        if (treeTableNodes != null && treeTableNodes.size() > 0) {
            IPolicyProvider pp = this.layerContainer.getPolicyProvider();
            IGridPolicy gp = pp.getPolicy(IGridPolicy.class);
            Dateline dateline = this.getDateline();
            IDatelineModel gridModel = dateline.getModel();
            List<GridLine> grid = gridModel.getGrid(clip.x, clip.x + clip.width, false);
            y2 = treeTableNodes.get(startNode).getY();
            int clipLine = 0;
            for (int row = startNode; row < treeTableNodes.size(); ++row) {
                g2.clipRect(0, Math.max(clipLine, y2), this.getWidth(), this.getHeight());
                TreeTableNode node = treeTableNodes.get(row);
                int rowHeight = node.getHeight();
                Object modelNode = treeTableNodes.get(row).getModelNode();
                this.paintRowValues(g2, modelNode, row, y2, rowHeight, grid, gp);
                if ((y2 += rowHeight) >= clip.y + clip.height) break;
                TreeTable table = this.getTreeTable();
                if (node != table.getAnimationNode()) continue;
                clipLine = y2;
                y2 -= (int)((double)node.getTotalChildrenHeight() * (1.0 - table.getAnimationPercentage()));
            }
            g2.setClip(clip);
            if (this.editingSpan != null && this.editingRow >= 0 && this.hasFocus) {
                Rectangle rect = this.getCellRect(this.editingRow, this.editingSpan);
                g2.setColor(this.cellFocusColor);
                g2.drawRect(rect.x - 3, rect.y - 3, rect.width + 5, rect.height + 5);
                g2.drawRect(rect.x - 2, rect.y - 2, rect.width + 3, rect.height + 3);
                g2.drawRect(rect.x - 1, rect.y - 1, rect.width + 1, rect.height + 1);
            }
        }
    }

    private void paintRowValues(Graphics g2, Object node, int row, int y2, int h2, List<GridLine> grid, IGridPolicy gp) {
        Dateline dateline = this.getDateline();
        if (grid != null) {
            g2.setColor(this.getLayerContainer().getForeground());
            int l2 = grid.size();
            --h2;
            IGranularity granularity = dateline.getGranularity();
            for (int i2 = 0; i2 < l2 - 1; ++i2) {
                Object value;
                int xx1 = grid.get(i2).getLocation();
                int xx2 = grid.get(i2 + 1).getLocation();
                ITimeSpan unadjustedSpan = dateline.getTimeSpanAt(xx1 + 1, false);
                ITimeSpan adjustedSpan = gp.getGridAdjustedTimeSpan(granularity, unadjustedSpan, dateline.getModel(), false);
                if (this.isEditing() && row == this.editingRow && adjustedSpan.equals(this.editingSpan) || (value = this.getModel().getSpreadsheetValue(this.ganttChart.getActiveSpreadsheet(), node, adjustedSpan)) == null) continue;
                int x2 = xx1 + 1;
                int w2 = xx2 - xx1 - 1;
                this.paintCellValue(g2, node, value, row, adjustedSpan, x2, y2, w2, h2);
            }
        }
    }

    private void paintCellValue(Graphics g2, Object node, Object value, int row, ITimeSpan span, int x2, int y2, int w2, int h2) {
        Class<?> cl = value.getClass();
        ISpreadsheetCellRenderer renderer = this.getCellRenderer(cl);
        if (renderer != null) {
            Component comp = renderer.getSpreadsheetCellRendererComponent(this, node, value, false, row, span, false);
            this.layerContainer.getRendererPane().paintComponent(g2, comp, this.layerContainer, x2, y2, w2, h2, false);
        }
    }

    @Override
    public void focusGained(FocusEvent e2) {
    }

    @Override
    public void focusLost(FocusEvent e2) {
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
    }

    @Override
    public void ganttChartChanged(GanttChartModelEvent evt) {
        if (evt.getId().equals((Object)GanttChartModelEvent.ID.SPREADSHEET_VALUE_CHANGED)) {
            this.layerContainer.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
        int row;
        this.layerContainer.requestFocus();
        if (e2.getButton() == 1 && (row = this.getTreeTable().getRowAt(e2.getY())) != -1) {
            IPolicyProvider pp = this.layerContainer.getPolicyProvider();
            IGridPolicy gp = pp.getPolicy(IGridPolicy.class);
            ITimeSpan unadjustedSpan = this.getDateline().getTimeSpanAt(e2.getX(), false);
            IGranularity granularity = this.getDateline().getGranularity();
            ITimeSpan adjustedSpan = gp.getGridAdjustedTimeSpan(granularity, unadjustedSpan, this.getDateline().getModel(), false);
            if (e2.getClickCount() == 1) {
                if (this.isEditing()) {
                    this.cellEditor.stopCellEditing();
                }
                this.setEditingRow(row);
                this.setEditingTimeSpan(adjustedSpan);
            } else if (e2.getClickCount() == 2) {
                this.editCellAt(row, adjustedSpan, e2);
            }
            for (LayerContainer lc2 : this.ganttChart.getLayerContainers()) {
                SpreadsheetLayer spreadsheetLayer = lc2.getSystemLayer(SpreadsheetLayer.class);
                if (spreadsheetLayer == null) continue;
                if (spreadsheetLayer.equals(this)) {
                    this.setHasFocus(true);
                    continue;
                }
                this.setHasFocus(false);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }

    public void removeEditor() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.editorRemover);
        this.editorRemover = null;
        ISpreadsheetCellEditor editor = this.getCellEditor();
        if (editor != null) {
            editor.removeCellEditorListener(this);
            if (this.editorComp != null) {
                this.layerContainer.remove(this.editorComp);
                this.editorComp.addKeyListener(this.escapeListener);
            }
            Rectangle cellRect = this.getCellRect(this.editingRow, this.editingSpan);
            this.setCellEditor(null);
            this.editorComp = null;
            this.layerContainer.repaint(cellRect);
        }
        this.ganttChart.requestFocusInWindow();
    }

    @Override
    public Component getEditorComponent() {
        return this.editorComp;
    }

    @Override
    public boolean isEditing() {
        return this.cellEditor != null;
    }

    public ISpreadsheetCellEditor getCellEditor() {
        return this.cellEditor;
    }

    private void setCellEditor(ISpreadsheetCellEditor editor) {
        this.cellEditor = editor;
    }

    private Component prepareEditor(ISpreadsheetCellEditor editor, int row, ITimeSpan span, InputEvent evt) {
        Object node = this.getTreeTable().getTreeTableNodes().get(row).getModelNode();
        Object value = this.getModel().getSpreadsheetValue(this.ganttChart.getActiveSpreadsheet(), node, span);
        Component comp = editor.getSpreadsheetCellEditorComponent(this, value, row, span);
        if (comp instanceof JComponent) {
            JComponent jComp = (JComponent)comp;
            if (jComp.getNextFocusableComponent() == null) {
                jComp.setNextFocusableComponent(this.layerContainer);
            }
            jComp.setFocusTraversalKeysEnabled(false);
            jComp.addKeyListener(this.escapeListener);
        }
        comp.setBackground(this.getLayerContainer().getBackground());
        return comp;
    }

    @Override
    public boolean editCellFocused(InputEvent evt) {
        return this.editCellAt(this.editingRow, this.editingSpan, evt);
    }

    public boolean editCellAt(int row, ITimeSpan span) {
        return this.editCellAt(row, span, null);
    }

    public boolean editCellAt(int row, ITimeSpan span, InputEvent e2) {
        ISpreadsheetCellEditor editor;
        if (this.cellEditor != null && !this.cellEditor.stopCellEditing()) {
            return false;
        }
        TreeTable table = this.getTreeTable();
        if (row < 0 || row >= table.getRowCount()) {
            return false;
        }
        if (this.editorRemover == null) {
            KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.editorRemover = new CellEditorRemover(fm);
            fm.addPropertyChangeListener("permanentFocusOwner", this.editorRemover);
        }
        if ((editor = this.getCellEditor(row, span)) != null && editor.isCellEditable(e2)) {
            this.editorComp = this.prepareEditor(editor, row, span, e2);
            if (this.editorComp == null) {
                this.removeEditor();
                return false;
            }
            this.layerContainer.add(this.editorComp);
            this.editorComp.setBounds(this.getCellRect(row, span));
            this.editorComp.invalidate();
            this.editorComp.validate();
            this.editorComp.setBackground(this.getTreeTable().getBackground(row));
            this.setCellEditor(editor);
            this.setEditingRow(row);
            this.setEditingTimeSpan(span);
            editor.addCellEditorListener(this);
            this.editorComp.requestFocusInWindow();
            if (this.editorComp instanceof JComboBox) {
                JComboBox box = (JComboBox)this.editorComp;
                box.showPopup();
            }
            return true;
        }
        return false;
    }

    public int getEditingRow() {
        return this.editingRow;
    }

    public void setEditingRow(int row) {
        this.editingRow = row;
    }

    public ITimeSpan getEditingTimeSpan() {
        return this.editingSpan;
    }

    public void setEditingTimeSpan(ITimeSpan span) {
        this.editingSpan = span;
        this.repaint();
    }

    public ISpreadsheetCellEditor getCellEditor(int row, ITimeSpan span) {
        List<TreeTableNode> nodes = this.getTreeTable().getTreeTableNodes();
        Object node = nodes.get(row).getModelNode();
        Class cl = this.getModel().getSpreadsheetValueType(this.ganttChart.getActiveSpreadsheet(), node, span);
        return this.getCellEditor(cl);
    }

    public Rectangle getCellRect(int row, ITimeSpan span) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("getting cell rect for row = " + row + " span = " + span);
        }
        List<TreeTableNode> nodes = this.getTreeTable().getTreeTableNodes();
        int y2 = nodes.get(row).getY();
        int x1 = this.getTimeLocation(span.getStartTime());
        int x2 = this.getTimeLocation(span.getEndTime());
        int width = x2 - x1;
        int height = nodes.get(row).getHeight();
        Rectangle cellRect = new Rectangle(x1, y2, width - 1, height - 1);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("cell rect = " + cellRect);
        }
        return cellRect;
    }

    @Override
    public void editingStopped(ChangeEvent e2) {
        ISpreadsheetCellEditor editor = this.getCellEditor();
        if (editor != null) {
            Object value = editor.getCellEditorValue();
            IPolicyProvider policyProvider = this.layerContainer.getPolicyProvider();
            ISpreadsheetEditPolicy policy = policyProvider.getPolicy(ISpreadsheetEditPolicy.class);
            List<TreeTableNode> nodes = this.getTreeTable().getTreeTableNodes();
            ICommand cmd = policy.getChangeSpreadsheetValueCommand(this.getModel(), nodes.get(this.editingRow).getModelNode(), this.ganttChart.getActiveSpreadsheet(), this.editingSpan, value);
            this.ganttChart.commandExecute(cmd);
            this.removeEditor();
        }
    }

    @Override
    public void editingCanceled(ChangeEvent e2) {
        this.removeEditor();
    }

    @Override
    public void datelineModelWillChange(DatelineModelEvent evt) throws DatelineModelVetoException {
    }

    @Override
    public void datelineModelChanged(DatelineModelEvent e2) {
        if (this.cellEditor != null) {
            this.cellEditor.stopCellEditing();
        }
    }

    public void setCellRenderer(Class cl, ISpreadsheetCellRenderer renderer) {
        this.rendererMap.put(cl, renderer);
    }

    public void setCellEditor(Class cl, ISpreadsheetCellEditor editor) {
        this.editorMap.put(cl, editor);
    }

    public ISpreadsheetCellRenderer getCellRenderer(Class cl) {
        if (cl == null) {
            return null;
        }
        ISpreadsheetCellRenderer renderer = this.rendererCache.get(cl);
        if (renderer != null) {
            return renderer;
        }
        renderer = this.rendererMap.get(cl);
        if (renderer != null) {
            this.rendererCache.put(cl, renderer);
            return renderer;
        }
        renderer = this.getCellRenderer(cl.getSuperclass());
        this.rendererCache.put(cl, renderer);
        return renderer;
    }

    public ISpreadsheetCellEditor getCellEditor(Class cl) {
        if (cl == null) {
            return null;
        }
        ISpreadsheetCellEditor editor = this.editorMap.get(cl);
        if (editor != null) {
            return editor;
        }
        return this.getCellEditor(cl.getSuperclass());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource().equals(this.getGanttChart()) && evt.getPropertyName().equals("activeSpreadsheet")) {
            ISpreadsheet oldSpreadsheet = (ISpreadsheet)evt.getOldValue();
            ISpreadsheet newSpreadsheet = (ISpreadsheet)evt.getNewValue();
            IGranularity oldGranularity = null;
            IGranularity newGranularity = null;
            if (oldSpreadsheet != null) {
                oldGranularity = oldSpreadsheet.getGranularity();
            }
            if (newSpreadsheet != null) {
                newGranularity = newSpreadsheet.getGranularity();
            }
            if (this.isDifferentGranularity(oldGranularity, newGranularity)) {
                this.editingSpan = null;
                this.repaint();
            }
            if (newSpreadsheet != null) {
                this.editingStopped(null);
                try {
                    IDatelineModel datelineModel = this.getGanttChart().getDatelineModel();
                    datelineModel.setSpreadsheetCellWidth(newSpreadsheet.getCellWidth());
                    datelineModel.setGranularity(newSpreadsheet.getGranularity());
                    datelineModel.setZoom(1.0);
                }
                catch (DatelineModelException e2) {
                    e2.printStackTrace();
                }
                this.setVisible(true);
            } else {
                this.setVisible(false);
            }
        }
    }

    private boolean isDifferentGranularity(IGranularity<?> oldGranularity, IGranularity<?> newGranularity) {
        if (oldGranularity != null && newGranularity != null) {
            return !oldGranularity.equals(newGranularity);
        }
        return false;
    }

    private void clearFocus() {
        this.editingRow = -1;
        this.editingSpan = null;
        this.repaint();
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        this.clearFocus();
        this.removeEditor();
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        this.clearFocus();
        this.removeEditor();
    }

    private void showFocusedCell() {
        Rectangle rect = this.getCellRect(this.editingRow, this.editingSpan);
        this.layerContainer.scrollRectToVisible(rect);
        this.repaint();
    }

    public void focusOnCellBelow() {
        this.editingRow = Math.min(this.editingRow + 1, this.getTreeTable().getRowCount() - 1);
        this.showFocusedCell();
    }

    public void focusOnCellAbove() {
        this.editingRow = Math.max(this.editingRow - 1, 0);
        this.showFocusedCell();
    }

    public void focusOnCellPrevious() {
        IDatelineModel model = this.getDateline().getModel();
        Rectangle rect = this.getCellRect(this.editingRow, this.editingSpan);
        ITimeSpan newSpan = model.getTimeSpanAt(rect.x - 5, false);
        if (model.getTimeSpan().intersects(newSpan)) {
            this.editingSpan = newSpan;
        }
        this.showFocusedCell();
    }

    public void focusOnCellNext() {
        IDatelineModel model = this.getDateline().getModel();
        Rectangle rect = this.getCellRect(this.editingRow, this.editingSpan);
        ITimeSpan newSpan = model.getTimeSpanAt(rect.x + rect.width + 5, false);
        if (model.getTimeSpan().intersects(newSpan)) {
            this.editingSpan = newSpan;
        }
        this.showFocusedCell();
    }

    public void focusOnFirstCell() {
        this.editingRow = 0;
        this.editingSpan = this.getDateline().getTimeSpanAt(0, false);
        this.showFocusedCell();
    }

    public void focusOnLastCell() {
        TreeTable table = this.getTreeTable();
        this.editingRow = table.getRowCount() - 1;
        this.editingSpan = this.getDateline().getTimeSpanAt(this.getDateline().getWidth() - 5, false);
    }

    public void focusOnPageUp() {
        TreeTable table = this.getTreeTable();
        this.editingRow = Math.max(this.editingRow - table.getVisibleRowCount(), 0);
        this.showFocusedCell();
    }

    public void focusOnPageDown() {
        TreeTable table = this.getTreeTable();
        this.editingRow = Math.min(this.editingRow + table.getVisibleRowCount(), this.getTreeTable().getRowCount() - 1);
        this.showFocusedCell();
    }

    private class BooleanRenderer
    extends JCheckBox
    implements ITreeTableCellRenderer,
    ISpreadsheetCellRenderer {
        private final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
        }

        @Override
        public Component getTreeTableCellRendererComponent(TreeTable tree, Object node, Object value, int depth, boolean selected, boolean expanded, boolean leaf, int row, int column, boolean hasFocus) {
            if (selected) {
                this.setForeground(tree.getSelectionForeground());
                super.setBackground(tree.getSelectionBackground());
            } else {
                this.setForeground(tree.getForeground());
                this.setBackground(tree.getBackground());
            }
            this.setSelected(value != null && (Boolean)value != false);
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(this.noFocusBorder);
            }
            return this;
        }

        @Override
        public Component getSpreadsheetCellRendererComponent(SpreadsheetLayer spreadsheet, Object node, Object value, boolean selected, int row, ITimeSpan span, boolean hasFocus) {
            TreeTable treeTable = spreadsheet.getTreeTable();
            return this.getTreeTableCellRendererComponent(treeTable, node, value, 0, selected, false, false, row, 1, hasFocus);
        }
    }

    private class DateRenderer
    extends DefaultTreeTableCellRenderer
    implements ISpreadsheetCellRenderer {
        private DateFormat formatter;

        private DateRenderer() {
        }

        @Override
        public String getText(Object node, Object value) {
            if (this.formatter == null) {
                this.formatter = DateFormat.getDateInstance(3);
            }
            if (value != null) {
                return this.formatter.format(value);
            }
            return "";
        }

        @Override
        public Component getSpreadsheetCellRendererComponent(SpreadsheetLayer spreadsheet, Object node, Object value, boolean selected, int row, ITimeSpan span, boolean hasFocus) {
            TreeTable treeTable = spreadsheet.getTreeTable();
            return this.getTreeTableCellRendererComponent(treeTable, node, value, 0, selected, false, false, row, 1, hasFocus);
        }
    }

    private class CalendarRenderer
    extends DateRenderer {
        private CalendarRenderer() {
        }

        @Override
        public String getText(Object node, Object value) {
            if (value != null) {
                return super.getText(node, ((Calendar)value).getTime());
            }
            return "";
        }
    }

    private class NumberRenderer
    extends DefaultTreeTableCellRenderer
    implements ISpreadsheetCellRenderer {
        public NumberRenderer() {
            this.setHorizontalAlignment(4);
        }

        @Override
        public Component getSpreadsheetCellRendererComponent(SpreadsheetLayer spreadsheet, Object node, Object value, boolean selected, int row, ITimeSpan span, boolean hasFocus) {
            TreeTable treeTable = spreadsheet.getTreeTable();
            return this.getTreeTableCellRendererComponent(treeTable, node, value, 0, selected, false, false, row, 1, hasFocus);
        }
    }

    private class DoubleRenderer
    extends NumberRenderer
    implements ISpreadsheetCellRenderer {
        private NumberFormat formatter;

        private DoubleRenderer() {
        }

        @Override
        public String getText(Object node, Object value) {
            if (this.formatter == null) {
                this.formatter = NumberFormat.getInstance();
            }
            if (value != null) {
                return this.formatter.format(value);
            }
            return "";
        }

        @Override
        public Component getSpreadsheetCellRendererComponent(SpreadsheetLayer spreadsheet, Object node, Object value, boolean selected, int row, ITimeSpan span, boolean hasFocus) {
            TreeTable treeTable = spreadsheet.getTreeTable();
            return super.getTreeTableCellRendererComponent(treeTable, node, value, 0, selected, false, false, row, 1, hasFocus);
        }
    }

    private class IconRenderer
    extends DefaultTreeTableCellRenderer
    implements ISpreadsheetCellRenderer {
        public IconRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        protected Icon getIcon(Object node, Object value, int column, boolean leaf, boolean expanded) {
            if (value instanceof Icon) {
                return (Icon)value;
            }
            return null;
        }

        @Override
        protected String getText(Object node, Object value) {
            return "";
        }

        @Override
        public Component getSpreadsheetCellRendererComponent(SpreadsheetLayer spreadsheet, Object node, Object value, boolean selected, int row, ITimeSpan span, boolean hasFocus) {
            TreeTable treeTable = spreadsheet.getTreeTable();
            return this.getTreeTableCellRendererComponent(treeTable, node, value, 0, selected, false, false, row, 1, hasFocus);
        }
    }

    private class ColorRenderer
    extends AbstractCellEditor
    implements ITreeTableCellRenderer,
    ISpreadsheetCellRenderer {
        private ColorField field = new ColorField();

        private ColorRenderer() {
        }

        @Override
        public Component getTreeTableCellRendererComponent(TreeTable tree, Object node, Object value, int depth, boolean selected, boolean expanded, boolean leaf, int row, int column, boolean hasFocus) {
            this.field.setColor((Color)value);
            this.field.setBackground(tree.getBackground(row));
            return this.field;
        }

        @Override
        public Object getCellEditorValue() {
            return this.field.getColor();
        }

        @Override
        public Component getSpreadsheetCellRendererComponent(SpreadsheetLayer spreadsheet, Object node, Object value, boolean selected, int row, ITimeSpan span, boolean hasFocus) {
            TreeTable treeTable = spreadsheet.getTreeTable();
            return this.getTreeTableCellRendererComponent(treeTable, node, value, 0, selected, false, false, row, 1, hasFocus);
        }
    }

    private class EnumRenderer
    extends DefaultTreeTableCellRenderer
    implements ISpreadsheetCellRenderer {
        private EnumRenderer() {
        }

        @Override
        public String getText(Object node, Object value) {
            if (value instanceof INamedObject) {
                return ((INamedObject)value).getName();
            }
            return value.toString();
        }

        @Override
        public Component getSpreadsheetCellRendererComponent(SpreadsheetLayer spreadsheet, Object node, Object value, boolean selected, int row, ITimeSpan span, boolean hasFocus) {
            TreeTable treeTable = spreadsheet.getTreeTable();
            return this.getTreeTableCellRendererComponent(treeTable, node, value, 0, selected, false, false, row, 1, hasFocus);
        }
    }

    private class GenericEditor
    extends DefaultSpreadsheetCellEditor {
        private Class[] argTypes;
        private Constructor constructor;
        private Object value;

        public GenericEditor() {
            super(new JTextField());
            this.argTypes = new Class[]{String.class};
            this.getComponent().setName("Table.editor");
        }

        @Override
        public boolean stopCellEditing() {
            String s2 = (String)super.getCellEditorValue();
            if ("".equals(s2)) {
                if (this.constructor.getDeclaringClass() == String.class) {
                    this.value = s2;
                }
                super.stopCellEditing();
            }
            try {
                this.value = this.constructor.newInstance(s2);
            }
            catch (Exception e2) {
                ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
                return false;
            }
            return super.stopCellEditing();
        }

        @Override
        public Component getSpreadsheetCellEditorComponent(SpreadsheetLayer spreadsheetLayer, Object value, int row, ITimeSpan span) {
            this.value = null;
            try {
                Class type = null;
                if (value != null) {
                    type = value.getClass();
                } else {
                    ISpreadsheet spreadsheet = SpreadsheetLayer.this.getGanttChart().getActiveSpreadsheet();
                    Object node = SpreadsheetLayer.this.getTreeTable().getTreePath(row).getLastPathComponent();
                    type = SpreadsheetLayer.this.getModel().getSpreadsheetValueType(spreadsheet, node, span);
                }
                this.constructor = type.getConstructor(this.argTypes);
            }
            catch (Exception e2) {
                return null;
            }
            Component comp = super.getSpreadsheetCellEditorComponent(spreadsheetLayer, value, row, span);
            JTextField textField = (JTextField)this.getComponent();
            textField.setBorder(new LineBorder(Color.BLACK));
            textField.setSelectionStart(Integer.MAX_VALUE);
            textField.setSelectionEnd(Integer.MAX_VALUE);
            return comp;
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }
    }

    private class BooleanEditor
    extends DefaultSpreadsheetCellEditor
    implements ISpreadsheetCellEditor {
        public BooleanEditor() {
            super(new JCheckBox());
            JCheckBox checkBox = (JCheckBox)this.getComponent();
            checkBox.setHorizontalAlignment(0);
        }
    }

    private class NumberEditor
    extends GenericEditor {
        public NumberEditor() {
            ((JTextField)this.getComponent()).setHorizontalAlignment(4);
        }
    }

    private class DateEditor
    extends AbstractCellEditor
    implements ITreeTableCellEditor,
    ISpreadsheetCellEditor {
        private SpinnerDateModel dateModel = new SpinnerDateModel();
        private JSpinner spinner = new JSpinner(this.dateModel);

        private DateEditor() {
        }

        public Component getEditorComponent(Object value) {
            if (!(value instanceof Date)) {
                throw new IllegalArgumentException("value is not of type Date but " + value.getClass().getName());
            }
            this.dateModel.setValue(value);
            return this.spinner;
        }

        @Override
        public Component getTreeTableCellEditorComponent(TreeTable tree, Object value, boolean selected, int row, int column) {
            value = value == null ? Calendar.getInstance().getTime() : ((Date)value).clone();
            return this.getEditorComponent(value);
        }

        @Override
        public Object getCellEditorValue() {
            return this.dateModel.getValue();
        }

        @Override
        public Component getSpreadsheetCellEditorComponent(SpreadsheetLayer spreadsheet, Object value, int row, ITimeSpan span) {
            value = value == null ? Calendar.getInstance().getTime() : ((Date)value).clone();
            return this.getEditorComponent(value);
        }
    }

    private class CalendarEditor
    extends AbstractCellEditor
    implements ITreeTableCellEditor,
    ISpreadsheetCellEditor {
        private SpinnerDateModel dateModel = new SpinnerDateModel();
        private JSpinner spinner = new JSpinner(this.dateModel);
        private Calendar calendar;

        private CalendarEditor() {
        }

        public Component getEditorComponent(Object value) {
            this.calendar = Calendar.getInstance();
            if (value != null) {
                this.calendar = (Calendar)((Calendar)value).clone();
            }
            this.dateModel.setValue(this.calendar.getTime());
            return this.spinner;
        }

        @Override
        public Component getTreeTableCellEditorComponent(TreeTable tree, Object value, boolean selected, int row, int column) {
            return this.getEditorComponent(value);
        }

        @Override
        public Component getSpreadsheetCellEditorComponent(SpreadsheetLayer spreadsheet, Object value, int row, ITimeSpan span) {
            return this.getEditorComponent(value);
        }

        @Override
        public Object getCellEditorValue() {
            Date date = (Date)this.dateModel.getValue();
            this.calendar.setTime(date);
            return this.calendar;
        }
    }

    private class ColorEditor
    extends AbstractCellEditor
    implements ITreeTableCellEditor,
    ISpreadsheetCellEditor {
        private final ColorField label = new ColorField();

        public ColorEditor() {
            this.label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e2) {
                    Color c2 = JColorChooser.showDialog(ColorEditor.this.label, "Choose a Color", ColorEditor.this.label.getBackground());
                    ColorEditor.this.label.setColor(c2);
                    ColorEditor.this.stopCellEditing();
                }
            });
        }

        @Override
        public Component getTreeTableCellEditorComponent(TreeTable tree, Object value, boolean selected, int row, int column) {
            this.label.setColor((Color)value);
            return this.label;
        }

        @Override
        public Object getCellEditorValue() {
            return this.label.getColor();
        }

        @Override
        public Component getSpreadsheetCellEditorComponent(SpreadsheetLayer spreadsheet, Object value, int row, ITimeSpan span) {
            this.label.setColor((Color)value);
            return this.label;
        }
    }

    private class EnumEditor
    extends DefaultSpreadsheetCellEditor
    implements ISpreadsheetCellEditor {
        public EnumEditor() {
            super(new JComboBox(new DefaultComboBoxModel()));
        }

        private void updateComboBox(Object value) {
            Enum e2 = (Enum)value;
            Class cl = null;
            if (e2 != null) {
                cl = e2.getDeclaringClass();
            }
            if (cl == null) {
                ISpreadsheet spreadsheet = SpreadsheetLayer.this.ganttChart.getActiveSpreadsheet();
                cl = spreadsheet.getDefaultValueType();
            }
            E[] obj = cl.getEnumConstants();
            JComboBox box = (JComboBox)this.getComponent();
            box.setRenderer(new NamedObjectListCellRenderer());
            DefaultComboBoxModel spreadsheetModel = (DefaultComboBoxModel)box.getModel();
            spreadsheetModel.removeAllElements();
            for (Object o2 : obj) {
                spreadsheetModel.addElement(o2);
            }
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            this.updateComboBox(value);
            return super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
        }

        @Override
        public Component getSpreadsheetCellEditorComponent(SpreadsheetLayer spreadsheet, Object value, int row, ITimeSpan span) {
            this.updateComboBox(value);
            return super.getSpreadsheetCellEditorComponent(spreadsheet, value, row, span);
        }

        class NamedObjectListCellRenderer
        extends DefaultListCellRenderer {
            NamedObjectListCellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof INamedObject) {
                    label.setText(((INamedObject)value).getName());
                }
                return label;
            }
        }
    }

    class CellEditorRemover
    implements PropertyChangeListener {
        private KeyboardFocusManager focusManager;

        public CellEditorRemover(KeyboardFocusManager fm) {
            this.focusManager = fm;
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if (!SpreadsheetLayer.this.isEditing()) {
                return;
            }
            for (Component c2 = this.focusManager.getPermanentFocusOwner(); c2 != null; c2 = c2.getParent()) {
                if (c2 == SpreadsheetLayer.this.layerContainer) {
                    return;
                }
                if (!(c2 instanceof Window) && (!(c2 instanceof Applet) || c2.getParent() != null)) continue;
                if (c2 != SwingUtilities.getRoot(SpreadsheetLayer.this.layerContainer) || SpreadsheetLayer.this.getCellEditor().stopCellEditing()) break;
                SpreadsheetLayer.this.getCellEditor().cancelCellEditing();
                break;
            }
        }
    }
}

