/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.model.gantt.IRelationship;
import com.dlsc.flexgantt.swing.layer.system.IRelationshipSelectionModel;
import com.dlsc.flexgantt.swing.layer.system.IRelationshipSelectionModelListener;
import com.dlsc.flexgantt.swing.layer.system.RelationshipSelectionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.EventListenerList;

public class DefaultRelationshipSelectionModel
implements IRelationshipSelectionModel {
    private EventListenerList listenerList = new EventListenerList();
    private List<IRelationship> selection = new ArrayList<IRelationship>();

    @Override
    public Collection<IRelationship> getSelection() {
        return new ArrayList<IRelationship>(this.selection);
    }

    @Override
    public void addSelection(Collection<IRelationship> relationships) {
        if (relationships == null) {
            throw new IllegalArgumentException("relationships can not be NULL");
        }
        this.selection.addAll(relationships);
        this.fireValueChanged(new RelationshipSelectionEvent(this, RelationshipSelectionEvent.ID.RELATIONSHIPS_ADDED, relationships));
    }

    @Override
    public void removeSelection(Collection<IRelationship> relationships) {
        if (relationships == null) {
            throw new IllegalArgumentException("relationships can not be NULL");
        }
        this.selection.removeAll(relationships);
        this.fireValueChanged(new RelationshipSelectionEvent(this, RelationshipSelectionEvent.ID.RELATIONSHIPS_REMOVED, relationships));
    }

    @Override
    public void clearSelection() {
        ArrayList<IRelationship> list = new ArrayList<IRelationship>(this.selection);
        this.selection.clear();
        this.fireValueChanged(new RelationshipSelectionEvent(this, RelationshipSelectionEvent.ID.RELATIONSHIPS_REMOVED, list));
    }

    @Override
    public boolean isEmpty() {
        return this.selection.isEmpty();
    }

    @Override
    public boolean isSelected(IRelationship relationship) {
        return this.selection.contains(relationship);
    }

    @Override
    public void addRelationshipSelectionModelListener(IRelationshipSelectionModelListener l2) {
        this.listenerList.add(IRelationshipSelectionModelListener.class, l2);
    }

    @Override
    public void removeRelationshipSelectionModelListener(IRelationshipSelectionModelListener l2) {
        this.listenerList.remove(IRelationshipSelectionModelListener.class, l2);
    }

    protected void fireValueChanged(RelationshipSelectionEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != IRelationshipSelectionModelListener.class) continue;
            ((IRelationshipSelectionModelListener)listeners[i2 + 1]).valueChanged(evt);
        }
    }
}

