/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.swing.layer.system.ActionLayer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.basic.BasicButtonUI;

public class ActionLayerButtonPanel
extends JPanel {
    private float opacity = 0.0f;
    private Border buttonBorder;
    private Paint buttonRolloverPaint = new Color(Color.ORANGE.getRed(), Color.ORANGE.getGreen(), Color.ORANGE.getBlue(), 40);
    private Paint backgroundPaint = Color.WHITE;
    private Color borderColor = Color.GRAY;
    private int buttonColumnsCount = 4;
    private ActionLayer actionLayer;
    private int buttonXGap = 4;
    private int buttonYGap = 4;

    public ActionLayerButtonPanel(ActionLayer layer) {
        if (layer == null) {
            throw new IllegalArgumentException("action layer can not be NULL");
        }
        this.actionLayer = layer;
        this.setOpaque(false);
        this.setBorder(new CompoundBorder(new Border(){
            private final Insets insets = new Insets(4, 4, 4, 4);

            @Override
            public Insets getBorderInsets(Component c2) {
                return this.insets;
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }

            @Override
            public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
                Graphics2D g2d = (Graphics2D)g2.create();
                g2d.setComposite(AlphaComposite.getInstance(3, ActionLayerButtonPanel.this.opacity));
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setPaint(ActionLayerButtonPanel.this.getBackgroundPaint());
                g2d.fillRoundRect(0, 0, width - 1, height - 1, 12, 12);
                g2d.setColor(ActionLayerButtonPanel.this.getBorderColor());
                g2d.drawRoundRect(0, 0, width - 1, height - 1, 12, 12);
            }
        }, BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.setButtonBorder(new CompoundBorder(new Border(){
            private final Insets insets = new Insets(2, 2, 2, 2);

            @Override
            public Insets getBorderInsets(Component c2) {
                return this.insets;
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }

            @Override
            public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
                Graphics2D g2d = (Graphics2D)g2.create();
                g2d.setComposite(AlphaComposite.getInstance(3, ActionLayerButtonPanel.this.opacity));
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                ActionButton button = (ActionButton)c2;
                if (button.isRollover()) {
                    g2d.setPaint(ActionLayerButtonPanel.this.getButtonRolloverPaint());
                    g2d.fillRoundRect(0, 0, width - 1, height - 1, 6, 6);
                }
                g2d.setColor(ActionLayerButtonPanel.this.getBorderColor());
                g2d.drawRoundRect(0, 0, width - 1, height - 1, 6, 6);
            }
        }, BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.addMouseListener(new MouseAdapter(){});
        this.addMouseMotionListener(new MouseAdapter(){});
    }

    public void setButtonXGap(int gap) {
        this.buttonXGap = gap;
    }

    public int getButtonXGap() {
        return this.buttonXGap;
    }

    public void setButtonYGap(int gap) {
        this.buttonYGap = gap;
    }

    public int getButtonYGap() {
        return this.buttonYGap;
    }

    public void setActions(List<Action> actions) {
        this.removeAll();
        this.setLayout(new GridLayout(-1, Math.min(actions.size(), this.getColumns()), this.buttonXGap, this.buttonYGap));
        for (Action a2 : actions) {
            JButton b2 = this.createButton(a2);
            b2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ActionLayerButtonPanel.this.actionLayer.removeActionPanel();
                }
            });
            this.add(b2);
        }
    }

    protected JButton createButton(Action action) {
        ActionButton b2 = new ActionButton(action);
        return b2;
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
        this.repaint();
    }

    @Override
    public void paint(Graphics g2) {
        Graphics2D g2d = (Graphics2D)g2.create();
        Composite comp = g2d.getComposite();
        g2d.setComposite(AlphaComposite.getInstance(3, this.opacity));
        super.paint(g2d);
        g2d.setComposite(comp);
    }

    public Border getButtonBorder() {
        return this.buttonBorder;
    }

    public Paint getButtonRolloverPaint() {
        return this.buttonRolloverPaint;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public int getColumns() {
        return this.buttonColumnsCount;
    }

    public void setButtonBorder(Border border) {
        if (border == null) {
            throw new IllegalArgumentException("border can not be NULL");
        }
        this.buttonBorder = border;
    }

    public void setButtonRolloverPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("paint can not be NULL");
        }
        this.buttonRolloverPaint = paint;
    }

    public void setBackgroundPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("paint can not be NULL");
        }
        this.backgroundPaint = paint;
    }

    public void setBorderColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color can not be NULL");
        }
        this.borderColor = color;
    }

    public void setColumns(int count) {
        if (count < 1) {
            throw new IllegalArgumentException("columnn count can not be smaller than 1 but was " + count);
        }
        this.buttonColumnsCount = count;
    }

    class ActionButton
    extends JButton
    implements MouseListener {
        private boolean rollover;

        public ActionButton(Action a2) {
            super(a2);
            this.setUI(new BasicButtonUI());
            this.setBackground(Color.ORANGE);
            this.setOpaque(false);
            this.setBorder(ActionLayerButtonPanel.this.getButtonBorder());
            this.addMouseListener(this);
        }

        public boolean isRollover() {
            return this.rollover;
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
            this.rollover = true;
            this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            this.rollover = false;
            this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent evt) {
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
        }
    }
}

