/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.swing.ObjectBounds;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.AbstractSystemLayer;
import com.dlsc.flexgantt.swing.layer.system.ActionLayerButtonPanel;
import com.dlsc.flexgantt.swing.layer.system.DefaultActionProvider;
import com.dlsc.flexgantt.swing.layer.system.DragLayer;
import com.dlsc.flexgantt.swing.layer.system.IActionProvider;
import com.dlsc.flexgantt.swing.layer.timeline.ITimelineObjectSelectionListener;
import com.dlsc.flexgantt.swing.layer.timeline.TimelineObjectSelectionEvent;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Action;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;

public class ActionLayer
extends AbstractSystemLayer
implements ITimelineObjectSelectionListener {
    private IActionProvider actionProvider = new DefaultActionProvider();
    private int fadeInDuration = 333;
    private Animator animator;
    private TimelineObjectPath activePath;
    private ActionLayerButtonPanel buttonPanel = new ActionLayerButtonPanel(this);
    private int startDelay = 666;

    public ActionLayer(LayerContainer lc2) {
        super("ActionLayer", lc2);
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                if (!e2.isConsumed() && ActionLayer.this.actionProvider != null && e2.getButton() == 1 && e2.getClickCount() == 1) {
                    ActionLayer.this.checkLocation(e2);
                }
            }

            @Override
            public void mouseExited(MouseEvent evt) {
            }

            @Override
            public void mouseMoved(MouseEvent e2) {
                if (ActionLayer.this.animator != null && ActionLayer.this.animator.isRunning()) {
                    ActionLayer.this.checkValidity(e2);
                }
            }
        };
        lc2.addMouseListener(adapter);
        lc2.addMouseMotionListener(adapter);
    }

    public void setDelay(int delay) {
        this.startDelay = delay;
    }

    public int getDelay() {
        return this.startDelay;
    }

    private void checkLocation(MouseEvent e2) {
        ObjectBounds bounds = this.layerContainer.getObjectBoundsAt(e2);
        if (bounds != null) {
            if (!bounds.getPath().equals(this.activePath)) {
                List<Action> actions;
                this.stopAnimator();
                this.removeActionPanel();
                this.activePath = bounds.getPath();
                DragLayer dl = this.layerContainer.getSystemLayer(DragLayer.class);
                if (this.activePath != null && !dl.isDragging() && (actions = this.actionProvider.getTimelineObjectActions(this.layerContainer, this.activePath)) != null && actions.size() > 0) {
                    e2.consume();
                    this.buttonPanel.setActions(actions);
                    this.layerContainer.add(this.buttonPanel);
                    Rectangle panelBounds = this.calculateGoodBounds(this.buttonPanel, bounds, e2);
                    this.buttonPanel.setBounds(panelBounds);
                    this.buttonPanel.invalidate();
                    this.buttonPanel.validate();
                    this.animator = new Animator(this.fadeInDuration, new TimingTarget(){

                        @Override
                        public void timingEvent(float fraction) {
                            if (ActionLayer.this.buttonPanel != null) {
                                ActionLayer.this.buttonPanel.setOpacity(fraction);
                            }
                        }

                        @Override
                        public void begin() {
                            if (ActionLayer.this.buttonPanel != null) {
                                ActionLayer.this.buttonPanel.setOpacity(0.0f);
                            }
                        }

                        @Override
                        public void end() {
                            if (ActionLayer.this.buttonPanel != null) {
                                ActionLayer.this.buttonPanel.setOpacity(1.0f);
                                ActionLayer.this.layerContainer.scrollRectToVisible(ActionLayer.this.buttonPanel.getBounds());
                            }
                        }

                        @Override
                        public void repeat() {
                        }
                    });
                    this.animator.setStartDelay(this.startDelay);
                    this.animator.start();
                }
            }
        } else {
            this.stopAnimator();
            this.removeActionPanel();
        }
    }

    private void checkValidity(MouseEvent e2) {
        ObjectBounds bounds = this.layerContainer.getObjectBoundsAt(e2);
        if (bounds != null && bounds.getPath().equals(this.activePath)) {
            return;
        }
        this.stopAnimator();
        this.removeActionPanel();
    }

    public void setActionProvider(IActionProvider actionProvider) {
        this.actionProvider = actionProvider;
    }

    public IActionProvider getActionProvider() {
        return this.actionProvider;
    }

    public void setFadeInDuration(int duration) {
        if (duration < 0) {
            throw new IllegalArgumentException("fade in delay can not be smaller than 0 but was " + duration);
        }
        this.fadeInDuration = duration;
    }

    public int getFadeInDuration() {
        return this.fadeInDuration;
    }

    @Override
    public void valueChanged(TimelineObjectSelectionEvent evt) {
    }

    public TimelineObjectPath getActiveTimelineObjectPath() {
        return this.activePath;
    }

    private Rectangle calculateGoodBounds(ActionLayerButtonPanel panel, Rectangle bounds, MouseEvent e2) {
        Dimension dim = this.buttonPanel.getPreferredSize();
        int x2 = Math.max(0, Math.min(e2.getX() - 10, this.layerContainer.getWidth() - dim.width));
        int y2 = Math.min(bounds.y - dim.height, this.layerContainer.getHeight() - dim.height) - 2;
        int w2 = dim.width;
        int h2 = dim.height;
        Rectangle rect = new Rectangle(x2, y2, w2, h2);
        if (rect.x + rect.width > this.layerContainer.getWidth()) {
            rect.x -= rect.width;
        }
        if (y2 < 0) {
            rect.y = bounds.y + bounds.height + 2;
        }
        return rect;
    }

    private void stopAnimator() {
        if (this.animator != null && this.animator.isRunning()) {
            this.animator.stop();
        }
    }

    public void removeActionPanel() {
        if (this.buttonPanel != null) {
            this.layerContainer.remove(this.buttonPanel);
            this.buttonPanel.setOpacity(0.0f);
            this.activePath = null;
        }
    }

    public void setButtonPanel(ActionLayerButtonPanel panel) {
        if (this.buttonPanel == null) {
            throw new IllegalArgumentException("action panel can not be NULL");
        }
        this.buttonPanel = panel;
    }

    public ActionLayerButtonPanel getButtonPanel() {
        return this.buttonPanel;
    }
}

