/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer;

import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.gantt.IRelationship;
import com.dlsc.flexgantt.model.gantt.ISpreadsheet;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.action.gantt.RedoActionLabeled;
import com.dlsc.flexgantt.swing.action.gantt.UndoActionLabeled;
import com.dlsc.flexgantt.swing.action.layer.AddHighlightedTimelineObjectsAction;
import com.dlsc.flexgantt.swing.action.layer.AddPinnedPopupAction;
import com.dlsc.flexgantt.swing.action.layer.ClearHighlightedTimelineObjectsAction;
import com.dlsc.flexgantt.swing.action.layer.ClearPinnedPopupsAction;
import com.dlsc.flexgantt.swing.action.layer.CreateBookmarkAction;
import com.dlsc.flexgantt.swing.action.layer.DeleteRelationshipAction;
import com.dlsc.flexgantt.swing.action.layer.DeleteTimelineObjectAction;
import com.dlsc.flexgantt.swing.action.layer.LassoModeAction;
import com.dlsc.flexgantt.swing.action.layer.RemoveHighlightedTimelineObjectsAction;
import com.dlsc.flexgantt.swing.action.layer.RemovePinnedPopupAction;
import com.dlsc.flexgantt.swing.layer.ILayerContainerMenuProvider;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.LassoLayer;
import com.dlsc.flexgantt.swing.util.MenuCleaner;
import com.dlsc.flexgantt.util.Messages;
import java.awt.event.MouseEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.tree.TreePath;

public class DefaultLayerContainerMenuProvider
extends JPopupMenu
implements ILayerContainerMenuProvider {
    public DefaultLayerContainerMenuProvider() {
        super(Messages.getString("DefaultLayerContainerMenuProvider.MENU_TITLE"));
    }

    @Override
    public JPopupMenu getPopupMenu(LayerContainer lc2, MouseEvent e2, long timePoint, TreePath treePath, TimelineObjectPath[] paths, IRelationship[] relationships) {
        this.removeAll();
        this.add(new AddPinnedPopupAction(lc2));
        this.add(new RemovePinnedPopupAction(lc2));
        this.add(new ClearPinnedPopupsAction(lc2));
        this.add(new JSeparator());
        this.add(new AddHighlightedTimelineObjectsAction(lc2));
        this.add(new RemoveHighlightedTimelineObjectsAction(lc2));
        this.add(new ClearHighlightedTimelineObjectsAction(lc2));
        this.add(new JSeparator());
        this.add(new CreateBookmarkAction(lc2));
        JMenu selectionMode = new JMenu(Messages.getString("DefaultLayerContainerMenuProvider.MENU_LASSO_MODE"));
        selectionMode.setIcon(IconRegistry.getIcon(IconId.LASSO));
        JCheckBoxMenuItem selectObjects = new JCheckBoxMenuItem(new LassoModeAction(lc2, LassoLayer.LassoMode.SELECT_TIMELINE_OBJECTS));
        JCheckBoxMenuItem selectSpans = new JCheckBoxMenuItem(new LassoModeAction(lc2, LassoLayer.LassoMode.SELECT_TIME_SPANS));
        JCheckBoxMenuItem createTimelineObjects = new JCheckBoxMenuItem(new LassoModeAction(lc2, LassoLayer.LassoMode.CREATE_TIMELINE_OBJECTS));
        LassoLayer lassoLayer = lc2.getSystemLayer(LassoLayer.class);
        LassoLayer.LassoMode lassoMode = lassoLayer.getLassoMode();
        if (lassoLayer.isSupportedLassoMode(LassoLayer.LassoMode.SELECT_TIMELINE_OBJECTS)) {
            selectionMode.add(selectObjects);
        }
        if (lassoLayer.isSupportedLassoMode(LassoLayer.LassoMode.SELECT_TIME_SPANS)) {
            selectionMode.add(selectSpans);
        }
        if (lassoLayer.isSupportedLassoMode(LassoLayer.LassoMode.CREATE_TIMELINE_OBJECTS)) {
            selectionMode.add(createTimelineObjects);
        }
        switch (lassoMode) {
            case SELECT_TIME_SPANS: {
                selectSpans.setSelected(true);
                break;
            }
            case SELECT_TIMELINE_OBJECTS: {
                selectObjects.setSelected(true);
                break;
            }
            case CREATE_TIMELINE_OBJECTS: {
                createTimelineObjects.setSelected(true);
            }
        }
        ButtonGroup selectGroup = new ButtonGroup();
        selectGroup.add(selectObjects);
        selectGroup.add(selectSpans);
        selectGroup.add(createTimelineObjects);
        this.add(selectionMode);
        JMenuItem[] customItems = this.createMenuExtensions(false);
        if (customItems != null) {
            this.add(new JSeparator());
            for (JMenuItem item : customItems) {
                this.add(item);
            }
        }
        this.add(new JSeparator());
        this.add(new UndoActionLabeled<AbstractGanttChart>(lc2.getGanttChart()));
        this.add(new RedoActionLabeled<AbstractGanttChart>(lc2.getGanttChart()));
        this.add(new JSeparator());
        if (paths != null && paths.length > 0 || relationships == null || relationships.length == 0) {
            this.add(new DeleteTimelineObjectAction(lc2));
        }
        if (relationships != null && relationships.length > 0) {
            this.add(new DeleteRelationshipAction(lc2));
        }
        MenuCleaner.clean(this);
        return this;
    }

    protected JMenuItem[] createMenuExtensions(boolean spreadsheet) {
        return null;
    }

    @Override
    public JPopupMenu getPopupMenu(LayerContainer lc2, MouseEvent e2, ITimeSpan timeSpan, TreePath treePath, ISpreadsheet spreadsheet) {
        return null;
    }
}

