/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.policy.layer;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.dateline.IDatelineModel;
import com.dlsc.flexgantt.model.dateline.IGranularity;
import com.dlsc.flexgantt.model.dateline.SimpleGranularity;
import com.dlsc.flexgantt.policy.layer.AbstractGridPolicy;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimpleGranularityGridPolicy
extends AbstractGridPolicy<SimpleGranularity> {
    private static final Logger LOGGER = Logger.getLogger(SimpleGranularityGridPolicy.class.getName());

    public SimpleGranularityGridPolicy(boolean adjustingStartTimes, boolean adjustingEndTimes, SimpleGranularity ... granularities) {
        super(adjustingStartTimes, adjustingEndTimes, (IGranularity[])granularities);
    }

    public SimpleGranularityGridPolicy(SimpleGranularity ... granularities) {
        this(true, true, granularities);
    }

    public SimpleGranularityGridPolicy() {
        this(SimpleGranularity.values());
    }

    @Override
    public ITimeSpan getGridAdjustedTimeSpan(SimpleGranularity sg, ITimeSpan timeSpan, IDatelineModel<SimpleGranularity> model, boolean autoGrid) {
        long s2 = this.getGridAdjustedStartTime(sg, timeSpan.getStartTime(), model, autoGrid);
        long e2 = this.getGridAdjustedEndTime(sg, timeSpan.getEndTime(), model, autoGrid);
        return new TimeSpan(s2, e2);
    }

    @Override
    public long getGridAdjustedStartTime(SimpleGranularity sg, long startTime, IDatelineModel<SimpleGranularity> model, boolean autoGrid) {
        if (this.isAdjustingStartTimes()) {
            return this.getGridAdjustedTime(sg, startTime, model, autoGrid);
        }
        return startTime;
    }

    @Override
    public long getGridAdjustedEndTime(SimpleGranularity sg, long endTime, IDatelineModel<SimpleGranularity> model, boolean autoGrid) {
        if (this.isAdjustingEndTimes()) {
            return this.getGridAdjustedTime(sg, endTime, model, autoGrid);
        }
        return endTime;
    }

    private long getGridAdjustedTime(SimpleGranularity sg, long time, IDatelineModel<SimpleGranularity> model, boolean autoGrid) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("time = " + time);
        }
        if (autoGrid) {
            sg = model.getGranularity();
        }
        if (sg == null) {
            return time;
        }
        long result = sg.adjust(time);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("adjusted = " + time);
        }
        return result;
    }
}

