/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.model.gantt;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.gantt.ISpreadsheetValuesList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class SpreadsheetValuesList
implements ISpreadsheetValuesList {
    private List<Entry> list = new LinkedList<Entry>();

    @Override
    public int getSize() {
        return this.list.size();
    }

    @Override
    public Object getValue(ITimeSpan span) {
        for (Entry entry : this.list) {
            if (!entry.equals(span)) continue;
            Object value = entry.getValue();
            return value;
        }
        return null;
    }

    @Override
    public void setValue(Object value, ITimeSpan span) {
        for (Entry entry : this.list) {
            if (!entry.equals(span)) continue;
            entry.setValue(value);
            return;
        }
        this.list.add(new Entry(span, value));
        Collections.sort(this.list);
    }

    public void clearValues() {
        this.list.clear();
    }

    private class Entry
    extends TimeSpan {
        private Object entryValue;

        public Entry(ITimeSpan span, Object value) {
            super(span);
            this.setValue(value);
        }

        public void setValue(Object value) {
            this.entryValue = value;
        }

        public Object getValue() {
            return this.entryValue;
        }
    }
}

