/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.model.gantt;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.gantt.DefaultTimelineObject;
import com.dlsc.flexgantt.model.gantt.ICapacityObject;
import com.dlsc.flexgantt.util.Messages;

public class DefaultCapacityObject<T>
extends DefaultTimelineObject<T>
implements ICapacityObject {
    private double capacityUsed;
    private boolean capacityChangeable = true;

    public DefaultCapacityObject(String name, ITimeSpan timeSpan, double capacityUsed) {
        super(name, timeSpan);
        this.capacityUsed = capacityUsed;
        this.setDragActions(0);
        this.setDurationChangeable(false);
        this.setStartTimeChangeable(false);
    }

    public DefaultCapacityObject(String name, ITimeSpan timeSpan) {
        this(name, timeSpan, 0.0);
    }

    public DefaultCapacityObject(String name, double capacityUsed) {
        this(name, TimeSpan.UNDEFINED, capacityUsed);
    }

    public DefaultCapacityObject(String name) {
        this(name, 0.0);
    }

    public DefaultCapacityObject(ITimeSpan timeSpan, double capacityUsed) {
        this(Messages.getString("DefaultCapacityObject.UNTITLED"), timeSpan, capacityUsed);
    }

    public DefaultCapacityObject(ITimeSpan timeSpan) {
        this(timeSpan, 0.0);
    }

    public DefaultCapacityObject(double capacityUsed) {
        this(TimeSpan.UNDEFINED, capacityUsed);
    }

    public DefaultCapacityObject() {
        this(0.0);
    }

    @Override
    public double getCapacityUsed() {
        return this.capacityUsed;
    }

    @Override
    public void setCapacityUsed(double c2) {
        this.capacityUsed = c2;
    }

    public void setCapacityChangeable(boolean changeable) {
        this.capacityChangeable = changeable;
    }

    @Override
    public boolean isCapacityChangeable() {
        return this.capacityChangeable;
    }
}

