/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.model.gantt;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.gantt.DefaultTimelineObject;
import com.dlsc.flexgantt.model.gantt.IActivityObject;

public class DefaultActivityObject<T>
extends DefaultTimelineObject<T>
implements IActivityObject {
    private double percentageComplete;
    private boolean percentageChangeable = true;

    public DefaultActivityObject(String name, ITimeSpan timeSpan, double percentageComplete) {
        super(name, timeSpan);
        this.setPercentageComplete(percentageComplete);
    }

    public DefaultActivityObject(String name, ITimeSpan timeSpan) {
        super(name, timeSpan);
    }

    public DefaultActivityObject(String name, double percentageComplete) {
        super(name);
        this.percentageComplete = percentageComplete;
    }

    public DefaultActivityObject(String name) {
        super(name);
    }

    public DefaultActivityObject(ITimeSpan timeSpan, double percentageComplete) {
        super(timeSpan);
        this.setPercentageComplete(percentageComplete);
    }

    public DefaultActivityObject(ITimeSpan timeSpan) {
        super(timeSpan);
    }

    public DefaultActivityObject(double percentageComplete) {
        this.percentageComplete = percentageComplete;
    }

    public DefaultActivityObject() {
    }

    @Override
    public double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public void setPercentageComplete(double p2) {
        if (p2 < 0.0) {
            throw new IllegalArgumentException("percentage complete can not be smaller than 0 but was " + p2);
        }
        if (p2 > 100.0) {
            throw new IllegalArgumentException("percentage complete can not be larger than 100 but was " + p2);
        }
        this.percentageComplete = p2;
    }

    public void setPercentageChangeable(boolean changeable) {
        this.percentageChangeable = changeable;
    }

    @Override
    public boolean isPercentageChangeable() {
        return this.percentageChangeable;
    }
}

