/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.command.treetable;

import com.dlsc.flexgantt.command.AbstractCommand;
import com.dlsc.flexgantt.command.CommandException;
import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.model.treetable.DefaultMutableTreeTableNode;
import com.dlsc.flexgantt.model.treetable.DefaultTreeTableModel;
import com.dlsc.flexgantt.model.treetable.IMutableTreeTableNode;
import com.dlsc.flexgantt.util.Messages;

public class DefaultDeleteNodeCommand
extends AbstractCommand {
    private IMutableTreeTableNode childNode;
    private IMutableTreeTableNode parentNode;
    private DefaultTreeTableModel model;
    private int childIndex;

    public DefaultDeleteNodeCommand(IMutableTreeTableNode child, DefaultTreeTableModel model) {
        super(Messages.getString("DefaultDeleteNodeCommand.NAME"));
        if (child == null) {
            throw new IllegalArgumentException("child can not be NULL");
        }
        if (model == null) {
            throw new IllegalArgumentException("model can not be NULL");
        }
        this.childNode = child;
        this.model = model;
    }

    @Override
    public void executeCommand(IProgressMonitor monitor) throws CommandException {
        this.parentNode = (DefaultMutableTreeTableNode)this.childNode.getParent();
        this.childIndex = this.parentNode.getIndex(this.childNode);
        this.parentNode.remove(this.childNode);
        this.model.nodesWereRemoved(this.parentNode, new int[]{this.childIndex}, new Object[]{this.childNode});
    }

    @Override
    public void undoCommand(IProgressMonitor monitor) throws CommandException {
        this.parentNode.insert(this.childNode, this.childIndex);
        this.model.nodesWereInserted(this.parentNode, new int[]{this.childIndex});
    }

    public int getChildIndex() {
        return this.childIndex;
    }

    public IMutableTreeTableNode getChildNode() {
        return this.childNode;
    }

    public DefaultTreeTableModel getModel() {
        return this.model;
    }

    public IMutableTreeTableNode getParentNode() {
        return this.parentNode;
    }
}

