/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.command.treetable;

import com.dlsc.flexgantt.command.AbstractCommand;
import com.dlsc.flexgantt.command.CommandException;
import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartNode;
import com.dlsc.flexgantt.model.treetable.DefaultTreeTableModel;
import com.dlsc.flexgantt.model.treetable.IMutableTreeTableNode;
import com.dlsc.flexgantt.model.treetable.ITreeTableNode;
import com.dlsc.flexgantt.util.Messages;

public class DefaultCreateNodeCommand
extends AbstractCommand {
    private IMutableTreeTableNode childNode;
    private IMutableTreeTableNode parentNode;
    private DefaultTreeTableModel model;
    private Object key;
    private Object[] values;

    public DefaultCreateNodeCommand(IMutableTreeTableNode parent, DefaultTreeTableModel model, Object key, Object[] values) {
        super(Messages.getString("DefaultCreateNodeCommand.NAME"));
        if (parent == null) {
            throw new IllegalArgumentException("parent can not be NULL");
        }
        if (model == null) {
            throw new IllegalArgumentException("model can not be NULL");
        }
        this.parentNode = parent;
        this.model = model;
        this.key = key;
        this.values = values;
    }

    @Override
    public void executeCommand(IProgressMonitor monitor) throws CommandException {
        if (this.childNode == null) {
            this.childNode = this.createNewNode();
            this.fillNode(this.childNode);
        }
        if (this.childNode.getParent() != this.parentNode) {
            int index = this.parentNode.getChildCount();
            this.parentNode.insert(this.childNode, index);
            this.model.nodesWereInserted(this.parentNode, new int[]{index});
        }
    }

    @Override
    public void undoCommand(IProgressMonitor monitor) throws CommandException {
        int index = this.parentNode.getIndex(this.childNode);
        this.parentNode.remove(this.childNode);
        this.model.nodesWereRemoved(this.parentNode, new int[]{index}, new Object[]{this.childNode});
    }

    protected IMutableTreeTableNode createNewNode() {
        return new DefaultGanttChartNode(true);
    }

    public IMutableTreeTableNode getParentNode() {
        return this.parentNode;
    }

    public DefaultTreeTableModel getModel() {
        return this.model;
    }

    protected void fillNode(ITreeTableNode node) {
        if (this.key != null) {
            node.setKey(this.key);
        }
        if (this.values != null) {
            for (int i2 = 0; i2 < this.values.length; ++i2) {
                node.setColumnValue(this.values[i2], i2);
            }
        }
    }

    public IMutableTreeTableNode getChildNode() {
        return this.childNode;
    }

    public Object getKey() {
        return this.key;
    }

    public Object[] getValues() {
        return this.values;
    }
}

