/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.command.layer;

import com.dlsc.flexgantt.command.AbstractCommand;
import com.dlsc.flexgantt.command.CommandException;
import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.gantt.IGanttChartNode;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.model.gantt.IRelationship;
import com.dlsc.flexgantt.model.gantt.ITimelineObject;
import com.dlsc.flexgantt.util.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class DefaultDeleteTimelineObjectCommand
extends AbstractCommand {
    private IGanttChartNode node;
    private ILayer layer;
    private ITimelineObject timelineObject;
    private DefaultGanttChartModel model;
    private Collection<IRelationship> relationships;

    public DefaultDeleteTimelineObjectCommand(IGanttChartNode node, ILayer layer, ITimelineObject object, DefaultGanttChartModel model) {
        super(Messages.getString("DefaultDeleteTimelineObjectCommand.NAME"));
        if (node == null) {
            throw new IllegalArgumentException("node can not be NULL");
        }
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be NULL");
        }
        if (object == null) {
            throw new IllegalArgumentException("timeline object not be NULL");
        }
        if (model == null) {
            throw new IllegalArgumentException("model can not be NULL");
        }
        this.node = node;
        this.layer = layer;
        this.timelineObject = object;
        this.model = model;
    }

    @Override
    public void executeCommand(IProgressMonitor monitor) throws CommandException {
        this.relationships = new LinkedList<IRelationship>();
        Iterator<IRelationship<ITimelineObject>> iter = this.model.getRelationships(this.timelineObject);
        if (iter != null) {
            while (iter.hasNext()) {
                this.relationships.add(iter.next());
            }
        }
        if (this.relationships != null) {
            this.model.removeRelationships(new ArrayList<IRelationship>(this.relationships));
        }
        this.model.removeTimelineObject(this.node, this.layer, this.timelineObject);
    }

    @Override
    public void undoCommand(IProgressMonitor monitor) throws CommandException {
        this.model.addTimelineObject(this.node, this.layer, this.timelineObject);
        if (this.relationships != null) {
            this.model.addRelationships(this.relationships);
        }
    }

    public ITimelineObject getTimelineObject() {
        return this.timelineObject;
    }

    public DefaultGanttChartModel getModel() {
        return this.model;
    }

    public ILayer getLayer() {
        return this.layer;
    }

    public IGanttChartNode getNode() {
        return this.node;
    }
}

