/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.command.layer;

import com.dlsc.flexgantt.command.AbstractCommand;
import com.dlsc.flexgantt.command.CommandException;
import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.gantt.IRelationship;

public class DefaultDeleteRelationshipCommand
extends AbstractCommand {
    private IRelationship relationship;
    private DefaultGanttChartModel model;

    public DefaultDeleteRelationshipCommand(IRelationship relationship, DefaultGanttChartModel model) {
        super("Delete Relationship");
        if (relationship == null) {
            throw new IllegalArgumentException("relationship can not be NULL");
        }
        if (model == null) {
            throw new IllegalArgumentException("Gantt chart model can not be NULL");
        }
        this.relationship = relationship;
        this.model = model;
    }

    @Override
    public void executeCommand(IProgressMonitor monitor) throws CommandException {
        this.model.removeRelationship(this.relationship);
    }

    @Override
    public void undoCommand(IProgressMonitor monitor) throws CommandException {
        this.model.addRelationship(this.relationship);
    }

    public IRelationship getRelationship() {
        return this.relationship;
    }

    public DefaultGanttChartModel getModel() {
        return this.model;
    }
}

