/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.command.layer;

import com.dlsc.flexgantt.command.AbstractCommand;
import com.dlsc.flexgantt.command.CommandException;
import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.gantt.DefaultRelationship;
import com.dlsc.flexgantt.model.gantt.IRelationship;
import com.dlsc.flexgantt.model.gantt.RelationshipType;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.util.Messages;

public class DefaultCreateRelationshipCommand
extends AbstractCommand {
    private IRelationship relationship;
    private RelationshipType type;
    private TimelineObjectPath sourcePath;
    private TimelineObjectPath targetPath;
    private DefaultGanttChartModel model;

    public DefaultCreateRelationshipCommand(TimelineObjectPath sourcePath, TimelineObjectPath targetPath, RelationshipType type, DefaultGanttChartModel model) {
        super(Messages.getString("DefaulCreateRelationshipCommand.NAME"));
        if (sourcePath == null) {
            throw new IllegalArgumentException("source path can not be NULL");
        }
        if (targetPath == null) {
            throw new IllegalArgumentException("target path can not be NULL");
        }
        if (model == null) {
            throw new IllegalArgumentException("model can not be NULL");
        }
        if (type == null) {
            throw new IllegalArgumentException("type can not be NULL");
        }
        this.model = model;
        this.sourcePath = sourcePath;
        this.targetPath = targetPath;
        this.type = type;
    }

    @Override
    public void executeCommand(IProgressMonitor monitor) throws CommandException {
        if (this.relationship == null) {
            this.relationship = this.createRelationship(this.sourcePath, this.targetPath);
        }
        this.model.addRelationship(this.relationship);
    }

    @Override
    public void undoCommand(IProgressMonitor monitor) throws CommandException {
        this.model.removeRelationship(this.relationship);
    }

    public DefaultGanttChartModel getModel() {
        return this.model;
    }

    public IRelationship getRelationship() {
        return this.relationship;
    }

    public RelationshipType getRelationshipType() {
        return this.type;
    }

    public TimelineObjectPath getSourcePath() {
        return this.sourcePath;
    }

    public TimelineObjectPath getTargetPath() {
        return this.targetPath;
    }

    protected IRelationship createRelationship(TimelineObjectPath sourcePath, TimelineObjectPath targetPath) {
        return new DefaultRelationship(sourcePath, targetPath, this.type);
    }
}

