/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.emirates.swing.session;

import com.dlsc.emirates.swing.AircraftGanttChart;
import com.dlsc.emirates.swing.session.ColumnState;
import com.dlsc.emirates.swing.session.EmiratesGanttChartState;
import com.dlsc.flexgantt.model.dateline.DatelineModelException;
import com.dlsc.flexgantt.model.treetable.IColumnModel;
import com.dlsc.flexgantt.model.treetable.KeyColumn;
import com.dlsc.flexgantt.model.treetable.TreeTableColumn;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import org.jdesktop.application.session.PropertySupport;

public class EmiratesGanttChartPropertySupport
implements PropertySupport {
    @Override
    public Object getSessionState(Component c2) {
        AircraftGanttChart gc2 = (AircraftGanttChart)c2;
        EmiratesGanttChartState s2 = new EmiratesGanttChartState();
        s2.setKeyColumnPosition(gc2.getKeyColumnPosition());
        s2.setDividerLocation(gc2.getVerticalSplitterLocation());
        s2.setGranularity(gc2.getDateline().getGranularity());
        s2.setStartTime(gc2.getDateline().getVisibleTimeSpan().getStartTime());
        s2.setZoom(gc2.getDatelineModel().getZoom());
        s2.setSplit(gc2.isSecondaryVisible());
        s2.setGridLineMode(gc2.getGridLineMode());
        ArrayList<ColumnState> stateList = new ArrayList<ColumnState>();
        for (int i2 = 0; i2 < gc2.getColumnCount(); ++i2) {
            TreeTableColumn col = gc2.getColumn(i2);
            ColumnState colState = this.createColumnState(col, i2);
            stateList.add(colState);
        }
        boolean foundKeyColumn = false;
        for (TreeTableColumn col : gc2.getAvailableColumns()) {
            ColumnState colState = this.createColumnState(col, -1);
            colState.setVisible(false);
            stateList.add(colState);
            if (col != gc2.getKeyColumn()) continue;
            foundKeyColumn = true;
        }
        if (!foundKeyColumn) {
            ColumnState colState = this.createColumnState(gc2.getKeyColumn(), -1);
            stateList.add(colState);
        }
        s2.setColumnStates(stateList);
        return s2;
    }

    private ColumnState createColumnState(TreeTableColumn<?> col, int viewIndex) {
        ColumnState colState = new ColumnState();
        colState.setWidth(col.getWidth());
        colState.setModelIndex(col.getModelIndex());
        colState.setViewIndex(viewIndex);
        return colState;
    }

    @Override
    public void setSessionState(Component c2, Object state) {
        AircraftGanttChart gc2 = (AircraftGanttChart)c2;
        EmiratesGanttChartState s2 = (EmiratesGanttChartState)state;
        gc2.setKeyColumnPosition(s2.getKeyColumnPosition());
        gc2.setVerticalSplitterLocation(s2.getDividerLocation());
        gc2.getDateline().setGranularity(s2.getGranularity());
        gc2.getDateline().showTime(s2.getStartTime(), false);
        gc2.setSecondaryVisible(s2.isSplit());
        gc2.setGridLineMode(s2.getGridLineMode());
        try {
            gc2.getDatelineModel().setZoom(s2.getZoom());
        }
        catch (DatelineModelException datelineModelException) {
            // empty catch block
        }
        List<ColumnState> stateList = s2.getColumnStates();
        if (stateList != null) {
            IColumnModel columnModel = gc2.getColumnModel();
            block2: for (ColumnState cs : stateList) {
                int modelIndex = cs.getModelIndex();
                int viewIndex = cs.getViewIndex();
                if (modelIndex == -1) {
                    KeyColumn keyColumn = columnModel.getKeyColumn();
                    if (keyColumn == null) continue;
                    keyColumn.setWidth(cs.getWidth());
                    if (cs.isVisible()) continue;
                    columnModel.setKeyColumn(null);
                    gc2.addAvailableColumn(keyColumn);
                    continue;
                }
                for (int i2 = 0; i2 < columnModel.getColumnCount(); ++i2) {
                    TreeTableColumn modelColumn = columnModel.getColumn(i2);
                    if (modelColumn.getModelIndex() != modelIndex) continue;
                    modelColumn.setWidth(cs.getWidth());
                    if (cs.isVisible()) {
                        columnModel.moveColumn(i2, viewIndex);
                        continue block2;
                    }
                    gc2.addAvailableColumn(modelColumn);
                    columnModel.removeColumn(modelColumn);
                    continue block2;
                }
            }
        }
    }
}

