/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.emirates.swing.hud;

import com.dlsc.emirates.model.FlightTimelineObject;
import com.dlsc.emirates.swing.AbstractEmiratesGanttChart;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.swing.TimelineObjectPathMessage;
import com.dlsc.flexgantt.swing.layer.timeline.ITimelineObjectSelectionModel;
import com.jtechdev.macwidgets.HudWindow;
import com.jtechdev.macwidgets.plaf.HudButtonUI;
import com.jtechdev.macwidgets.plaf.HudLabelUI;
import com.jtechdev.macwidgets.plaf.HudTextFieldUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import net.miginfocom.swing.MigLayout;

public class FindHUD
extends HudWindow
implements CaretListener {
    private JTextField textField;
    private AbstractEmiratesGanttChart gc;
    private JButton previous;
    private JButton next;
    private JLabel hitsLabel;
    private JLabel currentLabel;
    private List<TimelineObjectPath<FlightTimelineObject>> flightsByFlightNo;
    private int current;

    public FindHUD(AbstractEmiratesGanttChart gc2) {
        super("Find", gc2 != null ? (JFrame)SwingUtilities.getWindowAncestor(gc2) : null);
        this.gc = gc2;
        this.getJDialog().setLocationRelativeTo(gc2);
        this.textField = new JTextField(30);
        this.textField.setUI(new HudTextFieldUI());
        this.textField.addCaretListener(this);
        this.getContentPane().setLayout(new MigLayout("", "[][grow][][]", "[]20[]"));
        JLabel findLabel = new JLabel("Flight No.:");
        findLabel.setUI(new HudLabelUI());
        this.getContentPane().add(findLabel);
        this.getContentPane().add((Component)this.textField, "spanx 3, wrap");
        this.hitsLabel = new JLabel("0 flights found so far");
        this.hitsLabel.setUI(new HudLabelUI());
        this.previous = new JButton("Previous");
        this.previous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FindHUD.this.showPrevious();
            }
        });
        this.next = new JButton("Next");
        this.next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FindHUD.this.showNext();
            }
        });
        this.previous.setUI(new HudButtonUI());
        this.next.setUI(new HudButtonUI());
        this.currentLabel = new JLabel(" ");
        this.currentLabel.setUI(new HudLabelUI());
        this.getContentPane().add((Component)this.hitsLabel, "skip 1");
        this.getContentPane().add((Component)this.currentLabel, "alignx right, spanx 2, wrap");
        this.getContentPane().add((Component)this.previous, "skip 2, alignx right");
        this.getContentPane().add((Component)this.next, "wrap");
        this.getJDialog().pack();
    }

    protected void showNext() {
        ++this.current;
        if (this.current >= this.flightsByFlightNo.size()) {
            this.current = 0;
        }
        this.updateCurrentLabel();
        this.showCurrentTimelineObject();
    }

    protected void showPrevious() {
        --this.current;
        if (this.current < 0) {
            this.current = this.flightsByFlightNo.size() - 1;
        }
        this.updateCurrentLabel();
        this.showCurrentTimelineObject();
    }

    private void updateCurrentLabel() {
        this.currentLabel.setText("Current result: " + (this.current + 1));
    }

    @Override
    public void caretUpdate(CaretEvent evt) {
        String findText = this.textField.getText().trim();
        if (findText.equals("")) {
            findText = null;
        }
        this.gc.setSearchTerm(findText);
        if (findText != null) {
            this.flightsByFlightNo = this.gc.getModelFactory().getFlightsByFlightNo(findText);
            if (this.flightsByFlightNo != null && this.flightsByFlightNo.size() > 0) {
                this.current = 0;
                this.updateCurrentLabel();
                this.showCurrentTimelineObject();
            } else {
                this.hitsLabel.setText("0 flights found.");
            }
        }
    }

    private void showCurrentTimelineObject() {
        this.hitsLabel.setText(this.flightsByFlightNo.size() + " flights found.");
        TimelineObjectPath<FlightTimelineObject> path = this.flightsByFlightNo.get(this.current);
        ITimelineObjectSelectionModel model = this.gc.getPrimaryLayerContainer().getSelectionModel(path.getLayer());
        model.clearSelection();
        model.addSelection(path);
        TimelineObjectPathMessage msg = new TimelineObjectPathMessage("Find Result", path);
        this.gc.showMessageContext(msg);
    }
}

