/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.emirates.swing;

import com.dlsc.emirates.swing.AbstractContentPanel;
import com.dlsc.emirates.swing.BackdropPanel;
import com.dlsc.emirates.swing.View;
import com.dlsc.emirates.swing.Workbench;
import com.dlsc.flexgantt.swing.StatusBar;
import com.dlsc.flexgantt.swing.util.DropShadowBorder;
import de.centigrade.bizlaf.BizLafControl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.MattePainter;

public class IntroPage
extends AbstractContentPanel {
    private JLabel taskNameLabel;
    private JProgressBar progressBar;
    private JLabel progressLabel;
    private BackdropPanel backdropPanel;

    public IntroPage(Workbench workbench) {
        super(workbench, new View("Title", View.Type.TITLE, "Welcome Page", "DLSC Software & Consulting GmbH"));
    }

    @Override
    protected JComponent createContent() {
        this.backdropPanel = new BackdropPanel();
        this.backdropPanel.setLayout(new MigLayout("insets 0 40 40 0", "[]", "[grow]"));
        this.backdropPanel.add((Component)this.createLeftContent(), "grow");
        return this.backdropPanel;
    }

    private JComponent createLeftContent() {
        JXPanel panel = new JXPanel(){

            @Override
            protected void paintComponent(Graphics g2) {
                super.paintComponent(g2);
                Graphics2D g2d = (Graphics2D)g2.create();
                int y2 = this.getHeight() - 120;
                g2d.setColor(new Color(255, 255, 255, 100));
                g2d.drawLine(20, y2, this.getWidth() - 20, y2);
                g2d.dispose();
            }
        };
        panel.setOpaque(false);
        panel.setBackgroundPainter(new MattePainter(new GradientPaint(0.0f, 140.0f, Color.WHITE, 0.0f, 700.0f, new Color(240, 240, 240, 200))));
        panel.setLayout(new MigLayout("insets 0 0 0 0", "[]", "[]60[][]50[grow]"));
        JLabel dlscLogo = new JLabel(new ImageIcon(IntroPage.class.getResource("logo-dlsc.png")));
        dlscLogo.setCursor(Cursor.getPredefinedCursor(12));
        dlscLogo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                try {
                    Desktop.getDesktop().browse(new URI("http://www.dlsc.com"));
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(IntroPage.this, "Unable to open DLSC website: " + ex.getMessage(), "Error", 0);
                }
            }
        });
        JLabel emiratesLogo = new JLabel(new ImageIcon(IntroPage.class.getResource("logo-emirates.gif")));
        JPanel header = new JPanel();
        header.setBackground(Color.WHITE);
        header.setLayout(new MigLayout("insets 0 40 0 20", "[]80[grow]", "[]"));
        header.add((Component)emiratesLogo, "alignx left, aligny top");
        header.add((Component)dlscLogo, "alignx right, aligny center, wrap");
        JLabel title = new JLabel("FlexGantt 2.1");
        title.setIcon(new ImageIcon(IntroPage.class.getResource("beta_icon_small.png")));
        title.setFont(title.getFont().deriveFont(64.0f));
        title.setHorizontalTextPosition(10);
        title.setVerticalTextPosition(1);
        JLabel subtitle = new JLabel("Proof of Concept, April 2013");
        subtitle.setFont(title.getFont().deriveFont(32.0f));
        JLabel dataLarge = new JLabel(new ImageIcon(IntroPage.class.getResource("data-large.png")));
        dataLarge.setVerticalAlignment(3);
        dataLarge.setText("Large Data Set");
        dataLarge.setVerticalTextPosition(3);
        dataLarge.setHorizontalTextPosition(0);
        JLabel dataMedium = new JLabel(new ImageIcon(IntroPage.class.getResource("data-medium.png")));
        dataMedium.setVerticalAlignment(3);
        dataMedium.setText("Medium Data Set");
        dataMedium.setVerticalTextPosition(3);
        dataMedium.setHorizontalTextPosition(0);
        JLabel dataSmall = new JLabel(new ImageIcon(IntroPage.class.getResource("data-small.png")));
        dataSmall.setVerticalAlignment(3);
        dataSmall.setText("Small Data Set");
        dataSmall.setVerticalTextPosition(3);
        dataSmall.setHorizontalTextPosition(0);
        JPanel dataPanel = new JPanel();
        dataPanel.setLayout(new MigLayout("gap 20", "[grow]20", "[grow]"));
        dataPanel.add((Component)dataSmall, "grow, aligny bottom");
        dataPanel.add((Component)dataMedium, "grow, aligny bottom");
        dataPanel.add((Component)dataLarge, "grow, aligny bottom");
        dataPanel.setOpaque(false);
        panel.add((Component)header, "grow, spanx 2, wrap");
        panel.add((Component)title, "gap 40 80, skip 1, wrap");
        panel.add((Component)subtitle, "gapx 40, skip 1, wrap");
        panel.add((Component)dataPanel, "skip 1, alignx right, aligny bottom");
        JPanel wrapper = new JPanel();
        wrapper.setLayout(new BorderLayout());
        wrapper.setBorder(new DropShadowBorder());
        wrapper.add("Center", panel);
        wrapper.setOpaque(false);
        dataSmall.setCursor(Cursor.getPredefinedCursor(12));
        dataMedium.setCursor(Cursor.getPredefinedCursor(12));
        dataLarge.setCursor(Cursor.getPredefinedCursor(12));
        dataSmall.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                IntroPage.this.loadDataSet("flights-small.zip", 17785);
            }
        });
        dataMedium.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                IntroPage.this.loadDataSet("flights-medium.zip", 116423);
            }
        });
        dataLarge.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                IntroPage.this.loadDataSet("flights-large.zip", 244373);
            }
        });
        return wrapper;
    }

    private void loadDataSet(final String zipArchive, final int numberOfFlightsInFile) {
        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                IntroPage.this.loadDataSetInBackground(zipArchive, numberOfFlightsInFile);
                return null;
            }

            @Override
            protected void done() {
                IntroPage.this.getWorkbench().unblock();
            }
        };
        worker.execute();
    }

    private void loadDataSetInBackground(String zipArchive, int numberOfFlightsInFile) {
        this.backdropPanel.stopAnimation();
        try {
            ZipInputStream zin = new ZipInputStream(IntroPage.class.getResourceAsStream(zipArchive));
            ZipEntry ze = null;
            while ((ze = zin.getNextEntry()) != null) {
                if (!ze.getName().endsWith(".xml")) continue;
                File file = new File(System.getProperty("user.home"), ze.getName());
                if (!file.exists()) {
                    int size;
                    System.out.println("Unzipping " + ze.getName());
                    JOptionPane.showMessageDialog(this, "<html>Extracting data file " + ze.getName() + " into your home directory.<br>This might take a while.</html>");
                    this.getWorkbench().block("Unzipping to " + file.getAbsolutePath());
                    FileOutputStream fout = new FileOutputStream(file);
                    byte[] buffer = new byte[2048];
                    BufferedOutputStream bos = new BufferedOutputStream(fout, buffer.length);
                    while ((size = zin.read(buffer, 0, buffer.length)) != -1) {
                        bos.write(buffer, 0, size);
                    }
                    bos.flush();
                    bos.close();
                    zin.closeEntry();
                    fout.close();
                    System.out.println("Done unzipping!");
                } else {
                    System.out.println("Data file exists, no need to extract from archive.");
                }
                this.getWorkbench().load(new FileInputStream(file), numberOfFlightsInFile);
                break;
            }
            zin.close();
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    private void createDir(File dir) {
        if (!dir.mkdirs()) {
            throw new RuntimeException("Can not create dir " + dir);
        }
    }

    @Override
    protected StatusBar createStatusBar() {
        StatusBar bar = new StatusBar();
        bar.removeAll();
        BizLafControl.get().setStyle(bar, ":bizlaf:FooterBar");
        bar.setLayout(new MigLayout("insets 3 10 3 10", "[grow][]10[]", "[grow]"));
        this.taskNameLabel = this.createFooterLabel("OK");
        this.progressLabel = this.createFooterLabel("Loading");
        this.progressLabel.setVisible(false);
        bar.add((Component)this.taskNameLabel, "aligny center");
        bar.add((Component)this.progressLabel, "aligny center");
        this.progressBar = new JProgressBar();
        bar.add((Component)this.progressBar, "aligny center");
        this.progressBar.setVisible(false);
        return bar;
    }

    public void showProgressBar() {
        this.progressLabel.setVisible(true);
        this.progressBar.setVisible(true);
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    @Override
    public void setTaskName(String name) {
        this.taskNameLabel.setText(name);
    }

    public void hideProgressBar() {
        this.progressBar.setVisible(false);
        this.progressLabel.setVisible(false);
    }

    @Override
    public void beginTask(String text, int maximum) {
        this.showProgressBar();
        this.progressLabel.setText(text);
        this.progressBar.setMaximum(maximum);
        this.progressBar.setValue(0);
    }

    @Override
    public void worked(int worked) {
        int newValue = this.progressBar.getValue() + worked;
        this.progressBar.setValue(newValue);
    }
}

