/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.emirates.swing;

import com.dlsc.emirates.model.FlightGanttChartNode;
import com.dlsc.emirates.model.FlightGroupGanttChartNode;
import com.dlsc.emirates.model.ModelFactory;
import com.dlsc.emirates.swing.AbstractContentPanel;
import com.dlsc.emirates.swing.FlightsGanttChart;
import com.dlsc.emirates.swing.ToolBar;
import com.dlsc.emirates.swing.Utils;
import com.dlsc.emirates.swing.View;
import com.dlsc.emirates.swing.Workbench;
import com.dlsc.flexgantt.swing.GanttChartStatusBar;
import com.dlsc.flexgantt.swing.MessageTable;
import com.dlsc.flexgantt.swing.MessageTableModel;
import com.dlsc.flexgantt.swing.StatusBar;
import com.dlsc.flexgantt.swing.treetable.INodeFilter;
import de.centigrade.bizlaf.BizLafControl;
import java.awt.CardLayout;
import java.io.InputStream;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FlightsGanttChartContentPanel
extends AbstractContentPanel {
    private static final long serialVersionUID = 1L;
    private FlightsGanttChart ganttChart;
    private JPanel drawerCardPanel;
    private CardLayout drawerLayout;
    private MessageTable table;

    public FlightsGanttChartContentPanel(ModelFactory modelFactory, Workbench workbench, View view, InputStream stream) {
        super(workbench, view);
        this.ganttChart.setModelFactory(modelFactory);
        this.ganttChart.setTimeSpan(modelFactory.getHorizon());
    }

    public FlightsGanttChart getGanttChart() {
        return this.ganttChart;
    }

    @Override
    public void activate() {
        this.ganttChart.optimizeColumnWidth();
        this.ganttChart.resetToPreferredSizes();
    }

    @Override
    protected JComponent createContent() {
        this.ganttChart = new FlightsGanttChart(this.getView());
        return this.ganttChart;
    }

    @Override
    protected JComponent createDrawer() {
        this.drawerCardPanel = new JPanel();
        this.drawerLayout = new CardLayout();
        this.drawerCardPanel.setLayout(this.drawerLayout);
        this.table = new MessageTable(this.ganttChart, new MessageTableModel(this.ganttChart));
        this.table.setShowGrid(true);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.drawerCardPanel.add("errors", scrollPane);
        return this.drawerCardPanel;
    }

    public boolean isShowingErrors() {
        return this.getSplitPane().isOpen() && this.table.isShowing();
    }

    public void showMap() {
        this.drawerLayout.show(this.drawerCardPanel, "map");
        if (!this.getSplitPane().isOpen()) {
            this.getSplitPane().open();
        }
    }

    public void showErrors() {
        this.drawerLayout.show(this.drawerCardPanel, "errors");
        if (!this.getSplitPane().isOpen()) {
            this.getSplitPane().open();
        }
    }

    @Override
    protected JComponent createToolBar() {
        ToolBar toolBar = new ToolBar(this.ganttChart);
        toolBar.setFloatable(false);
        BizLafControl.get().setStyle(toolBar, ":bizlaf:RibbonLike");
        return toolBar;
    }

    @Override
    protected StatusBar createStatusBar() {
        GanttChartStatusBar<FlightsGanttChart> statusBar = new GanttChartStatusBar<FlightsGanttChart>(this.ganttChart);
        BizLafControl.get().setStyle(statusBar, ":bizlaf:FooterBar");
        statusBar.getResizeIconLabel().setVisible(false);
        Utils.makeLabelsShadowed(statusBar);
        return statusBar;
    }

    @Override
    public void setSearchText(final String text) {
        this.ganttChart.getPrimaryTreeTable().setNodeFilter(new INodeFilter(){

            @Override
            public boolean includeNode(Object node) {
                if (node instanceof FlightGanttChartNode) {
                    return this.includePlane(node);
                }
                if (node instanceof FlightGroupGanttChartNode) {
                    FlightGroupGanttChartNode groupNode = (FlightGroupGanttChartNode)node;
                    for (int index = 0; index < groupNode.getChildCount(); ++index) {
                        if (!this.includePlane(groupNode.getChildAt(index))) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }

            private boolean includePlane(Object node) {
                FlightGanttChartNode gcNode = (FlightGanttChartNode)node;
                String name = (String)gcNode.getKey();
                return name.contains(text);
            }
        });
    }
}

