/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.emirates.swing;

import com.dlsc.emirates.swing.policy.EmiratesLinePolicy;
import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.treetable.ITreeTableModel;
import com.dlsc.flexgantt.policy.layer.ILinePolicy;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.DefaultRowRenderer;
import com.dlsc.flexgantt.swing.layer.system.GridLayer;
import com.dlsc.flexgantt.swing.layer.system.RowLayer;
import com.dlsc.flexgantt.swing.mac.MacComponentFactory;
import com.dlsc.flexgantt.swing.timeline.Dateline;
import com.dlsc.flexgantt.swing.timeline.Eventline;
import com.dlsc.flexgantt.swing.timeline.Timeline;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.swing.treetable.TreeTableHeader;
import java.awt.Color;
import java.awt.Font;
import javax.swing.UIManager;

public class EmiratesComponentFactory
extends MacComponentFactory {
    private static EmiratesComponentFactory instance;
    public static Font FONT;
    public static Color ALTERNATING_ROW_COLOR;

    protected EmiratesComponentFactory() {
    }

    public static synchronized EmiratesComponentFactory getInstance() {
        if (instance == null) {
            instance = new EmiratesComponentFactory();
        }
        return instance;
    }

    @Override
    public LayerContainer createLayerContainer(AbstractGanttChart gc2, TreeTable table, IGanttChartModel model) {
        LayerContainer lc2 = super.createLayerContainer(gc2, table, model);
        lc2.getSystemLayer(GridLayer.class).setHorizontalLinesVisible(true);
        lc2.setFont(FONT);
        lc2.setBackground(Color.WHITE);
        lc2.setAlternatingBackground(ALTERNATING_ROW_COLOR);
        lc2.getPolicyProvider().setPolicy(ILinePolicy.class, new EmiratesLinePolicy());
        lc2.setTimelineObjectStatusColor("ERROR", Color.RED);
        lc2.setTimelineObjectStatusIcon("WARNING", IconRegistry.getIcon(IconId.WARNING));
        DefaultRowRenderer rowRenderer = new DefaultRowRenderer();
        rowRenderer.setFocusVisible(true);
        lc2.getSystemLayer(RowLayer.class).setRowRenderer(Object.class, rowRenderer);
        return lc2;
    }

    @Override
    public TreeTable createTreeTable(AbstractGanttChart gc2, ITreeTableModel model) {
        TreeTable table = super.createTreeTable(gc2, model);
        table.setRootVisible(false);
        table.setBackground(Color.WHITE);
        table.setAlternatingBackground(ALTERNATING_ROW_COLOR);
        table.setFont(FONT);
        table.setHorizontalLinesVisible(true);
        return table;
    }

    @Override
    public Dateline createDateline(Timeline timeline) {
        Dateline dateline = super.createDateline(timeline);
        dateline.setFont(FONT);
        return dateline;
    }

    @Override
    public Eventline createEventline(Timeline timeline, Dateline dateline) {
        Eventline eventline = super.createEventline(timeline, dateline);
        eventline.setFont(FONT);
        return eventline;
    }

    @Override
    public TreeTableHeader createTreeTableHeader(AbstractGanttChart gc2) {
        TreeTableHeader header = super.createTreeTableHeader(gc2);
        header.setFont(FONT);
        return header;
    }

    static {
        FONT = UIManager.getFont("Label.font").deriveFont(11.0f);
        ALTERNATING_ROW_COLOR = new Color(245, 245, 250);
    }
}

