/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.emirates.model;

import com.dlsc.emirates.model.AircraftGanttChartNode;
import com.dlsc.emirates.model.ModelFactory;
import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.dateline.TimeGranularity;
import com.dlsc.flexgantt.model.gantt.CapacityLine;
import com.dlsc.flexgantt.model.gantt.DefaultCapacityObject;
import com.dlsc.flexgantt.model.gantt.DefaultResourceNode;
import com.dlsc.flexgantt.model.gantt.ITimelineObject;
import java.util.Iterator;
import java.util.TimeZone;

public class TailGroupGanttChartNode
extends DefaultResourceNode<Object, ITimelineObject> {
    public TailGroupGanttChartNode(String name) {
        this.setKey(name);
        this.setRowHeight(60);
    }

    public int getMaximumNumberOfDesiredFlights() {
        return this.getChildCount() * 4;
    }

    public int getMinimumNumberOfDesiredFlights() {
        return this.getChildCount() * 2;
    }

    public void updateUsageProfile(ITimeSpan horizon) {
        this.clearTimelineObjects(ModelFactory.USAGE_LAYER);
        TimeZone timeZone = TimeZone.getDefault();
        long dayStartTime = TimeGranularity.DAY_SHORT.adjustTime(horizon.getStartTime(), timeZone);
        long dayEndTime = TimeGranularity.DAY_SHORT.increment(dayStartTime, timeZone);
        int maximumNumberOfFlights = 0;
        do {
            dayStartTime = dayEndTime + 1L;
            dayEndTime = TimeGranularity.DAY_SHORT.increment(dayEndTime, timeZone);
            TimeSpan span = new TimeSpan(dayStartTime, dayEndTime);
            int numberOfFlights = this.calculateNumberOfFlights(span);
            maximumNumberOfFlights = Math.max(maximumNumberOfFlights, numberOfFlights);
            DefaultCapacityObject capacityObject = new DefaultCapacityObject();
            capacityObject.setCapacityUsed(numberOfFlights);
            capacityObject.setTimeSpan(span);
            capacityObject.setPopupObject("Flights / Day: " + numberOfFlights, false);
            this.addTimelineObject(ModelFactory.USAGE_LAYER, capacityObject);
        } while (dayEndTime < horizon.getEndTime());
        this.setMaximumCapacity(this.getChildCount() * 10);
        this.clearMajorCapacityLines();
        this.clearMinorCapacityLines();
        this.addMajorCapacityLine(new CapacityLine(this.getMinimumNumberOfDesiredFlights(), Integer.toString(this.getMinimumNumberOfDesiredFlights())));
        this.addMajorCapacityLine(new CapacityLine(this.getMaximumNumberOfDesiredFlights(), Integer.toString(this.getMaximumNumberOfDesiredFlights())));
    }

    private int calculateNumberOfFlights(ITimeSpan span) {
        int numberOfFlights = 0;
        int childCount = this.getChildCount();
        for (int index = 0; index < childCount; ++index) {
            AircraftGanttChartNode aircraftGanttChartNode = (AircraftGanttChartNode)this.getChildAt(index);
            Iterator iter = aircraftGanttChartNode.getTimelineObjectsIterator(span);
            while (iter.hasNext()) {
                ++numberOfFlights;
                iter.next();
            }
        }
        return numberOfFlights;
    }
}

