/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.emirates.model;

import com.dlsc.emirates.generated.flights.ROW;
import com.dlsc.emirates.generated.flights.ROWDATA;
import com.dlsc.emirates.model.AircraftGanttChartNode;
import com.dlsc.emirates.model.FlightTimelineObject;
import com.dlsc.emirates.model.LegRelationship;
import com.dlsc.emirates.model.RouteRelationship;
import com.dlsc.emirates.model.TailGroupGanttChartNode;
import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.dateline.TimeGranularity;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.gantt.GanttChartModelEvent;
import com.dlsc.flexgantt.model.gantt.IGanttChartModelListener;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.model.gantt.ISpreadsheet;
import com.dlsc.flexgantt.model.gantt.Layer;
import com.dlsc.flexgantt.model.gantt.Spreadsheet;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.model.paging.DefaultPagingModel;
import com.dlsc.flexgantt.model.paging.Page;
import com.opencsv.CSVWriter;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class ModelFactory
implements IGanttChartModelListener {
    public static final DateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
    public static final DateFormat timeFormat = new SimpleDateFormat("HHmm");
    private static final Calendar dateCalendar = Calendar.getInstance();
    private static final Calendar timeCalendar = Calendar.getInstance();
    public static final Layer USAGE_LAYER = new Layer("Usage");
    public static final ISpreadsheet SPREADSHEET = new Spreadsheet("Usage", TimeGranularity.DAY_SHORT, 40, Integer.class);
    private Map<String, ILayer> layerMap = new HashMap<String, ILayer>();
    private Map<String, TailGroupGanttChartNode> primaryTailGroupMap = new HashMap<String, TailGroupGanttChartNode>();
    private Map<String, AircraftGanttChartNode> aircraftNodeMap = new HashMap<String, AircraftGanttChartNode>();
    private Map<ROW, FlightTimelineObject> flightMap = new HashMap<ROW, FlightTimelineObject>();
    private Map<String, List<TimelineObjectPath<FlightTimelineObject>>> flightByNumberMap = new HashMap<String, List<TimelineObjectPath<FlightTimelineObject>>>();
    private Map<String, List<ROW>> legsMap = new HashMap<String, List<ROW>>();
    private Map<String, List<ROW>> routeMap = new HashMap<String, List<ROW>>();
    private Set<String> serviceTypeSet = new HashSet<String>();
    private Set<String> aircarftTypeSet = new HashSet<String>();
    private ITimeSpan horizon;
    private DefaultGanttChartModel<AircraftGanttChartNode, FlightTimelineObject> fleetModel;
    private DefaultGanttChartModel<AircraftGanttChartNode, FlightTimelineObject> alternativeAircraftModel;
    private DefaultPagingModel pagingModel = new DefaultPagingModel();

    public ModelFactory(InputStream stream, final IProgressMonitor monitor) throws JAXBException {
        this.fleetModel = new DefaultGanttChartModel(new AircraftGanttChartNode(null));
        this.alternativeAircraftModel = new DefaultGanttChartModel(new AircraftGanttChartNode(null));
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ROWDATA.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        unmarshaller.setListener(new Unmarshaller.Listener(){
            private ITimeSpan horizon = TimeSpan.UNDEFINED;

            public void afterUnmarshal(Object target, Object parent) {
                if (target instanceof ROW) {
                    ROW row = (ROW)target;
                    ITimeSpan flightTimeSpan = ModelFactory.this.createFlight(row);
                    if (flightTimeSpan != null) {
                        this.horizon = this.horizon.union(flightTimeSpan);
                    }
                    monitor.worked(1);
                } else if (target instanceof ROWDATA) {
                    ModelFactory.this.setHorizon(this.horizon);
                }
            }
        });
        monitor.setTaskName("Unmarshalling XML file");
        unmarshaller.unmarshal(stream);
        this.createLegRelationships();
        this.createRouteRelationships();
        this.createUsageProfiles(monitor);
        this.createLineInfo(monitor);
        this.createPagingModel(monitor);
        for (ILayer layer : this.layerMap.values()) {
            this.fleetModel.addLayer(layer);
            this.alternativeAircraftModel.addLayer(layer);
        }
        this.fleetModel.addLayer(USAGE_LAYER);
        this.fleetModel.addSpreadsheet(SPREADSHEET);
        for (String serviceType : this.serviceTypeSet) {
            System.out.println("service type: " + serviceType);
        }
        for (String acType : this.aircarftTypeSet) {
            System.out.println("AC type: " + acType);
        }
        this.legsMap.clear();
        this.routeMap.clear();
        this.fleetModel.addGanttChartModelListener(this);
    }

    public Map<String, ILayer> getLayerMap() {
        return this.layerMap;
    }

    public DefaultPagingModel getPagingModel() {
        return this.pagingModel;
    }

    private void createPagingModel(IProgressMonitor monitor) {
        monitor.beginTask("Creating Paging Model", 1);
        Calendar s2 = Calendar.getInstance();
        s2.setTimeInMillis(this.horizon.getStartTime());
        Calendar e2 = Calendar.getInstance();
        e2.setTimeInMillis(this.horizon.getEndTime());
        double years = TimeGranularity.YEAR.getDelta(s2, e2);
        double quarters = TimeGranularity.QUARTER_YEAR.getDelta(s2, e2);
        Page page = new Page(new TimeSpan(s2, e2), "All");
        if (years > 1.0) {
            TimeSpan span;
            Calendar c1 = (Calendar)s2.clone();
            TimeGranularity.YEAR.adjustCalendar(c1);
            Calendar c2 = (Calendar)s2.clone();
            TimeGranularity.YEAR.adjustCalendar(c2);
            int i2 = 0;
            while ((double)i2 < years) {
                TimeGranularity.YEAR.increment(c2);
                span = new TimeSpan(c1, c2);
                page = new Page(span, "Year " + c1.get(1));
                TimeGranularity.YEAR.increment(c1);
                this.pagingModel.addPage(page);
                ++i2;
            }
            c1 = (Calendar)s2.clone();
            TimeGranularity.YEAR.adjustCalendar(c1);
            TimeGranularity.QUARTER_YEAR.adjustCalendar(c1);
            c2 = (Calendar)s2.clone();
            TimeGranularity.YEAR.adjustCalendar(c2);
            TimeGranularity.QUARTER_YEAR.adjustCalendar(c2);
            i2 = 0;
            while ((double)i2 < quarters) {
                TimeGranularity.QUARTER_YEAR.increment(c2);
                span = new TimeSpan(c1, c2);
                page = new Page(span, "Year " + c1.get(1) + " (Q" + (i2 % 4 + 1) + ")");
                TimeGranularity.QUARTER_YEAR.increment(c1);
                this.pagingModel.addPage(page);
                ++i2;
            }
        }
        monitor.worked(1);
    }

    public List<TimelineObjectPath<FlightTimelineObject>> getFlightsByFlightNo(String flightNo) {
        return this.flightByNumberMap.get(flightNo);
    }

    public AircraftGanttChartNode getAircraftNodeForFlight(FlightTimelineObject tlo) {
        return this.aircraftNodeMap.get(((ROW)tlo.getUserObject()).getResource());
    }

    private void createLineInfo(IProgressMonitor monitor) {
        monitor.beginTask("Calculating overlapping flights...", this.aircraftNodeMap.values().size());
        for (AircraftGanttChartNode node : this.aircraftNodeMap.values()) {
            node.calculateLines();
            monitor.worked(1);
        }
    }

    public DefaultGanttChartModel<AircraftGanttChartNode, FlightTimelineObject> getFleetModel() {
        return this.fleetModel;
    }

    public DefaultGanttChartModel<AircraftGanttChartNode, FlightTimelineObject> getAlternativeAircraftModel() {
        return this.alternativeAircraftModel;
    }

    public int getTotalNumberOfFlights() {
        return this.flightMap.size();
    }

    public int getTotalNumberOfPlanes() {
        return this.aircraftNodeMap.size();
    }

    private void createRouteRelationships() {
        for (List<ROW> routes : this.routeMap.values()) {
            if (routes.size() <= 1) continue;
            for (int index = 0; index < routes.size() - 1; ++index) {
                ROW flight1 = routes.get(index);
                ROW flight2 = routes.get(index + 1);
                this.createRelationship(flight1, flight2, false);
            }
        }
    }

    private void createLegRelationships() {
        for (List<ROW> legs : this.legsMap.values()) {
            if (legs.size() <= 1) continue;
            for (int index = 0; index < legs.size() - 1; ++index) {
                ROW flight1 = legs.get(index);
                ROW flight2 = legs.get(index + 1);
                this.createRelationship(flight1, flight2, true);
            }
        }
    }

    private void createRelationship(ROW flight1, ROW flight2, boolean legRelationship) {
        String resource = flight1.getResource();
        AircraftGanttChartNode plane = this.aircraftNodeMap.get(resource);
        FlightTimelineObject flight1Tlo = this.flightMap.get(flight1);
        FlightTimelineObject flight2Tlo = this.flightMap.get(flight2);
        ILayer sourceLayer = this.layerMap.get(((ROW)flight1Tlo.getUserObject()).getSERVICETYPE());
        ILayer targetLayer = this.layerMap.get(((ROW)flight2Tlo.getUserObject()).getSERVICETYPE());
        TimelineObjectPath<FlightTimelineObject> sourcePath = new TimelineObjectPath<FlightTimelineObject>(plane.getPath(), flight1Tlo, sourceLayer);
        TimelineObjectPath<FlightTimelineObject> targetPath = new TimelineObjectPath<FlightTimelineObject>(plane.getPath(), flight2Tlo, targetLayer);
        if (legRelationship) {
            this.fleetModel.addRelationship(new LegRelationship(sourcePath, targetPath));
        } else {
            this.fleetModel.addRelationship(new RouteRelationship(sourcePath, targetPath));
        }
    }

    private void setHorizon(ITimeSpan span) {
        this.horizon = span;
    }

    public ITimeSpan getHorizon() {
        return this.horizon;
    }

    private ITimeSpan createFlight(ROW row) {
        ITimeSpan timeSpan = this.createFlightTimeSpan(row);
        if (timeSpan != null) {
            FlightTimelineObject flightTimelineObject = new FlightTimelineObject(row);
            flightTimelineObject.setTimeSpan(timeSpan);
            ILayer layer = this.getOrCreateLayer(row);
            AircraftGanttChartNode aircraftGanttChartNode = this.getOrCreatePlane(row);
            aircraftGanttChartNode.addTimelineObject(layer, flightTimelineObject);
            List<TimelineObjectPath<FlightTimelineObject>> flights = this.flightByNumberMap.get(row.getFLIGHTNO());
            if (flights == null) {
                flights = new ArrayList<TimelineObjectPath<FlightTimelineObject>>();
                this.flightByNumberMap.put(row.getFLIGHTNO(), flights);
            }
            flights.add(new TimelineObjectPath<FlightTimelineObject>(aircraftGanttChartNode.getPath(), flightTimelineObject, layer));
            String flightId = row.getFLIGHTID();
            String routeId = row.getROUTEID();
            List<ROW> legsList = this.legsMap.get(flightId);
            List<ROW> routeList = this.routeMap.get(routeId);
            if (legsList == null) {
                legsList = new ArrayList<ROW>();
                this.legsMap.put(flightId, legsList);
            }
            if (routeList == null) {
                routeList = new ArrayList<ROW>();
                this.routeMap.put(routeId, routeList);
            }
            legsList.add(row);
            routeList.add(row);
            this.flightMap.put(row, flightTimelineObject);
            this.serviceTypeSet.add(row.getSERVICETYPE());
            this.aircarftTypeSet.add(row.getACTYPE());
            return timeSpan;
        }
        return null;
    }

    private ILayer getOrCreateLayer(ROW row) {
        ILayer layer = this.layerMap.get(row.getSERVICETYPE());
        if (layer == null) {
            layer = new Layer("Service Type " + row.getSERVICETYPE());
            this.layerMap.put(row.getSERVICETYPE(), layer);
        }
        return layer;
    }

    private AircraftGanttChartNode getOrCreatePlane(ROW row) {
        String planeName = row.getResource();
        AircraftGanttChartNode aircraftGanttChartNode = this.aircraftNodeMap.get(planeName);
        if (aircraftGanttChartNode == null) {
            aircraftGanttChartNode = new AircraftGanttChartNode(row);
            String tailGroupName = planeName.substring(0, planeName.indexOf(45));
            this.aircraftNodeMap.put(planeName, aircraftGanttChartNode);
            TailGroupGanttChartNode tailGroupNode = this.getOrCreateTailGroup(tailGroupName);
            tailGroupNode.add(aircraftGanttChartNode);
        }
        return aircraftGanttChartNode;
    }

    private TailGroupGanttChartNode getOrCreateTailGroup(String tailGroupName) {
        TailGroupGanttChartNode node = this.primaryTailGroupMap.get(tailGroupName);
        if (node == null) {
            node = new TailGroupGanttChartNode(tailGroupName);
            AircraftGanttChartNode rootNode = (AircraftGanttChartNode)this.fleetModel.getRoot();
            rootNode.add(node);
            this.primaryTailGroupMap.put(tailGroupName, node);
        }
        return node;
    }

    private ITimeSpan createFlightTimeSpan(ROW row) {
        try {
            Date departureDate = dateFormat.parse(row.getORIGINDATE());
            Date departureTime = timeFormat.parse(Short.toString(row.getSTANDARDDEPTIME()));
            Date arrivalDate = dateFormat.parse(row.getARRIVALDATE());
            Date arrivalTime = timeFormat.parse(Short.toString(row.getSTANDARDARRIVALTIME()));
            departureDate = this.createCompleteDate(departureDate, departureTime);
            arrivalDate = this.createCompleteDate(arrivalDate, arrivalTime);
            if (arrivalDate.after(departureDate)) {
                return new TimeSpan(departureDate, arrivalDate);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Date createCompleteDate(Date date, Date time) {
        dateCalendar.setTime(date);
        timeCalendar.setTime(time);
        dateCalendar.set(11, timeCalendar.get(11));
        dateCalendar.set(12, timeCalendar.get(12));
        return dateCalendar.getTime();
    }

    private void createUsageProfiles(IProgressMonitor monitor) {
        monitor.beginTask("Creating Capacity Profiles", this.primaryTailGroupMap.size());
        for (TailGroupGanttChartNode node : this.primaryTailGroupMap.values()) {
            node.updateUsageProfile(this.horizon);
            monitor.worked(1);
        }
    }

    @Override
    public void ganttChartChanged(GanttChartModelEvent evt) {
        switch (evt.getId()) {
            case TIMELINE_OBJECT_CHANGED: {
                FlightTimelineObject flightTimelineObject = (FlightTimelineObject)evt.getTimelineObject();
                ROW row = (ROW)flightTimelineObject.getUserObject();
                String plane = row.getResource();
                AircraftGanttChartNode node = this.aircraftNodeMap.get(plane);
                TailGroupGanttChartNode parentNode = (TailGroupGanttChartNode)node.getParent();
                parentNode.updateUsageProfile(this.horizon);
                break;
            }
        }
    }

    public void export(CSVWriter writer) {
        this.export(writer, this.flightMap.values());
    }

    public void export(CSVWriter writer, Collection<FlightTimelineObject> flights) {
        String[] str = new String[]{"Flight ID", "Flight Date", "Resource", "DEP", "ARR", "Type", "Leg#", "Remarks"};
        writer.writeNext(str);
        for (FlightTimelineObject flight : flights) {
            flight.export(writer);
        }
    }
}

