/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LoggingFormatter
extends Formatter {
    @Override
    public synchronized String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        if (record.getSourceClassName() != null) {
            sb.append(record.getSourceClassName().substring(record.getSourceClassName().lastIndexOf(46) + 1));
        } else {
            sb.append(record.getLoggerName());
        }
        if (record.getSourceMethodName() != null) {
            sb.append(".");
            sb.append(record.getSourceMethodName());
        }
        sb.append(" ");
        String message = this.formatMessage(record);
        sb.append(record.getLevel().getLocalizedName());
        sb.append(": ");
        sb.append(message);
        sb.append(System.getProperty("line.separator"));
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            record.getThrown().printStackTrace(pw);
            pw.close();
            sb.append(sw.toString());
        }
        return sb.toString();
    }
}

