/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.util;

import java.awt.Rectangle;
import java.awt.geom.GeneralPath;

public class PathCalculator {
    private int offset = 6;
    private int gap = 4;
    private int curve = 6;
    private TargetLocation targetLocation;
    private ArrowDirection arrowDirection = ArrowDirection.RIGHT;

    public TargetLocation getTargetLocation() {
        return this.targetLocation;
    }

    public ArrowDirection getArrowDirection() {
        return this.arrowDirection;
    }

    private TargetLocation calculateTargetLocation(int sx, int sy, int tx, int ty) {
        int xDelta = tx - sx;
        if (sy < ty) {
            if (xDelta > 0) {
                return TargetLocation.BELOW_RIGHT;
            }
            if (xDelta < 0) {
                return TargetLocation.BELOW_LEFT;
            }
            return TargetLocation.BELOW;
        }
        if (sy > ty) {
            if (xDelta > 0) {
                return TargetLocation.ABOVE_RIGHT;
            }
            if (xDelta < 0) {
                return TargetLocation.ABOVE_LEFT;
            }
            return TargetLocation.ABOVE;
        }
        if (xDelta > 0) {
            return TargetLocation.RIGHT;
        }
        if (xDelta < 0) {
            return TargetLocation.LEFT;
        }
        return TargetLocation.SAME_LOCATION;
    }

    public GeneralPath calculatePathStartToStart(Rectangle sourceRect, Rectangle targetRect) {
        GeneralPath path = new GeneralPath();
        int sx = sourceRect.x;
        int sx1 = sx - this.offset;
        int tx = targetRect.x;
        int tx1 = tx - this.offset;
        int sy = sourceRect.y + sourceRect.height / 2;
        int ty = targetRect.y + targetRect.height / 2;
        this.arrowDirection = ArrowDirection.RIGHT;
        this.targetLocation = this.calculateTargetLocation(sx1, sy, tx1, ty);
        path.moveTo(sx, sy);
        switch (this.targetLocation) {
            case BELOW_RIGHT: 
            case BELOW: 
            case BELOW_LEFT: {
                int x = Math.min(sx1, tx1);
                path.lineTo(x + this.curve, sy);
                path.quadTo(x, sy, x, sy + this.curve);
                path.lineTo(x, ty - this.curve);
                path.quadTo(x, ty, x + this.curve, ty);
                path.lineTo(tx, ty);
                break;
            }
            case ABOVE_RIGHT: 
            case ABOVE_LEFT: 
            case ABOVE: {
                int x = Math.min(sx1, tx1);
                path.lineTo(x + this.curve, sy);
                path.quadTo(x, sy, x, sy - this.curve);
                path.lineTo(x, ty + this.curve);
                path.quadTo(x, ty, x + this.curve, ty);
                path.lineTo(tx, ty);
                break;
            }
            case RIGHT: {
                int my = sourceRect.y + sourceRect.height + this.gap;
                path.lineTo(sx1 + this.curve, sy);
                path.quadTo(sx1, sy, sx1, sy + this.curve);
                path.lineTo(sx1, my - this.curve);
                path.quadTo(sx1, my, sx1 + this.curve, my);
                path.lineTo(tx1 - this.curve, my);
                path.quadTo(tx1, my, tx1, my - this.curve);
                path.lineTo(tx1, ty + this.curve);
                path.quadTo(tx1, ty, tx1 + this.curve, ty);
                path.lineTo(tx, ty);
                break;
            }
            case LEFT: {
                int my = sourceRect.y - this.gap;
                path.lineTo(sx1 + this.curve, sy);
                path.quadTo(sx1, sy, sx1, sy - this.curve);
                path.lineTo(sx1, my + this.curve);
                path.quadTo(sx1, my, sx1 - this.curve, my);
                path.lineTo(tx1 + this.curve, my);
                path.quadTo(tx1, my, tx1, my + this.curve);
                path.lineTo(tx1, ty - this.curve);
                path.quadTo(tx1, ty, tx + this.curve, ty);
                path.lineTo(tx, ty);
                break;
            }
        }
        return path;
    }

    public GeneralPath calculatePathEndToEnd(Rectangle sourceRect, Rectangle targetRect) {
        GeneralPath path = new GeneralPath();
        int sx = sourceRect.x + sourceRect.width;
        int sx1 = sx + this.offset;
        int tx = targetRect.x + targetRect.width;
        int tx1 = tx + this.offset;
        int sy = sourceRect.y + sourceRect.height / 2;
        int ty = targetRect.y + targetRect.height / 2;
        this.arrowDirection = ArrowDirection.LEFT;
        this.targetLocation = this.calculateTargetLocation(sx1, sy, tx1, ty);
        path.moveTo(sx, sy);
        switch (this.targetLocation) {
            case BELOW_RIGHT: 
            case BELOW: 
            case BELOW_LEFT: {
                int x = Math.max(sx1, tx1);
                path.lineTo(x - this.curve, sy);
                path.quadTo(x, sy, x, sy + this.curve);
                path.lineTo(x, ty - this.curve);
                path.quadTo(x, ty, x - this.curve, ty);
                path.lineTo(tx, ty);
                break;
            }
            case ABOVE_RIGHT: 
            case ABOVE_LEFT: 
            case ABOVE: {
                int x = Math.max(sx1, tx1);
                path.lineTo(x - this.curve, sy);
                path.quadTo(x, sy, x, sy - this.curve);
                path.lineTo(x, ty + this.curve);
                path.quadTo(x, ty, x - this.curve, ty);
                path.lineTo(tx, ty);
                break;
            }
            case RIGHT: {
                int my = sourceRect.y - this.gap;
                path.lineTo(sx1 - this.curve, sy);
                path.quadTo(sx1, sy, sx1, sy - this.curve);
                path.lineTo(sx1, my + this.curve);
                path.quadTo(sx1, my, sx1 + this.curve, my);
                path.lineTo(tx1 - this.curve, my);
                path.quadTo(tx1, my, tx1, my + this.curve);
                path.lineTo(tx1, ty - this.curve);
                path.quadTo(tx1, ty, tx1 - this.curve, ty);
                path.lineTo(tx, ty);
                break;
            }
            case LEFT: {
                int my = sourceRect.y + sourceRect.height + this.gap;
                path.lineTo(sx1 - this.curve, sy);
                path.quadTo(sx1, sy, sx1, sy + this.curve);
                path.lineTo(sx1, my - this.curve);
                path.quadTo(sx1, my, sx1 - this.curve, my);
                path.lineTo(tx1 + this.curve, my);
                path.quadTo(tx1, my, tx1, my - this.curve);
                path.lineTo(tx1, ty + this.curve);
                path.quadTo(tx1, ty, tx1 - this.curve, ty);
                path.lineTo(tx, ty);
                break;
            }
        }
        return path;
    }

    public GeneralPath calculatePathStartToEnd(Rectangle sourceRect, Rectangle targetRect) {
        GeneralPath path = new GeneralPath();
        int sx = sourceRect.x;
        int sx1 = sx - this.offset;
        int tx = targetRect.x + targetRect.width;
        int tx1 = tx + this.offset;
        int sy = sourceRect.y + sourceRect.height / 2;
        int ty = targetRect.y + targetRect.height / 2;
        this.arrowDirection = ArrowDirection.LEFT;
        this.targetLocation = this.calculateTargetLocation(sx1, sy, tx1, ty);
        path.moveTo(sx, sy);
        switch (this.targetLocation) {
            case BELOW: 
            case BELOW_LEFT: {
                path.lineTo(sx1 + this.curve, sy);
                path.quadTo(sx1, sy, sx1, sy + this.curve);
                path.lineTo(sx1, ty - this.curve);
                path.quadTo(sx1, ty, sx1 - this.curve, ty);
                path.lineTo(tx, ty);
                break;
            }
            case BELOW_RIGHT: {
                int my = sourceRect.y + sourceRect.height + this.gap;
                path.lineTo(sx1 + this.curve, sy);
                path.quadTo(sx1, sy, sx1, sy + this.curve);
                path.lineTo(sx1, my - this.curve);
                path.quadTo(sx1, my, sx1 + this.curve, my);
                path.lineTo(tx1 - this.curve, my);
                path.quadTo(tx1, my, tx1, my + this.curve);
                path.lineTo(tx1, ty - this.curve);
                path.quadTo(tx1, ty, tx1 - this.curve, ty);
                path.lineTo(tx, ty);
                break;
            }
            case ABOVE_RIGHT: {
                int my = sourceRect.y - this.gap;
                path.lineTo(sx1 + this.curve, sy);
                path.quadTo(sx1, sy, sx1, sy - this.curve);
                path.lineTo(sx1, my + this.curve);
                path.quadTo(sx1, my, sx1 + this.curve, my);
                path.lineTo(tx1 - this.curve, my);
                path.quadTo(tx1, my, tx1, my - this.curve);
                path.lineTo(tx1, ty + this.curve);
                path.quadTo(tx1, ty, tx1 - this.curve, ty);
                path.lineTo(tx, ty);
                break;
            }
            case ABOVE_LEFT: 
            case ABOVE: {
                path.lineTo(sx1 + this.curve, sy);
                path.quadTo(sx1, sy, sx1, sy - this.curve);
                path.lineTo(sx1, ty + this.curve);
                path.quadTo(sx1, ty, sx1 - this.curve, ty);
                path.lineTo(tx, ty);
                break;
            }
            case RIGHT: {
                int my = sourceRect.y - this.gap;
                path.lineTo(sx1 + this.curve, sy);
                path.quadTo(sx1, sy, sx1, sy - this.curve);
                path.lineTo(sx1, my + this.curve);
                path.quadTo(sx1, my, sx1 + this.curve, my);
                path.lineTo(tx1 - this.curve, my);
                path.quadTo(tx1, my, tx1, my + this.curve);
                path.lineTo(tx1, ty - this.curve);
                path.quadTo(tx1, ty, tx1 - this.curve, ty);
                path.lineTo(tx, ty);
                break;
            }
            case LEFT: {
                path.lineTo(tx, ty);
                break;
            }
        }
        return path;
    }

    public GeneralPath calculatePathEndToStart(Rectangle sourceRect, Rectangle targetRect) {
        GeneralPath path = new GeneralPath();
        if (sourceRect == null || targetRect == null) {
            return path;
        }
        int sx = sourceRect.x + sourceRect.width;
        int sx1 = sx + this.offset;
        int tx = targetRect.x;
        int tx1 = tx - this.offset;
        int sy = sourceRect.y + sourceRect.height / 2;
        int ty = targetRect.y + targetRect.height / 2;
        this.arrowDirection = ArrowDirection.RIGHT;
        this.targetLocation = this.calculateTargetLocation(sx1, sy, tx1, ty);
        path.moveTo(sx, sy);
        switch (this.targetLocation) {
            case BELOW_RIGHT: {
                path.lineTo(sx1 - this.curve, sy);
                path.quadTo(sx1, sy, sx1, sy + this.curve);
                path.lineTo(sx1, ty - this.curve);
                path.quadTo(sx1, ty, sx1 + this.curve, ty);
                path.lineTo(tx, ty);
                break;
            }
            case BELOW: 
            case BELOW_LEFT: {
                int my = sourceRect.y + sourceRect.height + this.gap;
                path.lineTo(sx1 - this.curve, sy);
                path.quadTo(sx1, sy, sx1, sy + this.curve);
                path.lineTo(sx1, my - this.curve);
                path.quadTo(sx1, my, sx1 - this.curve, my);
                path.lineTo(tx1 + this.curve, my);
                path.quadTo(tx1, my, tx1, my + this.curve);
                path.lineTo(tx1, ty - this.curve);
                path.quadTo(tx1, ty, tx1 + this.curve, ty);
                path.lineTo(tx, ty);
                break;
            }
            case ABOVE_RIGHT: {
                path.lineTo(sx1 - this.curve, sy);
                path.quadTo(sx1, sy, sx1, sy - this.curve);
                path.lineTo(sx1, ty + this.curve);
                path.quadTo(sx1, ty, sx1 + this.curve, ty);
                path.lineTo(tx, ty);
                break;
            }
            case ABOVE_LEFT: 
            case ABOVE: {
                int my = sourceRect.y - this.gap;
                path.lineTo(sx1 - this.curve, sy);
                int delta = (sy - my) / 2 + 1;
                path.quadTo(sx1 - this.curve + delta, sy - delta, sx1 - this.curve, my);
                path.lineTo(tx1 + this.curve, my);
                path.quadTo(tx1, my, tx1, my - this.curve);
                path.lineTo(tx1, ty + this.curve);
                path.quadTo(tx1, ty, tx1 + this.curve, ty);
                path.lineTo(tx, ty);
                break;
            }
            case RIGHT: {
                path.lineTo(tx, ty);
                break;
            }
            case LEFT: {
                int my = sourceRect.y - this.gap;
                path.lineTo(sx1 - this.curve, sy);
                int delta = (sy - my) / 2 + 1;
                path.quadTo(sx1 - this.curve + delta, sy - delta, sx1 - this.curve, my);
                path.lineTo(tx1 + this.curve, my);
                path.quadTo(tx1, my, tx1, my + this.curve);
                path.lineTo(tx1, ty - this.curve);
                path.quadTo(tx1, ty, tx1 + this.curve, ty);
                break;
            }
        }
        return path;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset can not be negative");
        }
        if (this.curve > offset) {
            throw new IllegalArgumentException("curve can not be larger than the offset (requested offset = " + offset + ", current curve = " + this.curve);
        }
        this.offset = offset;
    }

    public void setCurve(int curve) {
        if (curve < 0) {
            throw new IllegalArgumentException("curve can not be negative");
        }
        if (curve > this.offset) {
            throw new IllegalArgumentException("curve can not be larger than the offset (current offset = " + this.offset + ", requested curve = " + curve);
        }
        this.curve = curve;
    }

    public int getCurve() {
        return this.curve;
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    public static enum ArrowDirection {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }

    public static enum TargetLocation {
        BELOW_RIGHT,
        BELOW,
        BELOW_LEFT,
        ABOVE_RIGHT,
        ABOVE,
        ABOVE_LEFT,
        LEFT,
        RIGHT,
        SAME_LOCATION;

    }
}

