/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.util;

import com.dlsc.flexgantt.icons.BlankIcon;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class MenuCleaner {
    public static void clean(JPopupMenu popup) {
        if (popup == null) {
            throw new IllegalArgumentException("popup can not be NULL");
        }
        boolean containsIcons = false;
        int width = 0;
        int height = 0;
        for (Component comp : popup.getComponents()) {
            if (comp instanceof JMenuItem) {
                JMenuItem item = (JMenuItem)comp;
                Icon icon = item.getIcon();
                if (icon == null) continue;
                containsIcons = true;
                width = Math.max(width, icon.getIconWidth());
                height = Math.max(height, icon.getIconHeight());
                continue;
            }
            if (!(comp instanceof JMenu)) continue;
            MenuCleaner.clean((JMenu)comp);
        }
        if (containsIcons) {
            BlankIcon blank = new BlankIcon(width, height);
            for (Component comp : popup.getComponents()) {
                JMenuItem item;
                if (!(comp instanceof JMenuItem) || (item = (JMenuItem)comp).getIcon() != null) continue;
                item.setIcon(blank);
            }
        }
    }

    public static void clean(JMenu menu) {
        if (menu == null) {
            throw new IllegalArgumentException("menu can not be NULL");
        }
        boolean containsIcons = false;
        int width = 0;
        int height = 0;
        int count = menu.getItemCount();
        for (int i = 0; i < count; ++i) {
            JMenuItem item = menu.getItem(i);
            Icon icon = item.getIcon();
            if (icon == null) continue;
            containsIcons = true;
            width = Math.max(width, icon.getIconWidth());
            height = Math.max(height, icon.getIconHeight());
        }
        if (containsIcons) {
            BlankIcon blank = new BlankIcon(width, height);
            for (int i = 0; i < count; ++i) {
                JMenuItem item = menu.getItem(i);
                if (item.getIcon() == null) {
                    item.setIcon(blank);
                }
                if (!(item instanceof JMenu)) continue;
                MenuCleaner.clean((JMenu)item);
            }
        }
    }
}

