/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.treetable;

import com.dlsc.flexgantt.model.treetable.ITreeTableModel;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.treetable.IRowPolicy;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.TreePath;

public class TreeTableNode {
    private static final Map<Object, TreeTableNode> EMPTY_CACHE = new HashMap<Object, TreeTableNode>();
    protected TreeTableNode parent;
    protected TreeTableNode[] children;
    private boolean expanded;
    private int depth;
    private int row = -1;
    private Object modelNode;
    private int y;
    private boolean loaded;
    private ITreeTableModel model;
    private TreeTable table;
    private int childrenHeight = -1;
    private int childrenCount = -1;

    protected TreeTableNode(TreeTable table, Object modelNode) {
        if (table == null) {
            throw new IllegalArgumentException("table can not be NULL");
        }
        if (modelNode == null) {
            throw new IllegalArgumentException("model node can not be NULL");
        }
        this.table = table;
        this.model = table.getModel();
        this.modelNode = modelNode;
    }

    public boolean isNewEntryPlaceholder() {
        return false;
    }

    public TreeTable getTreeTable() {
        return this.table;
    }

    public ITreeTableModel getModel() {
        return this.model;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    protected void load() {
        this.load(EMPTY_CACHE);
    }

    protected void load(Map<Object, TreeTableNode> tableCache) {
        this.resetTotals();
        int count = this.model.getChildCount(this.modelNode);
        HashMap<Object, TreeTableNode> map = null;
        if (this.children != null) {
            map = new HashMap<Object, TreeTableNode>(this.children.length);
            for (TreeTableNode node : this.children) {
                if (node == null) continue;
                map.put(node.getModelNode(), node);
            }
        }
        this.children = new TreeTableNode[count];
        for (int i = 0; i < count; ++i) {
            Object child = this.model.getChild(this.modelNode, i);
            if (child == null) {
                throw new IllegalArgumentException("child of node can not be NULL but model.getChild(Object parent, int index) returned NULL. parent = " + this.modelNode + ", index = " + i);
            }
            TreeTableNode tableCacheNode = tableCache.get(child);
            if (tableCacheNode != null) {
                this.children[i] = tableCacheNode;
            } else if (map != null) {
                this.children[i] = (TreeTableNode)map.get(child);
            }
            if (this.children[i] == null) {
                this.children[i] = new TreeTableNode(this.table, child);
            }
            this.children[i].setParent(this);
        }
        this.loaded = true;
    }

    public Object getModelNode() {
        return this.modelNode;
    }

    public TreePath getPath() {
        if (this.parent != null) {
            return this.parent.getPath().pathByAddingChild(this.modelNode);
        }
        return new TreePath(this.modelNode);
    }

    public Object getValueAt(int index) {
        return this.model.getColumnValue(this.modelNode, index);
    }

    public Object getKey() {
        return this.model.getKey(this.modelNode);
    }

    protected void setDepth(int depth) {
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    protected void setParent(TreeTableNode parent) {
        this.parent = parent;
        this.setDepth(parent.getDepth() + 1);
    }

    public TreeTableNode getParentNode() {
        return this.parent;
    }

    public boolean isLeaf() {
        return this.model.isLeaf(this.modelNode);
    }

    public int getChildCount() {
        return this.model.getChildCount(this.modelNode);
    }

    public Object getChildAt(int index) {
        return this.model.getChild(this.modelNode, index);
    }

    public TreeTableNode[] getChildren() {
        return this.children;
    }

    public TreeTableNode getChildNode(Object modelChildNode) {
        if (!this.loaded) {
            this.load();
        }
        if (this.children != null) {
            for (TreeTableNode element : this.children) {
                if (element.getModelNode() != modelChildNode) continue;
                return element;
            }
        }
        return null;
    }

    protected void expand() {
        this.expanded = true;
        this.resetTotals();
    }

    protected void collapse() {
        this.expanded = false;
        this.resetTotals();
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public boolean isSelected() {
        return this.table.isPathSelected(this.getPath());
    }

    protected void setRow(int row) {
        this.row = row;
    }

    public int getRow() {
        return this.row;
    }

    public int getHeight() {
        IPolicyProvider provider = this.table.getPolicyProvider();
        IRowPolicy rowPolicy = provider.getPolicy(IRowPolicy.class);
        return rowPolicy.getRowHeight(this.modelNode, this.table.getModel());
    }

    protected void setY(int y) {
        this.y = y;
    }

    public int getY() {
        return this.y;
    }

    public int getTotalChildrenHeight() {
        if (this.childrenHeight == -1) {
            this.childrenHeight = 0;
            if (this.children != null) {
                for (TreeTableNode node : this.children) {
                    this.childrenHeight += node.getHeight();
                    if (!node.isExpanded()) continue;
                    this.childrenHeight += node.getTotalChildrenHeight();
                }
            }
        }
        return this.childrenHeight;
    }

    public int getTotalChildrenCount() {
        if (this.childrenCount == -1) {
            this.childrenCount = 0;
            if (this.children != null) {
                this.childrenCount = this.children.length;
                for (TreeTableNode node : this.children) {
                    if (!node.isExpanded()) continue;
                    this.childrenCount += node.getTotalChildrenCount();
                }
            }
        }
        return this.childrenCount;
    }

    protected void resetTotals() {
        this.childrenCount = -1;
        this.childrenHeight = -1;
        if (this.parent != null) {
            this.parent.resetTotals();
        }
    }

    public Object getNewParentForIndentation() {
        Object parentModelNode;
        int myIndex;
        TreeTableNode parentNode = this.getParentNode();
        if (parentNode != null && (myIndex = this.model.getIndexOfChild(parentModelNode = parentNode.getModelNode(), this.modelNode)) > 0) {
            return this.model.getChild(parentModelNode, myIndex - 1);
        }
        return null;
    }

    public Object getNewParentForOutdentation() {
        TreeTableNode parentNode = this.getParentNode();
        if (parentNode != null && (parentNode = parentNode.getParentNode()) != null) {
            return parentNode.getModelNode();
        }
        return null;
    }
}

