/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.treetable;

import com.dlsc.flexgantt.swing.treetable.TreeTableNode;

public class NodeAnimationController {
    private boolean nodeAnimated = true;
    private int maximumAnimationDuration = 1000;
    private int minimumAnimationDuration = 500;
    private boolean shadowVisible = true;
    private int animationTimePerRow = 50;
    private boolean usingTransparency = true;

    public void setNodeAnimated(boolean animate) {
        this.nodeAnimated = animate;
    }

    public boolean isNodeAnimated(TreeTableNode node) {
        return this.nodeAnimated;
    }

    public void setShadowVisible(boolean visible) {
        this.shadowVisible = visible;
    }

    public boolean isShadowVisible() {
        return this.shadowVisible;
    }

    public void setUsingTransparency(boolean use) {
        this.usingTransparency = use;
    }

    public boolean isUsingTransparency() {
        return this.usingTransparency;
    }

    public void setMaximumAnimationDuration(int millis) {
        this.maximumAnimationDuration = millis;
    }

    public int getMaximumAnimationDuration() {
        return this.maximumAnimationDuration;
    }

    public void setMinimumAnimationDuration(int millis) {
        this.minimumAnimationDuration = millis;
    }

    public int getMinimumAnimationDuration() {
        return this.minimumAnimationDuration;
    }

    public int getAnimationTimePerRow() {
        return this.animationTimePerRow;
    }

    public void setAnimationTimePerRow(int millis) {
        if (millis <= 0) {
            throw new IllegalArgumentException("time must be positive but was " + millis);
        }
        this.animationTimePerRow = millis;
    }

    public int getAnimationDuration(int rowCount) {
        return Math.max(this.minimumAnimationDuration, Math.min(this.maximumAnimationDuration, rowCount * this.animationTimePerRow));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("animate = ");
        sb.append(this.nodeAnimated);
        sb.append(", max duration = ");
        sb.append(this.maximumAnimationDuration);
        sb.append(", min duration = ");
        sb.append(this.minimumAnimationDuration);
        sb.append(", show shadow = ");
        sb.append(this.shadowVisible);
        sb.append(", time per row = ");
        sb.append(this.animationTimePerRow);
        sb.append(", use transparency = ");
        sb.append(this.usingTransparency);
        return sb.toString();
    }
}

