/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.treetable;

import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.model.treetable.ITreeTableModel;
import com.dlsc.flexgantt.swing.treetable.ITreeTableRowHeaderRenderer;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.swing.treetable.TreeTableRowHeader;
import com.dlsc.flexgantt.swing.util.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class DefaultTreeTableRowHeaderRenderer
extends JLabel
implements ITreeTableRowHeaderRenderer {
    private Color focusForeground = ColorUtil.getFocusForeground();
    private Color focusBackground = ColorUtil.getFocusBackground();
    protected Icon createIcon = IconRegistry.getIcon(IconId.CREATE_NODE);
    private Type type = Type.ROW_NUMBER;
    private Icon icon;
    private Icon expandedIcon;
    private Icon collapsedIcon;
    private Icon emptyIcon;
    private boolean showingFocus = true;
    private boolean showingSelection = true;

    public DefaultTreeTableRowHeaderRenderer(Type type) {
        this.type = type;
        this.setHorizontalAlignment(0);
        this.setOpaque(false);
        this.collapsedIcon = UIManager.getIcon("Tree.collapsedIcon");
        this.expandedIcon = UIManager.getIcon("Tree.expandedIcon");
        this.emptyIcon = new EmptyIcon();
    }

    public DefaultTreeTableRowHeaderRenderer() {
        this(Type.ROW_NUMBER);
    }

    public void setExpandedIcon(Icon icon) {
        this.expandedIcon = icon;
    }

    public Icon getExpandedIcon() {
        return this.expandedIcon;
    }

    public void setCollapsedIcon(Icon icon) {
        this.collapsedIcon = icon;
    }

    public Icon getCollapsedIcon() {
        return this.collapsedIcon;
    }

    public Icon getEmptyIcon() {
        return this.emptyIcon;
    }

    @Override
    public Component getRowHeaderRendererComponent(TreeTableRowHeader header, Object node, Object headerValue, int depth, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus, boolean newNodePosition) {
        this.setFont(header.getFont());
        this.setOpaque(hasFocus || selected);
        this.setEnabled(header.isEnabled());
        if (hasFocus && this.showingFocus) {
            this.setForeground(this.focusForeground);
            this.setBackground(this.focusBackground);
        } else if (selected && this.showingSelection) {
            this.setForeground(header.getTreeTable().getForeground(row, true));
            this.setBackground(header.getTreeTable().getBackground(row, true));
        } else {
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
        }
        this.icon = !this.isDisplayedAsLeaf(header.getTreeTable().getModel(), node) ? (expanded ? this.getExpandedIcon() : this.getCollapsedIcon()) : this.getEmptyIcon();
        if (newNodePosition) {
            this.icon = this.createIcon;
        }
        switch (this.type) {
            case ROW_NUMBER: {
                TreeTable table = header.getTreeTable();
                if (row != -1 && table.isRowNumbersVisible()) {
                    this.setText(Integer.toString(row + 1));
                    break;
                }
                this.setText("");
                break;
            }
            case MODEL_OBJECT: {
                this.setText(this.createText(headerValue));
            }
        }
        return this;
    }

    @Override
    public boolean isDisplayedAsLeaf(ITreeTableModel model, Object node) {
        return model.isLeaf(node);
    }

    protected String createText(Object rowHeaderValue) {
        if (rowHeaderValue == null) {
            return "";
        }
        return rowHeaderValue.toString();
    }

    public Icon getCreateIcon() {
        return this.createIcon;
    }

    public void setCreateIcon(Icon icon) {
        this.createIcon = icon;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.getWidth();
        int h = this.getHeight();
        this.icon.paintIcon(this, g, w - this.icon.getIconWidth() - 2, (h - this.icon.getIconHeight()) / 2);
    }

    @Override
    public Rectangle getRowHeaderToggleBounds(TreeTableRowHeader header, int x, int y, int width, int height) {
        Icon icon = this.getEmptyIcon();
        return new Rectangle(x + width - icon.getIconWidth() - 2, y + (height / 2 - icon.getIconHeight() / 2), icon.getIconWidth(), icon.getIconHeight());
    }

    public Color getFocusForeground() {
        return this.focusForeground;
    }

    public void setFocusForeground(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color can not be NULL");
        }
        this.focusForeground = color;
    }

    public Color getFocusBackground() {
        return this.focusBackground;
    }

    public void setFocusBackground(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color can not be NULL");
        }
        this.focusBackground = color;
    }

    public boolean isShowingFocus() {
        return this.showingFocus;
    }

    public void setShowingFocus(boolean showingFocus) {
        this.showingFocus = showingFocus;
    }

    public boolean isShowingSelection() {
        return this.showingSelection;
    }

    public void setShowingSelection(boolean showingSelection) {
        this.showingSelection = showingSelection;
    }

    @Override
    public void validate() {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void repaint(int x, int y, int width, int height) {
    }

    @Override
    public void repaint(long tm) {
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    class EmptyIcon
    implements Icon {
        EmptyIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            Icon exIcon = DefaultTreeTableRowHeaderRenderer.this.getExpandedIcon();
            Icon coIcon = DefaultTreeTableRowHeaderRenderer.this.getCollapsedIcon();
            if (exIcon != null && coIcon != null) {
                return Math.max(DefaultTreeTableRowHeaderRenderer.this.getExpandedIcon().getIconWidth(), DefaultTreeTableRowHeaderRenderer.this.getCollapsedIcon().getIconWidth());
            }
            return 0;
        }

        @Override
        public int getIconHeight() {
            Icon exIcon = DefaultTreeTableRowHeaderRenderer.this.getExpandedIcon();
            Icon coIcon = DefaultTreeTableRowHeaderRenderer.this.getCollapsedIcon();
            if (exIcon != null && coIcon != null) {
                return Math.max(DefaultTreeTableRowHeaderRenderer.this.getExpandedIcon().getIconHeight(), DefaultTreeTableRowHeaderRenderer.this.getCollapsedIcon().getIconHeight());
            }
            return 0;
        }
    }

    public static enum Type {
        ROW_NUMBER,
        MODEL_OBJECT;

    }
}

