/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.timeline;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.dateline.IDatelineModel;
import com.dlsc.flexgantt.model.dateline.IGranularity;
import com.dlsc.flexgantt.policy.layer.IGridPolicy;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.GanttChartControl;
import com.dlsc.flexgantt.swing.IComponentFactory;
import com.dlsc.flexgantt.swing.IGridComponent;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.timeline.Dateline;
import com.dlsc.flexgantt.swing.timeline.Eventline;
import com.dlsc.flexgantt.swing.util.CustomizableLineBorder;
import java.awt.BorderLayout;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class Timeline
extends GanttChartControl
implements MouseListener,
MouseMotionListener {
    public static final Point UNDEF_CURSOR = new Point(-1, -1);
    private Dateline dateline;
    private Eventline eventline;
    private Point cursor = UNDEF_CURSOR;
    private IGranularity cursorGranularity;
    private IGridPolicy cursorGridPolicy;

    public Timeline(AbstractGanttChart ganttChart) {
        super(ganttChart);
        this.setName("Timeline");
        this.setFocusable(false);
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(new CustomizableLineBorder(true, false, true, false));
        IComponentFactory compFactory = ganttChart.getComponentFactory();
        this.dateline = compFactory.createDateline(this);
        this.eventline = compFactory.createEventline(this, this.dateline);
        this.dateline.addMouseListener(this);
        this.dateline.addMouseMotionListener(this);
        this.eventline.addMouseListener(this);
        this.eventline.addMouseMotionListener(this);
        this.add("South", this.eventline);
        this.add("North", this.dateline);
    }

    public Dateline getDateline() {
        return this.dateline;
    }

    public Eventline getEventline() {
        return this.eventline;
    }

    public Point getCursorLocation() {
        return this.cursor;
    }

    public IGranularity getCursorGranularity() {
        return this.cursorGranularity;
    }

    public IGridPolicy getCursorGridPolicy() {
        return this.cursorGridPolicy;
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.cursor = UNDEF_CURSOR;
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.cursor = e.getPoint();
        if (e.getSource() == this.eventline) {
            this.cursor.y += this.dateline.getHeight();
        }
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.cursor = e.getPoint();
        if (e.getSource() == this.eventline) {
            this.cursor.y += this.dateline.getHeight();
        } else if (e.getSource() instanceof LayerContainer) {
            this.cursor.y += this.getHeight();
        }
        if (e.getSource() == this.dateline) {
            this.dateline.repaint();
        }
        if (this.eventline.isVisible()) {
            this.eventline.repaint();
        }
        if (e.getSource() instanceof IGridComponent) {
            IGridComponent comp = (IGridComponent)e.getSource();
            this.cursorGridPolicy = comp.getGridPolicy();
            this.cursorGranularity = comp.isGridAutomatic() ? this.dateline.getModel().getGranularity() : comp.getGridGranularity();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.cursor = e.getPoint();
        if (e.getSource() == this.eventline) {
            this.cursor.y += this.dateline.getHeight();
        }
        this.repaint();
    }

    private long getScrollDuration(boolean fast) {
        IDatelineModel model = this.dateline.getModel();
        ITimeSpan span = model.getTimeSpanAt(0, fast);
        return span.getDuration();
    }

    public void scrollLeft(boolean fast) {
        this.scroll(fast, true);
    }

    public void scrollRight(boolean fast) {
        this.scroll(fast, false);
    }

    private void scroll(boolean fast, boolean left) {
        long d = this.getScrollDuration(fast);
        AbstractGanttChart gc = this.getGanttChart();
        ITimeSpan span = this.dateline.getVisibleTimeSpan();
        span = left ? span.move(-d) : span.move(d);
        gc.showTime(span.getStartTime(), false);
    }
}

