/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.timeline;

import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.timeline.Eventline;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class TimeNowThread
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(TimeNowThread.class.getName());
    private Eventline eventline;
    private boolean running = true;
    private long delay = 1000L;

    public TimeNowThread(AbstractGanttChart gc, long delay) {
        super("FlexGanttTimeNowThread");
        this.delay = delay;
        this.eventline = gc.getTimeline().getEventline();
        this.setDaemon(true);
    }

    public TimeNowThread(AbstractGanttChart gc) {
        this(gc, 1000L);
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long millis) {
        this.delay = millis;
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, "problem in update thread", e);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TimeZone zone = TimeNowThread.this.eventline.getDateline().getTimeZone();
                    long millis = Calendar.getInstance(zone).getTimeInMillis();
                    TimeNowThread.this.eventline.setTimeNow(millis);
                }
            });
        }
    }

    public void stopThread() {
        this.running = false;
    }
}

