/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.timeline;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.dateline.AbstractDatelineModel;
import com.dlsc.flexgantt.model.dateline.DatelineModelEvent;
import com.dlsc.flexgantt.model.dateline.DatelineModelException;
import com.dlsc.flexgantt.model.dateline.DatelineModelVetoException;
import com.dlsc.flexgantt.model.dateline.GridLine;
import com.dlsc.flexgantt.model.dateline.SimpleGranularity;
import com.dlsc.flexgantt.policy.dateline.IZoomPolicy;
import com.dlsc.flexgantt.swing.timeline.Dateline;
import java.awt.Font;
import java.awt.FontMetrics;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimpleGranularityDatelineModel
extends AbstractDatelineModel<SimpleGranularity> {
    private static final Logger LOGGER = Logger.getLogger(SimpleGranularityDatelineModel.class.getName());
    private final List<GridLine> minorGrid = new ArrayList<GridLine>();
    private final List<GridLine> majorGrid = new ArrayList<GridLine>();
    private final NumberFormat numberFormat = NumberFormat.getNumberInstance();
    private HashMap<SimpleGranularity, Integer> widths;
    private final Dateline dateline;
    private int gap = 5;
    private double mpp;

    public SimpleGranularityDatelineModel(Dateline dateline, ITimeSpan timeSpan, SimpleGranularity sg, TimeZone timeZone) throws DatelineModelException {
        super(timeSpan, timeZone);
        if (dateline == null) {
            throw new IllegalArgumentException("dateline can not be NULL");
        }
        if (sg == null) {
            throw new IllegalArgumentException("granularity can not be NULL");
        }
        this.dateline = dateline;
        this.initWidths();
        this.setGranularity(sg);
    }

    public SimpleGranularityDatelineModel(Dateline dateline, ITimeSpan timeSpan, SimpleGranularity sg) throws DatelineModelException {
        this(dateline, timeSpan, sg, TimeZone.getDefault());
    }

    public SimpleGranularityDatelineModel(Dateline dateline, SimpleGranularity sg) throws DatelineModelException {
        this(dateline, new TimeSpan(0L, 1000L), sg, TimeZone.getDefault());
    }

    public SimpleGranularityDatelineModel(Dateline dateline) throws DatelineModelException {
        this(dateline, new TimeSpan(0L, 1000L), SimpleGranularity.ONE, TimeZone.getDefault());
    }

    public SimpleGranularity getMajorSimpleGranularity() {
        return ((SimpleGranularity)this.getGranularity()).next();
    }

    @Override
    protected void calculateDatelineWidth() throws DatelineModelException {
        SimpleGranularity simpleGranularity = (SimpleGranularity)this.getGranularity();
        double delta = simpleGranularity.getDelta(this.timeSpan);
        int width = this.widths.get(simpleGranularity);
        long newWidth = (long)((double)width * delta * this.zoom);
        if (newWidth > Integer.MAX_VALUE) {
            this.applyNewWidth(Integer.MAX_VALUE);
            throw new DatelineModelException("the maximum width of the dateline has been exceeded, width is limited by Integer.MAX_VALUE!", DatelineModelException.ID.MAXIMUM_WIDTH_EXCEEDED);
        }
        this.applyNewWidth((int)newWidth);
    }

    private void applyNewWidth(int width) {
        this.datelineWidth = width;
        LOGGER.fine("datelineWidth = " + this.datelineWidth);
        this.fireDatelineModelChangeEvent(new DatelineModelEvent(this, DatelineModelEvent.ID.DATELINE_WIDTH_CHANGED));
        this.calculateMPPAndPPM();
    }

    @Override
    public List<GridLine> getGrid(int x1, int x2, boolean major) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.finest("getting grid x1 = " + x1 + " x2 = " + x2);
        }
        if (major) {
            return this.getMajorGrid(x1, x2);
        }
        return this.getMinorGrid(x1, x2);
    }

    private List<GridLine> getMinorGrid(int x1, int x2) {
        this.calculateMinorGrid(x1, x2);
        return this.minorGrid;
    }

    private List<GridLine> getMajorGrid(int x1, int x2) {
        this.calculateMajorGrid(x1, x2);
        return this.majorGrid;
    }

    private void calculateMajorGrid(int x1, int x2) {
        if (x1 > x2) {
            throw new IllegalArgumentException("the start x-coordinate can not be larger than the end x-coordinate");
        }
        this.majorGrid.clear();
        SimpleGranularity major = this.getMajorSimpleGranularity();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finer("major = " + major);
        }
        if (major == null) {
            major = (SimpleGranularity)this.getGranularity();
        }
        long time = this.getTimeAt(x1);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finer("time (raw) at x1 = " + time);
        }
        time = major.adjust(time);
        int currentX = this.getTimeLocation(time);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finer("time (adjusted) at x1 = " + time);
            LOGGER.finer("currentX = " + currentX);
        }
        while (currentX < x2) {
            this.majorGrid.add(new GridLine(currentX - 1, time));
            time = major.increment(time);
            currentX = this.getTimeLocation(time);
            if (!LOGGER.isLoggable(Level.FINEST)) continue;
            LOGGER.finer("time (incremented) = " + time);
            LOGGER.finer("currentX = " + currentX);
        }
        this.majorGrid.add(new GridLine(currentX - 1, time));
    }

    private void calculateMinorGrid(int x1, int x2) {
        this.minorGrid.clear();
        SimpleGranularity minor = (SimpleGranularity)this.getGranularity();
        SimpleGranularity major = this.getMajorSimpleGranularity();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finer("minor = " + minor);
            LOGGER.finer("major = " + major);
        }
        long time = this.getTimeAt(x1);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finer("time (raw) at x1 = " + time);
        }
        time = minor.adjust(time);
        int lw = (int)((double)this.widths.get(minor).intValue() * this.zoom);
        int currentX = this.getTimeLocation(time);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finer("time (adjusted) at x1 = " + time);
            LOGGER.finer("level width = " + lw);
            LOGGER.finer("currentX = " + currentX);
        }
        while (currentX < x2 + lw) {
            this.minorGrid.add(new GridLine(currentX - 1, time));
            time = minor.increment(time);
            currentX = this.getTimeLocation(time);
            if (!LOGGER.isLoggable(Level.FINEST)) continue;
            LOGGER.finer("time (incremented) = " + time);
            LOGGER.finer("currentX = " + currentX);
        }
        this.minorGrid.add(new GridLine(currentX - 1, time));
    }

    @Override
    public int getTimeLocation(long time) {
        long startTime = this.timeSpan.getStartTime();
        double x = (double)(time - startTime) / this.mpp;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("time span start time = " + startTime);
            LOGGER.finest("x = " + x);
        }
        if (x > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        if (x < -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        return (int)x;
    }

    @Override
    public long getTimeAt(int x) {
        ITimeSpan span = this.getTimeSpan();
        long millis = (long)((double)x * this.mpp);
        long result = span.getStartTime() + millis;
        return result;
    }

    @Override
    public ITimeSpan getTimeSpanAt(int x, boolean major) {
        long time1;
        SimpleGranularity tg = (SimpleGranularity)this.getGranularity();
        if (major) {
            tg = this.getMajorSimpleGranularity();
        }
        long time2 = time1 = this.getTimeAt(x);
        time1 = tg.adjust(time1);
        time2 = tg.increment(time2);
        time2 = tg.adjust(time2);
        return new TimeSpan(time1, time2);
    }

    private void calculateMPPAndPPM() {
        ITimeSpan span = this.getTimeSpan();
        SimpleGranularity simpleGranularity = (SimpleGranularity)this.getGranularity();
        int width = (int)((double)this.widths.get(simpleGranularity).intValue() * this.zoom);
        long millis = simpleGranularity.getMillis();
        this.mpp = (double)millis / (double)width;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("granularity width = " + width);
            LOGGER.fine("span duration = " + span.getDuration());
            LOGGER.fine("mpp = " + this.mpp);
        }
    }

    @Override
    public void requestVisibleTimeSpan(ITimeSpan span) throws DatelineModelException {
        LOGGER.fine("requested time span = " + span);
        SimpleGranularity oldGranularity = (SimpleGranularity)this.granularity;
        IZoomPolicy dp = this.dateline.getPolicyProvider().getPolicy(IZoomPolicy.class);
        int visibleWidth = this.dateline.getVisibleRect().width;
        SimpleGranularity sg = this.getSimpleGranularity(span, visibleWidth);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("current time span = " + this.timeSpan);
            LOGGER.fine("requested visible time span = " + span);
            LOGGER.fine("total dateline width = " + this.dateline.getWidth());
            LOGGER.fine("currently visible width = " + visibleWidth);
            LOGGER.fine("new granularity = " + sg);
        }
        if (dp.getGranularityIndex(sg) != -1) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("new time granularity is supported");
            }
            double delta = sg.getDelta(span);
            int usedWidth = (int)(delta * (double)this.widths.get(sg).intValue());
            this.zoom = (double)visibleWidth / (double)usedWidth;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("delta = " + delta);
                LOGGER.fine("used width without zooming = " + usedWidth);
                LOGGER.fine("zoom = " + this.zoom);
            }
            this.granularity = sg;
            this.calculateDatelineWidth();
            DatelineModelEvent event = new DatelineModelEvent(this, DatelineModelEvent.ID.REQUESTED_VISIBLE_TIME_SPAN_CHANGED, span);
            try {
                this.fireDatelineModelWillChangeEvent(event);
                this.fireDatelineModelChangeEvent(event);
            }
            catch (DatelineModelVetoException ex) {
                this.granularity = oldGranularity;
                throw new DatelineModelException("the change was rejected by a listener", DatelineModelException.ID.VETO_EXCEPTION);
            }
        } else {
            throw new DatelineModelException("granularity not supported: " + sg, DatelineModelException.ID.REQUESTED_TIME_SPAN_UNSATISFIED);
        }
    }

    private SimpleGranularity getSimpleGranularity(ITimeSpan span, int width) {
        LOGGER.fine("calculating simple granularity");
        long st = span.getStartTime();
        long et = span.getEndTime();
        long millis = et - st;
        for (SimpleGranularity sg : SimpleGranularity.values()) {
            int w = this.widths.get(sg);
            if (millis / sg.getMillis() * (long)w >= (long)width) continue;
            return sg;
        }
        return SimpleGranularity.TRILLION;
    }

    private void initWidths() {
        this.widths = new HashMap();
        Font font = this.dateline.getFont();
        FontMetrics fm = this.dateline.getFontMetrics(font);
        for (SimpleGranularity sg : SimpleGranularity.values()) {
            String str = this.numberFormat.format(sg.getMillis());
            int width = fm.stringWidth(str) + 2 * this.gap;
            this.widths.put(sg, width);
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.fine("granularity = " + sg + " width = " + width + " millis = " + sg.getMillis());
        }
    }

    public String getMajorDateString(SimpleGranularity granularity, long time) {
        return this.numberFormat.format(time);
    }

    public String getMinorDateString(SimpleGranularity granularity, long time) {
        int ordinal = granularity.ordinal();
        SimpleGranularity majorGranularity = granularity;
        if (ordinal < SimpleGranularity.values().length - 1) {
            majorGranularity = SimpleGranularity.values()[ordinal + 1];
        }
        return this.numberFormat.format(time % majorGranularity.getMillis());
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    @Override
    public String getTimeString(long time) {
        return this.numberFormat.format(time);
    }
}

